/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.transport.matchers;

import com.github.fge.lambdas.Throwing;
import java.util.Collection;
import java.util.function.Consumer;
import javax.mail.MessagingException;
import org.apache.james.core.MailAddress;
import org.apache.james.transport.matchers.AtMost;
import org.apache.mailet.Attribute;
import org.apache.mailet.AttributeValue;
import org.apache.mailet.Mail;
import org.apache.mailet.MatcherConfig;
import org.apache.mailet.base.MailAddressFixture;
import org.apache.mailet.base.test.FakeMail;
import org.apache.mailet.base.test.FakeMatcherConfig;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.CollectionAssert;
import org.assertj.core.api.SoftAssertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Nested;
import org.junit.jupiter.api.Test;

class AtMostTest {
    private static final String CONDITION = "2";
    private AtMost matcher;

    AtMostTest() {
    }

    private Mail createMail() throws MessagingException {
        return FakeMail.builder().name("test-message").recipient(MailAddressFixture.RECIPIENT1).build();
    }

    @BeforeEach
    void setup() throws MessagingException {
        this.matcher = new AtMost();
        FakeMatcherConfig matcherConfig = FakeMatcherConfig.builder().matcherName("AtMost").condition(CONDITION).build();
        this.matcher.init((MatcherConfig)matcherConfig);
    }

    @Nested
    class SingleMatcherConfigurationTest {
        SingleMatcherConfigurationTest() {
        }

        @Test
        void shouldMatchWhenAttributeNotSet() throws MessagingException {
            Mail mail = AtMostTest.this.createMail();
            Collection actual = AtMostTest.this.matcher.match(mail);
            Assertions.assertThat((Collection)actual).containsOnly((Object[])new MailAddress[]{MailAddressFixture.RECIPIENT1});
        }

        @Test
        void shouldMatchWhenNoRetries() throws MessagingException {
            Mail mail = AtMostTest.this.createMail();
            mail.setAttribute(new Attribute(AtMost.AT_MOST_EXECUTIONS, AttributeValue.of((Integer)0)));
            Collection actual = AtMostTest.this.matcher.match(mail);
            Assertions.assertThat((Collection)actual).containsOnly((Object[])new MailAddress[]{MailAddressFixture.RECIPIENT1});
        }

        @Test
        void shouldNotMatchWhenOverAtMost() throws MessagingException {
            Mail mail = AtMostTest.this.createMail();
            mail.setAttribute(new Attribute(AtMost.AT_MOST_EXECUTIONS, AttributeValue.of((Integer)3)));
            Collection actual = AtMostTest.this.matcher.match(mail);
            Assertions.assertThat((Collection)actual).isEmpty();
        }

        @Test
        void shouldNotMatchWhenEqualToAtMost() throws MessagingException {
            Mail mail = AtMostTest.this.createMail();
            mail.setAttribute(new Attribute(AtMost.AT_MOST_EXECUTIONS, AttributeValue.of((Integer)2)));
            Collection actual = AtMostTest.this.matcher.match(mail);
            Assertions.assertThat((Collection)actual).isEmpty();
        }

        @Test
        void shouldMatchUntilOverAtMost() throws MessagingException {
            Mail mail = AtMostTest.this.createMail();
            SoftAssertions.assertSoftly((Consumer)Throwing.consumer(softly -> {
                ((CollectionAssert)softly.assertThat(AtMostTest.this.matcher.match(mail)).describedAs("First execution", new Object[0])).contains((Object[])new MailAddress[]{MailAddressFixture.RECIPIENT1});
                ((CollectionAssert)softly.assertThat(AtMostTest.this.matcher.match(mail)).describedAs("Second execution", new Object[0])).contains((Object[])new MailAddress[]{MailAddressFixture.RECIPIENT1});
                ((CollectionAssert)softly.assertThat(AtMostTest.this.matcher.match(mail)).describedAs("Third execution", new Object[0])).isEmpty();
            }));
        }
    }

    @Nested
    class MultipleMatchersConfigurationTest {
        private AtMost atMost2;
        private AtMost atMost3;

        MultipleMatchersConfigurationTest() {
        }

        @BeforeEach
        void setup() throws MessagingException {
            this.atMost2 = new AtMost();
            this.atMost2.init((MatcherConfig)FakeMatcherConfig.builder().matcherName("AtMost").condition("AtMost2:2").build());
            this.atMost3 = new AtMost();
            this.atMost3.init((MatcherConfig)FakeMatcherConfig.builder().matcherName("AtMost").condition("AtMost3:2").build());
        }

        @Test
        void matchersShouldStopWhenAMatcherReachedLimit() throws MessagingException {
            Mail mail1 = AtMostTest.this.createMail();
            SoftAssertions.assertSoftly((Consumer)Throwing.consumer(softly -> {
                softly.assertThat(this.atMost2.match(mail1)).containsOnly((Object[])new MailAddress[]{MailAddressFixture.RECIPIENT1});
                softly.assertThat(this.atMost2.match(mail1)).containsOnly((Object[])new MailAddress[]{MailAddressFixture.RECIPIENT1});
                softly.assertThat(this.atMost2.match(mail1)).isEmpty();
                softly.assertThat(this.atMost3.match(mail1)).containsOnly((Object[])new MailAddress[]{MailAddressFixture.RECIPIENT1});
                softly.assertThat(this.atMost3.match(mail1)).containsOnly((Object[])new MailAddress[]{MailAddressFixture.RECIPIENT1});
                softly.assertThat(this.atMost3.match(mail1)).isEmpty();
            }));
        }
    }

    @Nested
    class InvalidConditionConfigurationTest {
        InvalidConditionConfigurationTest() {
        }

        @Test
        void shouldThrowWhenMatchersConfigWithoutConditionValue() {
            Assertions.assertThatThrownBy(() -> new AtMost().init((MatcherConfig)FakeMatcherConfig.builder().matcherName("NoValueMatcher").condition("randomName:").build())).isInstanceOf(MessagingException.class);
        }

        @Test
        void shouldThrowWhenMatchersConfigWithInvalidConditionValue() {
            Assertions.assertThatThrownBy(() -> new AtMost().init((MatcherConfig)FakeMatcherConfig.builder().matcherName("NoValueMatcher").condition("value").build())).isInstanceOf(MessagingException.class);
        }

        @Test
        void shouldThrowWhenMatchersConfigWithoutConditionName() {
            Assertions.assertThatThrownBy(() -> new AtMost().init((MatcherConfig)FakeMatcherConfig.builder().matcherName("NoValueMatcher").condition(":3").build())).isInstanceOf(IllegalArgumentException.class);
        }

        @Test
        void shouldThrowWhenMatchersConfigNameAsSpace() {
            Assertions.assertThatThrownBy(() -> new AtMost().init((MatcherConfig)FakeMatcherConfig.builder().matcherName("NoValueMatcher").condition("  :  ").build())).isInstanceOf(MessagingException.class);
        }

        @Test
        void shouldThrowWithEmptyCondition() {
            FakeMatcherConfig matcherConfig = FakeMatcherConfig.builder().matcherName("AtMost").build();
            Assertions.assertThatThrownBy(() -> AtMostTest.this.matcher.init((MatcherConfig)matcherConfig)).isInstanceOf(IllegalArgumentException.class);
        }

        @Test
        void shouldThrowWithNegativeCondition() {
            FakeMatcherConfig matcherConfig = FakeMatcherConfig.builder().matcherName("AtMost").condition("-1").build();
            Assertions.assertThatThrownBy(() -> AtMostTest.this.matcher.init((MatcherConfig)matcherConfig)).isInstanceOf(MessagingException.class);
        }

        @Test
        void shouldThrowWithConditionToZero() {
            FakeMatcherConfig matcherConfig = FakeMatcherConfig.builder().matcherName("AtMost").condition("0").build();
            Assertions.assertThatThrownBy(() -> AtMostTest.this.matcher.init((MatcherConfig)matcherConfig)).isInstanceOf(MessagingException.class);
        }
    }
}

