/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.transport.matchers;

import java.util.Collection;
import javax.mail.MessagingException;
import org.apache.mailet.Attribute;
import org.apache.mailet.Mail;
import org.apache.mailet.Matcher;
import org.apache.mailet.MatcherConfig;
import org.apache.mailet.base.GenericMatcher;
import org.apache.mailet.base.test.FakeMail;
import org.apache.mailet.base.test.FakeMatcherConfig;
import org.apache.mailet.base.test.MailUtil;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public abstract class AbstractHasMailAttributeTest {
    FakeMail mockedMail;
    protected Matcher matcher;
    static final Attribute MAIL_ATTRIBUTE = Attribute.convertToAttribute((String)"org.apache.james.test.junit", (Object)"true");
    private Attribute mailAttribute = Attribute.convertToAttribute((String)"org.apache.james", (Object)"false");

    void setMailAttribute(Attribute mailAttribute) {
        this.mailAttribute = mailAttribute;
    }

    void setupMockedMail() throws MessagingException {
        this.mockedMail = MailUtil.createMockMail2Recipients();
        this.mockedMail.setAttribute(this.mailAttribute);
    }

    void setupMatcher() throws MessagingException {
        this.matcher = this.createMatcher();
        FakeMatcherConfig mci = FakeMatcherConfig.builder().matcherName(this.getMatcherName()).condition(this.getHasMailAttribute()).build();
        this.matcher.init((MatcherConfig)mci);
    }

    @Test
    public void testAttributeIsMatched() throws MessagingException {
        this.init();
        this.setupAll();
        Collection matchedRecipients = this.matcher.match((Mail)this.mockedMail);
        org.junit.jupiter.api.Assertions.assertNotNull((Object)matchedRecipients);
        Assertions.assertThat((int)this.mockedMail.getRecipients().size()).isEqualTo(matchedRecipients.size());
    }

    protected void init() {
        this.setMailAttribute(MAIL_ATTRIBUTE);
    }

    void setupAll() throws MessagingException {
        this.setupMockedMail();
        this.setupMatcher();
    }

    @Test
    public void testAttributeIsNotMatched() throws MessagingException {
        this.setupAll();
        Collection matchedRecipients = this.matcher.match((Mail)this.mockedMail);
        org.junit.jupiter.api.Assertions.assertNull((Object)matchedRecipients);
    }

    protected abstract String getHasMailAttribute();

    protected abstract GenericMatcher createMatcher();

    protected abstract String getMatcherName();
}

