/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.transport.mailets.utils;

import java.util.List;
import java.util.Optional;
import java.util.Properties;
import javax.mail.Session;
import javax.mail.internet.MimeMessage;
import org.apache.james.core.builder.MimeMessageBuilder;
import org.apache.james.transport.mailets.utils.MimeMessageUtils;
import org.apache.mailet.Mail;
import org.apache.mailet.base.test.FakeMail;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class MimeMessageUtilsTest {
    @Test
    public void subjectWithPrefixShouldReturnSubjectWithPrefixWhenSubjectIsPresent() throws Exception {
        MimeMessage message = new MimeMessage(Session.getDefaultInstance((Properties)new Properties()));
        message.setSubject("subject");
        Optional subjectWithPrefix = new MimeMessageUtils(message).subjectWithPrefix("my");
        Assertions.assertThat((Optional)subjectWithPrefix).contains((Object)"my subject");
    }

    @Test
    public void subjectWithPrefixShouldReturnPrefixAsSubjectWhenSubjectIsAbsent() throws Exception {
        MimeMessage message = new MimeMessage(Session.getDefaultInstance((Properties)new Properties()));
        Optional subjectWithPrefix = new MimeMessageUtils(message).subjectWithPrefix("my");
        Assertions.assertThat((Optional)subjectWithPrefix).contains((Object)"my");
    }

    @Test
    public void subjectWithPrefixShouldReturnAbsentWhenNullPrefix() throws Exception {
        MimeMessage message = new MimeMessage(Session.getDefaultInstance((Properties)new Properties()));
        message.setSubject("original subject");
        FakeMail oldMail = FakeMail.from((MimeMessage)message);
        String subjectPrefix = null;
        String subject = null;
        Optional subjectWithPrefix = new MimeMessageUtils(message).subjectWithPrefix(subjectPrefix, (Mail)oldMail, subject);
        Assertions.assertThat((Optional)subjectWithPrefix).isEmpty();
    }

    @Test
    public void subjectWithPrefixShouldReturnAbsentWhenEmptyPrefix() throws Exception {
        MimeMessage message = new MimeMessage(Session.getDefaultInstance((Properties)new Properties()));
        message.setSubject("original subject");
        FakeMail oldMail = FakeMail.from((MimeMessage)message);
        String subjectPrefix = "";
        String subject = null;
        Optional subjectWithPrefix = new MimeMessageUtils(message).subjectWithPrefix(subjectPrefix, (Mail)oldMail, subject);
        Assertions.assertThat((Optional)subjectWithPrefix).isEmpty();
    }

    @Test
    public void buildNewSubjectShouldPrefixOriginalSubjectWhenSubjectIsNull() throws Exception {
        MimeMessage message = new MimeMessage(Session.getDefaultInstance((Properties)new Properties()));
        String prefix = "prefix";
        String originalSubject = "original subject";
        Optional newSubject = new MimeMessageUtils(message).buildNewSubject(prefix, originalSubject, null);
        Assertions.assertThat((Optional)newSubject).contains((Object)(prefix + " " + originalSubject));
    }

    @Test
    public void buildNewSubjectShouldPrefixNewSubjectWhenSubjectIsGiven() throws Exception {
        MimeMessage message = new MimeMessage(Session.getDefaultInstance((Properties)new Properties()));
        String prefix = "prefix";
        String originalSubject = "original subject";
        String subject = "new subject";
        Optional newSubject = new MimeMessageUtils(message).buildNewSubject(prefix, originalSubject, subject);
        Assertions.assertThat((Optional)newSubject).contains((Object)(prefix + " " + subject));
    }

    @Test
    public void buildNewSubjectShouldReplaceSubjectWhenPrefixIsNull() throws Exception {
        MimeMessage message = new MimeMessage(Session.getDefaultInstance((Properties)new Properties()));
        String prefix = null;
        String originalSubject = "original subject";
        String subject = "new subject";
        Optional newSubject = new MimeMessageUtils(message).buildNewSubject(prefix, originalSubject, subject);
        Assertions.assertThat((Optional)newSubject).contains((Object)subject);
    }

    @Test
    public void buildNewSubjectShouldReplaceSubjectWhenPrefixIsEmpty() throws Exception {
        MimeMessage message = new MimeMessage(Session.getDefaultInstance((Properties)new Properties()));
        String prefix = "";
        String originalSubject = "original subject";
        String subject = "new subject";
        Optional newSubject = new MimeMessageUtils(message).buildNewSubject(prefix, originalSubject, subject);
        Assertions.assertThat((Optional)newSubject).contains((Object)subject);
    }

    @Test
    public void buildNewSubjectShouldReplaceSubjectWithPrefixWhenSubjectIsEmpty() throws Exception {
        MimeMessage message = new MimeMessage(Session.getDefaultInstance((Properties)new Properties()));
        String prefix = "prefix";
        String originalSubject = "original subject";
        String subject = "";
        Optional newSubject = new MimeMessageUtils(message).buildNewSubject(prefix, originalSubject, subject);
        Assertions.assertThat((Optional)newSubject).contains((Object)prefix);
    }

    @Test
    public void getMessageHeadersShouldReturnEmptyStringWhenNoHeaders() throws Exception {
        MimeMessage message = new MimeMessage(Session.getDefaultInstance((Properties)new Properties()));
        String messageHeaders = new MimeMessageUtils(message).getMessageHeaders();
        Assertions.assertThat((String)messageHeaders).isEmpty();
    }

    @Test
    public void getMessageHeadersShouldHeadersWhenSome() throws Exception {
        MimeMessage message = new MimeMessage(Session.getDefaultInstance((Properties)new Properties()));
        message.addHeader("first", "value");
        message.addHeader("second", "value2");
        String messageHeaders = new MimeMessageUtils(message).getMessageHeaders();
        String expectedHeaders = "first: value\r\nsecond: value2\r\n";
        Assertions.assertThat((String)messageHeaders).isEqualTo(expectedHeaders);
    }

    @Test
    public void toHeaderListShouldReturnMessageIdAndMimeVersionByDefault() throws Exception {
        Assertions.assertThat((List)new MimeMessageUtils(MimeMessageBuilder.mimeMessageBuilder().build()).toHeaderList()).extracting("name").contains(new Object[]{"Message-Id", "MIME-Version"});
    }

    @Test
    public void toHeaderListShouldReturnAllMessageHeaders() throws Exception {
        String headerName = "X-OPENPAAS-FEATURE-1";
        Assertions.assertThat((List)new MimeMessageUtils(MimeMessageBuilder.mimeMessageBuilder().addHeader(headerName, "value").build()).toHeaderList()).extracting("name").containsOnly(new Object[]{"Message-Id", "MIME-Version", headerName, "Date", "Content-Type", "Content-Transfer-Encoding"});
    }
}

