/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.transport.mailets.utils;

import java.util.Optional;
import javax.mail.internet.MimeMessage;
import org.apache.james.core.builder.MimeMessageBuilder;
import org.apache.james.transport.mailets.utils.MimeMessageModifier;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class MimeMessageModifierTest {
    @Test
    public void replaceSubjectShouldReplaceTheSubjectWhenSubjectIsPresent() throws Exception {
        MimeMessage message = MimeMessageBuilder.mimeMessageBuilder().setSubject("subject").build();
        String expectedSubject = "new subject";
        new MimeMessageModifier(message).replaceSubject(Optional.of(expectedSubject));
        Assertions.assertThat((String)message.getSubject()).isEqualTo(expectedSubject);
    }

    @Test
    public void replaceSubjectShouldNotAlterTheSubjectWhenSubjectIsAbsent() throws Exception {
        String expectedSubject = "subject";
        MimeMessage message = MimeMessageBuilder.mimeMessageBuilder().setSubject(expectedSubject).build();
        new MimeMessageModifier(message).replaceSubject(Optional.empty());
        Assertions.assertThat((String)message.getSubject()).isEqualTo(expectedSubject);
    }
}

