/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.transport.mailets;

import java.util.Collection;
import java.util.List;
import org.apache.james.core.MailAddress;
import org.apache.james.core.builder.MimeMessageBuilder;
import org.apache.james.transport.mailets.UseHeaderRecipients;
import org.apache.james.util.MimeMessageUtil;
import org.apache.mailet.Mail;
import org.apache.mailet.MailetConfig;
import org.apache.mailet.MailetContext;
import org.apache.mailet.base.MailAddressFixture;
import org.apache.mailet.base.test.FakeMail;
import org.apache.mailet.base.test.FakeMailContext;
import org.apache.mailet.base.test.FakeMailetConfig;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

class UseHeaderRecipientsTest {
    private static final String RECIPIENT1 = "abc1@apache1.org";
    private static final String RECIPIENT2 = "abc2@apache2.org";
    private static final String RECIPIENT3 = "abc3@apache3.org";
    private UseHeaderRecipients testee;
    private FakeMailContext mailetContext;
    private MailAddress mailAddress1;
    private MailAddress mailAddress2;
    private MailAddress mailAddress3;

    UseHeaderRecipientsTest() {
    }

    @BeforeEach
    void setUp() throws Exception {
        this.testee = new UseHeaderRecipients();
        this.mailetContext = FakeMailContext.defaultContext();
        this.testee.init((MailetConfig)FakeMailetConfig.builder().mailetContext((MailetContext)this.mailetContext).build());
        this.mailAddress1 = new MailAddress(RECIPIENT1);
        this.mailAddress2 = new MailAddress(RECIPIENT2);
        this.mailAddress3 = new MailAddress(RECIPIENT3);
    }

    @Test
    void serviceShouldSetMimeMessageRecipients() throws Exception {
        FakeMail fakeMail = FakeMail.builder().name("mail").recipients(new MailAddress[]{MailAddressFixture.ANY_AT_JAMES, MailAddressFixture.ANY_AT_JAMES2}).mimeMessage(MimeMessageBuilder.mimeMessageBuilder().addToRecipient(new String[]{RECIPIENT1, RECIPIENT2})).build();
        this.testee.service((Mail)fakeMail);
        Assertions.assertThat((Collection)fakeMail.getRecipients()).containsOnly((Object[])new MailAddress[]{this.mailAddress1, this.mailAddress2});
    }

    @Test
    void serviceShouldSetToCcAndBccSpecifiedInTheMimeMessage() throws Exception {
        FakeMail fakeMail = FakeMail.builder().name("mail").recipients(new MailAddress[]{MailAddressFixture.ANY_AT_JAMES}).mimeMessage(MimeMessageBuilder.mimeMessageBuilder().addToRecipient(RECIPIENT1).addCcRecipient(RECIPIENT2).addBccRecipient(RECIPIENT3)).build();
        this.testee.service((Mail)fakeMail);
        Assertions.assertThat((Collection)fakeMail.getRecipients()).containsOnly((Object[])new MailAddress[]{this.mailAddress1, this.mailAddress2, this.mailAddress3});
    }

    @Test
    void serviceShouldSetEmptyRecipientWhenNoRecipientsInTheMimeMessage() throws Exception {
        FakeMail fakeMail = FakeMail.builder().name("mail").recipients(new MailAddress[]{MailAddressFixture.ANY_AT_JAMES}).mimeMessage(MimeMessageUtil.defaultMimeMessage()).build();
        this.testee.service((Mail)fakeMail);
        Assertions.assertThat((Collection)fakeMail.getRecipients()).isEmpty();
    }

    @Test
    void serviceShouldGhostEmail() throws Exception {
        FakeMail fakeMail = FakeMail.builder().name("mail").recipients(new MailAddress[]{MailAddressFixture.ANY_AT_JAMES}).mimeMessage(MimeMessageUtil.defaultMimeMessage()).build();
        this.testee.service((Mail)fakeMail);
        Assertions.assertThat((String)fakeMail.getState()).isEqualTo("ghost");
    }

    @Test
    void serviceShouldResendTheEmail() throws Exception {
        FakeMail fakeMail = FakeMail.builder().name("mail").recipients(new MailAddress[]{MailAddressFixture.ANY_AT_JAMES}).mimeMessage(MimeMessageBuilder.mimeMessageBuilder().addToRecipient(RECIPIENT1).addCcRecipient(RECIPIENT2).addBccRecipient(RECIPIENT3)).build();
        this.testee.service((Mail)fakeMail);
        Assertions.assertThat((List)this.mailetContext.getSentMails()).containsOnly((Object[])new FakeMailContext.SentMail[]{FakeMailContext.sentMailBuilder().recipients(new MailAddress[]{this.mailAddress1, this.mailAddress2, this.mailAddress3}).fromMailet().build()});
    }

    @Test
    void serviceShouldThrowOnInvalidMailAddress() throws Exception {
        FakeMail fakeMail = FakeMail.builder().name("mail").recipients(new MailAddress[]{this.mailAddress1}).mimeMessage(MimeMessageBuilder.mimeMessageBuilder().addToRecipient("invalid")).build();
        Assertions.assertThatThrownBy(() -> this.testee.service((Mail)fakeMail)).isInstanceOf(RuntimeException.class);
    }

    @Test
    void serviceShouldSupportAddressList() throws Exception {
        FakeMail fakeMail = FakeMail.builder().name("mail").recipients().mimeMessage(MimeMessageBuilder.mimeMessageBuilder().addToRecipient(new String[]{RECIPIENT1, RECIPIENT2})).build();
        this.testee.service((Mail)fakeMail);
        Assertions.assertThat((Collection)fakeMail.getRecipients()).containsOnly((Object[])new MailAddress[]{this.mailAddress1, this.mailAddress2});
    }

    @Test
    void serviceShouldSupportMailboxes() throws Exception {
        FakeMail fakeMail = FakeMail.builder().name("mail").recipients().mimeMessage(MimeMessageBuilder.mimeMessageBuilder().addToRecipient("APACHE<abc1@apache1.org>")).build();
        this.testee.service((Mail)fakeMail);
        Assertions.assertThat((Collection)fakeMail.getRecipients()).containsOnly((Object[])new MailAddress[]{this.mailAddress1});
    }
}

