/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.transport.mailets;

import org.apache.james.transport.mailets.UnwrapText;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class UnwrapTextTest {
    @Test
    public void testUnwrap() {
        Assertions.assertThat((String)UnwrapText.unwrap((String)"")).isEqualTo("");
        Assertions.assertThat((String)UnwrapText.unwrap((String)"a")).isEqualTo("a");
        String input = "Prova per vedere se effettivamente il testo viene wrappato\r\ncome dovrebbe.\r\nChiss\u00e0 se funziona davvero\r\no se va solo come gli pare";
        String output = "Prova per vedere se effettivamente il testo viene wrappato come dovrebbe.\r\nChiss\u00e0 se funziona davvero\r\no se va solo come gli pare";
        Assertions.assertThat((String)UnwrapText.unwrap((String)input)).isEqualTo(output);
        input = "> Prova per vedere se effettivamente il testo viene wrappato\r\n> come dovrebbe.\r\n> Chiss\u00e0 se funziona davvero\r\n> o se va solo come gli pare";
        output = "> Prova per vedere se effettivamente il testo viene wrappato come dovrebbe.\r\n> Chiss\u00e0 se funziona davvero\r\n> o se va solo come gli pare";
        Assertions.assertThat((String)UnwrapText.unwrap((String)input)).isEqualTo(output);
        input = "> Prova per vedere se effettivamente il testo viene wrappato\r\n> come dovrebbe.\r\n> Chiss\u00e0 se funziona davvero\r\n> o se va solo come gli pare\r\n> Prova per vedere se effettivamente il testo viene wrappato\r\n> come dovrebbe.\r\n";
        output = "> Prova per vedere se effettivamente il testo viene wrappato come dovrebbe.\r\n> Chiss\u00e0 se funziona davvero\r\n> o se va solo come gli pare\r\n> Prova per vedere se effettivamente il testo viene wrappato come dovrebbe.\r\n";
        Assertions.assertThat((String)UnwrapText.unwrap((String)input)).isEqualTo(output);
        input = "> volevo chiedervi un piccolo aiutino. Una signora con un circolare ha un\r\n> dente che si \u00e8 scementato. Il cemento usato per la cementazione \u00e8\r\n> l'harvard.  Il problema \u00e8 che non riesco a decementarlo. Avete qualche\r\n> trucco da  suggerirmi per rimuovere il ponte? Il ponte \u00e8 in ceramica, per\r\n> cui  l'utilizzo degli ultrasuoni puo' essere rischioso (?).\r\n";
        output = "> volevo chiedervi un piccolo aiutino. Una signora con un circolare ha un dente che si \u00e8 scementato. Il cemento usato per la cementazione \u00e8 l'harvard.  Il problema \u00e8 che non riesco a decementarlo. Avete qualche trucco da  suggerirmi per rimuovere il ponte? Il ponte \u00e8 in ceramica, per cui  l'utilizzo degli ultrasuoni puo' essere rischioso (?).\r\n";
        Assertions.assertThat((String)UnwrapText.unwrap((String)input)).isEqualTo(output);
        input = "> Prova per vedere se effettivamente il testo viene wrappato\r\n> com dovrebbe.\r\n> Prova per vedere se effettivamente il testo viene wrappato\r\ncome\r\n> dovrebbe.\r\n";
        output = "> Prova per vedere se effettivamente il testo viene wrappato com dovrebbe.\r\n> Prova per vedere se effettivamente il testo viene wrappato come dovrebbe.\r\n";
        Assertions.assertThat((String)UnwrapText.unwrap((String)input)).isEqualTo(output);
        input = "> Prova per vedere se effettivamente il testo viene wrappato\r\n> com dovrebbe.\r\n> Prova per vedere se effettivamente il testo viene wrappato\r\ncome\r\n>> dovrebbe.\r\n";
        output = "> Prova per vedere se effettivamente il testo viene wrappato com dovrebbe.\r\n> Prova per vedere se effettivamente il testo viene wrappato come\r\n>> dovrebbe.\r\n";
        Assertions.assertThat((String)UnwrapText.unwrap((String)input)).isEqualTo(output);
        input = "> Prova per vedere se effettivamente il testo viene wrappato\r\n> com dovrebbe.\r\n> Prova per vedere se effettivamente il testo viene wrappato\r\ncome dovrebbe.\r\n";
        output = "> Prova per vedere se effettivamente il testo viene wrappato com dovrebbe.\r\n> Prova per vedere se effettivamente il testo viene wrappato\r\ncome dovrebbe.\r\n";
        Assertions.assertThat((String)UnwrapText.unwrap((String)input)).isEqualTo(output);
        input = "...pero' devo dire che ai congressi vedo moltissimi casi di carico\r\nimmediato, \r\nspesso circolari superiore e inferiore, con estrazione di denti\r\n\"parodontosici\" che io terrei li per altri 15 anni...\r\nNon voglio polemizzare ne tantomento accusare nessuno, ma credo che spesso a\r\naccada quello che Alessio suggerisce...\r\n";
        output = "...pero' devo dire che ai congressi vedo moltissimi casi di carico immediato, \r\nspesso circolari superiore e inferiore, con estrazione di denti\r\n\"parodontosici\" che io terrei li per altri 15 anni...\r\nNon voglio polemizzare ne tantomento accusare nessuno, ma credo che spesso a accada quello che Alessio suggerisce...\r\n";
        Assertions.assertThat((String)UnwrapText.unwrap((String)input)).isEqualTo(output);
        input = "> mi trovo in difficolta,ho eseguito un lavoro di protesizzazione in\r\nporcellana\r\n> su 24 25 26 premetto che i denti sottostanti erano pieni di otturazioni in\r\n> amalgama ,la giovane paziente ,protesta perche sul 24 c'\u00e8 un leggero\r\ndeficit\r\n> di chiusura,esteticamente visibile ma sicuramente la sua reazione \u00e8\r\n> sproporzionata,ha un atteggiamento rivendicativo come se l'avessi\r\n> triffata,rifiuta un allungamenti con compositi ceramici .io sono convinto\r\nche\r\n> a tirar giu il lavoro anche con tutte le cautele del caso rischio la\r\nrottura\r\n";
        output = "> mi trovo in difficolta,ho eseguito un lavoro di protesizzazione in porcellana su 24 25 26 premetto che i denti sottostanti erano pieni di otturazioni in amalgama ,la giovane paziente ,protesta perche sul 24 c'\u00e8 un leggero deficit di chiusura,esteticamente visibile ma sicuramente la sua reazione \u00e8 sproporzionata,ha un atteggiamento rivendicativo come se l'avessi triffata,rifiuta un allungamenti con compositi ceramici .io sono convinto che a tirar giu il lavoro anche con tutte le cautele del caso rischio la rottura\r\n";
        Assertions.assertThat((String)UnwrapText.unwrap((String)input, (int)79)).isEqualTo(output);
        input = "Prova per vedere se effettivamente il testo viene wrappato\r\ncome dovrebbe. \r\nChiss\u00e0 se funziona davvero \r\no se va solo come gli pare \r\n> Prova per vedere se effettivamente il testo viene wrappato \r\ncome \r\n> dovrebbe. \r\n";
        output = "Prova per vedere se effettivamente il testo viene wrappato come dovrebbe. \r\nChiss\u00e0 se funziona davvero \r\no se va solo come gli pare \r\n> Prova per vedere se effettivamente il testo viene wrappato come dovrebbe. \r\n";
        Assertions.assertThat((String)UnwrapText.unwrap((String)input, (int)79)).isEqualTo(output);
    }
}

