/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.transport.mailets;

import javax.mail.MessagingException;
import org.apache.james.core.MailAddress;
import org.apache.james.transport.mailets.ToProcessor;
import org.apache.mailet.Mail;
import org.apache.mailet.Mailet;
import org.apache.mailet.MailetConfig;
import org.apache.mailet.MailetContext;
import org.apache.mailet.MailetException;
import org.apache.mailet.base.test.FakeMail;
import org.apache.mailet.base.test.FakeMailContext;
import org.apache.mailet.base.test.FakeMailetConfig;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.slf4j.Logger;

class ToProcessorTest {
    private Mailet mailet;
    private FakeMailContext mailContext;

    ToProcessorTest() {
    }

    @BeforeEach
    void setup() {
        this.mailet = new ToProcessor();
        Logger logger = (Logger)Mockito.mock(Logger.class);
        this.mailContext = FakeMailContext.builder().logger(logger).build();
    }

    @Test
    void getMailetInfoShouldReturnValue() {
        Assertions.assertThat((String)this.mailet.getMailetInfo()).isEqualTo("ToProcessor Mailet");
    }

    @Test
    void initShouldThrowWhenProcessorIsNotGiven() {
        FakeMailetConfig mailetConfig = FakeMailetConfig.builder().mailetName("Test").mailetContext((MailetContext)this.mailContext).setProperty("notice", "error in message").build();
        Assertions.assertThatThrownBy(() -> this.mailet.init((MailetConfig)mailetConfig)).isInstanceOf(MailetException.class);
    }

    @Test
    void serviceShouldSetTheStateOfTheMail() throws MessagingException {
        String processor = "error";
        FakeMailetConfig mailetConfig = FakeMailetConfig.builder().mailetName("Test").mailetContext((MailetContext)this.mailContext).setProperty("processor", processor).build();
        this.mailet.init((MailetConfig)mailetConfig);
        FakeMail mail = FakeMail.builder().name("mail").recipients(new MailAddress[]{new MailAddress("test@james.apache.org"), new MailAddress("test2@james.apache.org")}).build();
        this.mailet.service((Mail)mail);
        Assertions.assertThat((String)mail.getState()).isEqualTo(processor);
    }

    @Test
    void serviceShouldSetTheErrorMessageOfTheMailWhenNotAlreadySet() throws MessagingException {
        String processor = "error";
        String notice = "error in message";
        FakeMailetConfig mailetConfig = FakeMailetConfig.builder().mailetName("Test").mailetContext((MailetContext)this.mailContext).setProperty("processor", processor).setProperty("notice", notice).build();
        this.mailet.init((MailetConfig)mailetConfig);
        FakeMail mail = FakeMail.builder().name("mail").recipients(new MailAddress[]{new MailAddress("test@james.apache.org"), new MailAddress("test2@james.apache.org")}).build();
        this.mailet.service((Mail)mail);
        Assertions.assertThat((String)mail.getErrorMessage()).isEqualTo(notice);
    }

    @Test
    void serviceShouldAppendTheErrorMessageOfTheMailWhenSomeErrorMessageOnMail() throws MessagingException {
        String processor = "error";
        String notice = "error in message";
        FakeMailetConfig mailetConfig = FakeMailetConfig.builder().mailetName("Test").mailetContext((MailetContext)this.mailContext).setProperty("processor", processor).setProperty("notice", notice).build();
        this.mailet.init((MailetConfig)mailetConfig);
        FakeMail mail = FakeMail.builder().name("mail").recipients(new MailAddress[]{new MailAddress("test@james.apache.org"), new MailAddress("test2@james.apache.org")}).build();
        String initialErrorMessage = "first";
        mail.setErrorMessage(initialErrorMessage);
        this.mailet.service((Mail)mail);
        Assertions.assertThat((String)mail.getErrorMessage()).isEqualTo(initialErrorMessage + "\r\n" + notice);
    }
}

