/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.transport.mailets;

import com.github.fge.lambdas.Throwing;
import com.github.fge.lambdas.consumers.ConsumerChainer;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import javax.mail.BodyPart;
import javax.mail.MessagingException;
import javax.mail.Part;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import org.apache.commons.io.IOUtils;
import org.apache.james.core.builder.MimeMessageBuilder;
import org.apache.james.junit.TemporaryFolderExtension;
import org.apache.james.transport.mailets.StripAttachment;
import org.apache.mailet.AttributeName;
import org.apache.mailet.AttributeUtils;
import org.apache.mailet.AttributeValue;
import org.apache.mailet.Mail;
import org.apache.mailet.Mailet;
import org.apache.mailet.MailetConfig;
import org.apache.mailet.MailetException;
import org.apache.mailet.base.test.FakeMail;
import org.apache.mailet.base.test.FakeMailetConfig;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.MapAssert;
import org.assertj.core.api.OptionalAssert;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.Mockito;

@ExtendWith(value={TemporaryFolderExtension.class})
class StripAttachmentTest {
    private static Class<Collection<AttributeValue<String>>> COLLECTION_STRING_CLASS = Collection.class;
    private static Class<Map<String, AttributeValue<?>>> MAP_STRING_BYTES_CLASS = Map.class;
    private static final String EXPECTED_ATTACHMENT_CONTENT = "#\u00a4\u00e3\u00e0\u00e9";
    private static final Optional<String> ABSENT_MIME_TYPE = Optional.empty();
    private static final String CONTENT_TRANSFER_ENCODING_VALUE = "8bit";
    private static final String CONTENT_TRANSFER_ENCODING = "Content-Transfer-Encoding";
    private static final String CONTENT_TYPE = "Content-Type";
    private static final String CONTENT_TYPE_DEFAULT = "application/octet-stream; charset=utf-8";
    private static final String TEXT_CALENDAR_CHARSET_UTF_8 = "text/calendar; charset=utf-8";
    private static final String TEXT_HTML_CHARSET_UTF_8 = "text/html; charset=utf-8";
    private static final MimeMessageBuilder.Header[] TEXT_HEADERS = new MimeMessageBuilder.Header[]{new MimeMessageBuilder.Header("Content-Transfer-Encoding", "8bit"), new MimeMessageBuilder.Header("Content-Type", "application/octet-stream; charset=utf-8")};
    private static final MimeMessageBuilder.Header[] HTML_HEADERS = new MimeMessageBuilder.Header[]{new MimeMessageBuilder.Header("Content-Transfer-Encoding", "8bit"), new MimeMessageBuilder.Header("Content-Type", "text/html; charset=utf-8")};
    private static final MimeMessageBuilder.Header[] CALENDAR_HEADERS = new MimeMessageBuilder.Header[]{new MimeMessageBuilder.Header("Content-Transfer-Encoding", "8bit"), new MimeMessageBuilder.Header("Content-Type", "text/calendar; charset=utf-8")};

    StripAttachmentTest() {
    }

    @Test
    void serviceShouldNotModifyMailWhenNotMultipart(TemporaryFolderExtension.TemporaryFolder temporaryFolder) throws MessagingException, IOException {
        Mailet mailet = this.initMailet(temporaryFolder);
        MimeMessageBuilder message = MimeMessageBuilder.mimeMessageBuilder().setSubject("test").setText("simple text");
        MimeMessageBuilder expectedMessage = MimeMessageBuilder.mimeMessageBuilder().setSubject("test").setText("simple text");
        FakeMail mail = FakeMail.fromMessage((MimeMessageBuilder)message);
        FakeMail expectedMail = FakeMail.fromMessage((MimeMessageBuilder)expectedMessage);
        mailet.service((Mail)mail);
        Assertions.assertThat((Object)mail).usingRecursiveComparison().ignoringFields(new String[]{"msg"}).isEqualTo((Object)expectedMail);
        Assertions.assertThat((Object)mail.getMessage().getContent()).isEqualTo((Object)"simple text");
    }

    @Test
    void serviceShouldSaveAttachmentInAFolderWhenPatternMatch(TemporaryFolderExtension.TemporaryFolder temporaryFolder) throws MessagingException {
        Mailet mailet = this.initMailet(temporaryFolder);
        String expectedAttachmentContent = EXPECTED_ATTACHMENT_CONTENT;
        MimeMessageBuilder message = MimeMessageBuilder.mimeMessageBuilder().setMultipartWithBodyParts(new MimeMessageBuilder.BodyPartBuilder[]{MimeMessageBuilder.bodyPartBuilder().data("simple text"), this.createAttachmentBodyPart(expectedAttachmentContent, "10.tmp", TEXT_HEADERS), this.createAttachmentBodyPart("\u0014\u00a3\u00e1\u00e2\u00e4", "temp.zip", TEXT_HEADERS)});
        FakeMail mail = FakeMail.fromMessage((MimeMessageBuilder)message);
        mailet.service((Mail)mail);
        Optional savedAttachments = AttributeUtils.getValueAndCastFromMail((Mail)mail, (AttributeName)StripAttachment.SAVED_ATTACHMENTS, COLLECTION_STRING_CLASS);
        ((OptionalAssert)Assertions.assertThat((Optional)savedAttachments).isPresent()).hasValueSatisfying(attachments -> {
            Assertions.assertThat((Collection)attachments).hasSize(1);
            String attachmentFilename = (String)((AttributeValue)attachments.iterator().next()).value();
            Assertions.assertThat((File)new File(temporaryFolder.getFolderPath() + attachmentFilename)).hasContent(expectedAttachmentContent);
        });
    }

    @Test
    void serviceShouldRemoveWhenMimeTypeMatches() throws MessagingException {
        FakeMailetConfig mci = FakeMailetConfig.builder().mailetName("Test").setProperty("mimeType", "text/calendar").setProperty("remove", "matched").build();
        StripAttachment mailet = new StripAttachment();
        mailet.init((MailetConfig)mci);
        String expectedFileName = "10.ical";
        MimeMessageBuilder message = MimeMessageBuilder.mimeMessageBuilder().setMultipartWithBodyParts(new MimeMessageBuilder.BodyPartBuilder[]{MimeMessageBuilder.bodyPartBuilder().data("simple text"), this.createAttachmentBodyPart("content", expectedFileName, CALENDAR_HEADERS), this.createAttachmentBodyPart("other content", "11.ical", TEXT_HEADERS), this.createAttachmentBodyPart("<p>html</p>", "index.html", HTML_HEADERS)});
        FakeMail mail = FakeMail.fromMessage((MimeMessageBuilder)message);
        mailet.service((Mail)mail);
        Optional removedAttachments = AttributeUtils.getValueAndCastFromMail((Mail)mail, (AttributeName)StripAttachment.REMOVED_ATTACHMENTS, COLLECTION_STRING_CLASS);
        ((OptionalAssert)Assertions.assertThat((Optional)removedAttachments).isPresent()).hasValueSatisfying(attachments -> Assertions.assertThat((Collection)attachments).containsOnly((Object[])new AttributeValue[]{AttributeValue.of((String)expectedFileName)}));
    }

    private MimeMessageBuilder.BodyPartBuilder createAttachmentBodyPart(String body, String fileName, MimeMessageBuilder.Header ... headers) {
        return MimeMessageBuilder.bodyPartBuilder().data(body).addHeaders(headers).disposition("attachment").filename(fileName);
    }

    @Test
    void serviceShouldSaveAttachmentInAFolderWhenNotPatternDoesntMatch(TemporaryFolderExtension.TemporaryFolder temporaryFolder) throws MessagingException {
        StripAttachment mailet = new StripAttachment();
        FakeMailetConfig mci = FakeMailetConfig.builder().mailetName("Test").setProperty("directory", temporaryFolder.getFolderPath()).setProperty("remove", "all").setProperty("notpattern", "^(winmail\\.dat$)").build();
        mailet.init((MailetConfig)mci);
        String expectedAttachmentContent = EXPECTED_ATTACHMENT_CONTENT;
        MimeMessageBuilder message = MimeMessageBuilder.mimeMessageBuilder().setMultipartWithBodyParts(new MimeMessageBuilder.BodyPartBuilder[]{MimeMessageBuilder.bodyPartBuilder().data("simple text"), this.createAttachmentBodyPart(expectedAttachmentContent, "temp_filname.tmp", TEXT_HEADERS), this.createAttachmentBodyPart("\u0014\u00a3\u00e1\u00e2\u00e4", "winmail.dat", TEXT_HEADERS)});
        FakeMail mail = FakeMail.fromMessage((MimeMessageBuilder)message);
        mailet.service((Mail)mail);
        Optional savedAttachments = AttributeUtils.getValueAndCastFromMail((Mail)mail, (AttributeName)StripAttachment.SAVED_ATTACHMENTS, COLLECTION_STRING_CLASS);
        ((OptionalAssert)Assertions.assertThat((Optional)savedAttachments).isPresent()).hasValueSatisfying(attachments -> {
            Assertions.assertThat((Collection)attachments).hasSize(2);
            String attachmentFilename = this.retrieveFilenameStartingWith((Collection<AttributeValue<String>>)attachments, "temp_filname");
            Assertions.assertThat((String)attachmentFilename).isNotNull();
            Assertions.assertThat((File)new File(temporaryFolder.getFolderPath() + attachmentFilename)).hasContent(expectedAttachmentContent);
        });
    }

    private String retrieveFilenameStartingWith(Collection<AttributeValue<String>> savedAttachments, String filename) {
        return savedAttachments.stream().map(AttributeValue::value).filter(attachmentFilename -> attachmentFilename.startsWith(filename)).findFirst().get();
    }

    @Test
    void serviceShouldDecodeFilenameAndSaveAttachmentInAFolderWhenPatternMatchAndDecodeFilenameTrue(TemporaryFolderExtension.TemporaryFolder temporaryFolder) throws MessagingException {
        Mailet mailet = this.initMailet(temporaryFolder);
        String expectedAttachmentContent = EXPECTED_ATTACHMENT_CONTENT;
        MimeMessageBuilder message = MimeMessageBuilder.mimeMessageBuilder().setMultipartWithBodyParts(new MimeMessageBuilder.BodyPartBuilder[]{MimeMessageBuilder.bodyPartBuilder().data("simple text"), this.createAttachmentBodyPart(expectedAttachmentContent, "=?iso-8859-15?Q?=E9_++++Pubblicit=E0_=E9_vietata____Milano9052.tmp?=", TEXT_HEADERS), this.createAttachmentBodyPart("\u0014\u00a3\u00e1\u00e2\u00e4", "temp.zip", TEXT_HEADERS)});
        FakeMail mail = FakeMail.fromMessage((MimeMessageBuilder)message);
        mailet.service((Mail)mail);
        Optional savedAttachments = AttributeUtils.getValueAndCastFromMail((Mail)mail, (AttributeName)StripAttachment.SAVED_ATTACHMENTS, COLLECTION_STRING_CLASS);
        ((OptionalAssert)Assertions.assertThat((Optional)savedAttachments).isPresent()).hasValueSatisfying(attachments -> {
            Assertions.assertThat((Collection)attachments).hasSize(1);
            String name = (String)((AttributeValue)attachments.iterator().next()).value();
            Assertions.assertThat((boolean)name.startsWith("e_Pubblicita_e_vietata_Milano9052")).isTrue();
            Assertions.assertThat((File)new File(temporaryFolder.getFolderPath() + name)).hasContent(expectedAttachmentContent);
        });
    }

    @Test
    void serviceShouldSaveFilenameAttachmentAndFileContentInCustomAttribute(TemporaryFolderExtension.TemporaryFolder temporaryFolder) throws MessagingException, IOException {
        StripAttachment mailet = new StripAttachment();
        String customAttribute = "my.custom.attribute";
        FakeMailetConfig mci = FakeMailetConfig.builder().mailetName("Test").setProperty("remove", "matched").setProperty("directory", temporaryFolder.getFolderPath()).setProperty("pattern", ".*\\.tmp").setProperty("attribute", customAttribute).build();
        mailet.init((MailetConfig)mci);
        String expectedKey = "10.tmp";
        MimeMessageBuilder message = MimeMessageBuilder.mimeMessageBuilder().setMultipartWithBodyParts(new MimeMessageBuilder.BodyPartBuilder[]{MimeMessageBuilder.bodyPartBuilder().data("simple text"), this.createAttachmentBodyPart(EXPECTED_ATTACHMENT_CONTENT, expectedKey, TEXT_HEADERS), this.createAttachmentBodyPart("\u0014\u00a3\u00e1\u00e2\u00e4", "temp.zip", TEXT_HEADERS)});
        FakeMail mail = FakeMail.fromMessage((MimeMessageBuilder)message);
        mailet.service((Mail)mail);
        Optional savedValue = AttributeUtils.getValueAndCastFromMail((Mail)mail, (AttributeName)AttributeName.of((String)customAttribute), MAP_STRING_BYTES_CLASS);
        ConsumerChainer assertValue = Throwing.consumer(saved -> {
            ((MapAssert)Assertions.assertThat((Map)saved).hasSize(1)).containsKeys((Object[])new String[]{expectedKey});
            MimeBodyPart savedBodyPart = new MimeBodyPart((InputStream)new ByteArrayInputStream((byte[])((AttributeValue)saved.get(expectedKey)).getValue()));
            String content = IOUtils.toString((InputStream)savedBodyPart.getInputStream(), (Charset)StandardCharsets.UTF_8);
            Assertions.assertThat((String)content).isEqualTo(EXPECTED_ATTACHMENT_CONTENT);
        });
        ((OptionalAssert)Assertions.assertThat((Optional)savedValue).isPresent()).hasValueSatisfying(assertValue.sneakyThrow());
    }

    @Test
    void serviceShouldDecodeHeaderFilenames() throws MessagingException, IOException {
        StripAttachment mailet = new StripAttachment();
        String customAttribute = "my.custom.attribute";
        FakeMailetConfig mci = FakeMailetConfig.builder().mailetName("Test").setProperty("pattern", ".*\\.tmp").setProperty("attribute", customAttribute).build();
        mailet.init((MailetConfig)mci);
        String expectedKey = "invite.tmp";
        MimeMessageBuilder message = MimeMessageBuilder.mimeMessageBuilder().setMultipartWithBodyParts(new MimeMessageBuilder.BodyPartBuilder[]{MimeMessageBuilder.bodyPartBuilder().data("simple text"), this.createAttachmentBodyPart(EXPECTED_ATTACHMENT_CONTENT, "=?US-ASCII?Q?" + expectedKey + "?=", TEXT_HEADERS)});
        FakeMail mail = FakeMail.fromMessage((MimeMessageBuilder)message);
        mailet.service((Mail)mail);
        Optional savedValue = AttributeUtils.getValueAndCastFromMail((Mail)mail, (AttributeName)AttributeName.of((String)customAttribute), MAP_STRING_BYTES_CLASS);
        ConsumerChainer assertValue = Throwing.consumer(saved -> {
            ((MapAssert)Assertions.assertThat((Map)saved).hasSize(1)).containsKeys((Object[])new String[]{expectedKey});
            MimeBodyPart savedBodyPart = new MimeBodyPart((InputStream)new ByteArrayInputStream((byte[])((AttributeValue)saved.get(expectedKey)).getValue()));
            String content = IOUtils.toString((InputStream)savedBodyPart.getInputStream(), (Charset)StandardCharsets.UTF_8);
            Assertions.assertThat((String)content).isEqualTo(EXPECTED_ATTACHMENT_CONTENT);
        });
        ((OptionalAssert)Assertions.assertThat((Optional)savedValue).isPresent()).hasValueSatisfying(assertValue.sneakyThrow());
    }

    @Test
    void initShouldThrowWhenPatternAndNotPatternAndMimeTypeAreNull() {
        StripAttachment mailet = new StripAttachment();
        FakeMailetConfig mci = FakeMailetConfig.builder().mailetName("Test").build();
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> StripAttachmentTest.lambda$initShouldThrowWhenPatternAndNotPatternAndMimeTypeAreNull$7((Mailet)mailet, mci)).isInstanceOf(MailetException.class)).hasMessage("At least one of 'pattern', 'notpattern' or 'mimeType' parameter should be provided.");
    }

    @Test
    void initShouldThrowWhenMimeTypeIsEmpty() {
        StripAttachment mailet = new StripAttachment();
        FakeMailetConfig mci = FakeMailetConfig.builder().mailetName("Test").setProperty("mimeType", "").build();
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> StripAttachmentTest.lambda$initShouldThrowWhenMimeTypeIsEmpty$8((Mailet)mailet, mci)).isInstanceOf(MailetException.class)).hasMessage("At least one of 'pattern', 'notpattern' or 'mimeType' parameter should be provided.");
    }

    @Test
    void initShouldWorkWhenPatternIsDefinedAndValid() throws MessagingException {
        StripAttachment mailet = new StripAttachment();
        FakeMailetConfig mci = FakeMailetConfig.builder().mailetName("Test").setProperty("pattern", ".*\\.tmp").build();
        mailet.init((MailetConfig)mci);
    }

    @Test
    void initShouldWorkWhenNotPatternIsDefinedAndValid() throws MessagingException {
        StripAttachment mailet = new StripAttachment();
        FakeMailetConfig mci = FakeMailetConfig.builder().mailetName("Test").setProperty("notpattern", ".*\\.tmp").build();
        mailet.init((MailetConfig)mci);
    }

    @Test
    void initShouldWorkWhenMimeTypeIsDefined() throws MessagingException {
        StripAttachment mailet = new StripAttachment();
        FakeMailetConfig mci = FakeMailetConfig.builder().mailetName("Test").setProperty("mimeType", "text/calendar").build();
        mailet.init((MailetConfig)mci);
    }

    @Test
    void initShouldThrowWhenWrongPattern() {
        StripAttachment mailet = new StripAttachment();
        FakeMailetConfig mci = FakeMailetConfig.builder().mailetName("Test").setProperty("pattern", ".****\\.tmp").build();
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> StripAttachmentTest.lambda$initShouldThrowWhenWrongPattern$9((Mailet)mailet, mci)).isInstanceOf(MailetException.class)).hasMessage("Could not compile regex [.****\\.tmp].");
    }

    @Test
    void initShouldThrowWhenWrongNotPattern() {
        StripAttachment mailet = new StripAttachment();
        FakeMailetConfig mci = FakeMailetConfig.builder().mailetName("Test").setProperty("notpattern", ".****\\.tmp").build();
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> StripAttachmentTest.lambda$initShouldThrowWhenWrongNotPattern$10((Mailet)mailet, mci)).isInstanceOf(MailetException.class)).hasMessage("Could not compile regex [.****\\.tmp].");
    }

    @Test
    void initShouldThrowWhenRemoveParameterIsUnknown() {
        StripAttachment mailet = new StripAttachment();
        FakeMailetConfig mci = FakeMailetConfig.builder().mailetName("Test").setProperty("remove", "unknown").setProperty("pattern", ".*\\.tmp").build();
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> mailet.init((MailetConfig)mci)).isInstanceOf(MailetException.class)).hasMessage("Unknown remove parameter value 'unknown' waiting for 'matched', 'all' or 'no'.");
    }

    @Test
    void initShouldSetRemoveParameterWhenEqualsMatched() throws MessagingException {
        StripAttachment mailet = new StripAttachment();
        FakeMailetConfig mci = FakeMailetConfig.builder().mailetName("Test").setProperty("remove", "matched").setProperty("pattern", ".*\\.tmp").build();
        mailet.init((MailetConfig)mci);
        Assertions.assertThat((String)mailet.removeAttachments).isEqualTo("matched");
    }

    @Test
    void initShouldSetRemoveParameterWhenEqualsAll() throws MessagingException {
        StripAttachment mailet = new StripAttachment();
        FakeMailetConfig mci = FakeMailetConfig.builder().mailetName("Test").setProperty("remove", "all").setProperty("pattern", ".*\\.tmp").build();
        mailet.init((MailetConfig)mci);
        Assertions.assertThat((String)mailet.removeAttachments).isEqualTo("all");
    }

    @Test
    void initShouldSetRemoveParameterWhenEqualsNo() throws MessagingException {
        StripAttachment mailet = new StripAttachment();
        FakeMailetConfig mci = FakeMailetConfig.builder().mailetName("Test").setProperty("remove", "no").setProperty("pattern", ".*\\.tmp").build();
        mailet.init((MailetConfig)mci);
        Assertions.assertThat((String)mailet.removeAttachments).isEqualTo("no");
    }

    @Test
    void initShouldSetRemoveParameterDefaultValueWhenNotGiven() throws MessagingException {
        StripAttachment mailet = new StripAttachment();
        FakeMailetConfig mci = FakeMailetConfig.builder().mailetName("Test").setProperty("pattern", ".*\\.tmp").build();
        mailet.init((MailetConfig)mci);
        Assertions.assertThat((String)mailet.removeAttachments).isEqualTo("no");
    }

    @Test
    void serviceShouldThrowWhenUnretrievableMessage(TemporaryFolderExtension.TemporaryFolder temporaryFolder) throws MessagingException {
        Mailet mailet = this.initMailet(temporaryFolder);
        Mail mail = (Mail)Mockito.mock(Mail.class);
        Mockito.when((Object)mail.getMessage()).thenThrow(new Throwable[]{new MessagingException("Test exception")});
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> mailet.service(mail)).isInstanceOf(MailetException.class)).hasMessage("Could not retrieve message from Mail object");
    }

    @Test
    void serviceShouldThrowWhenUnretrievableContentTypeMessage(TemporaryFolderExtension.TemporaryFolder temporaryFolder) throws MessagingException {
        Mailet mailet = this.initMailet(temporaryFolder);
        MimeMessage message = (MimeMessage)Mockito.mock(MimeMessage.class);
        Mail mail = (Mail)Mockito.mock(Mail.class);
        Mockito.when((Object)mail.getMessage()).thenReturn((Object)message);
        Mockito.when((Object)message.isMimeType("multipart/*")).thenThrow(new Throwable[]{new MessagingException("Test exception")});
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> mailet.service(mail)).isInstanceOf(MailetException.class)).hasMessage("Could not retrieve contenttype of MimePart.");
    }

    @Test
    void getMailetInfoShouldReturn() {
        StripAttachment mailet = new StripAttachment();
        Assertions.assertThat((String)mailet.getMailetInfo()).isEqualTo("StripAttachment");
    }

    @Test
    void processMultipartPartMessageShouldReturnFalseWhenPartIsNotMultipart() throws Exception {
        StripAttachment mailet = new StripAttachment();
        MimeBodyPart part = new MimeBodyPart((InputStream)new ByteArrayInputStream(new byte[0]));
        Mail mail = (Mail)Mockito.mock(Mail.class);
        boolean actual = mailet.processMultipartPartMessage((Part)part, mail);
        Assertions.assertThat((boolean)actual).isFalse();
    }

    @Test
    void processMultipartPartMessageShouldReturnTrueWhenAtLeastOneMultipartShouldHaveBeenRemoved() throws Exception {
        StripAttachment mailet = new StripAttachment();
        FakeMailetConfig mci = FakeMailetConfig.builder().mailetName("Test").setProperty("remove", "all").setProperty("pattern", ".*").build();
        mailet.init((MailetConfig)mci);
        MimeMessage mimeMessage = MimeMessageBuilder.mimeMessageBuilder().setMultipartWithBodyParts(new MimeMessageBuilder.BodyPartBuilder[]{MimeMessageBuilder.bodyPartBuilder().filename("removeMe.tmp")}).build();
        Mail mail = (Mail)Mockito.mock(Mail.class);
        boolean actual = mailet.processMultipartPartMessage((Part)mimeMessage, mail);
        Assertions.assertThat((boolean)actual).isTrue();
    }

    @Test
    void processMultipartPartMessageShouldReturnTrueWhenAtLeastOneMultipartShouldHaveBeenRemovedAndPartialRemove() throws Exception {
        StripAttachment mailet = new StripAttachment();
        FakeMailetConfig mci = FakeMailetConfig.builder().mailetName("Test").setProperty("remove", "matched").setProperty("pattern", ".*").build();
        mailet.init((MailetConfig)mci);
        MimeMessage mimeMessage = MimeMessageBuilder.mimeMessageBuilder().setMultipartWithBodyParts(new MimeMessageBuilder.BodyPartBuilder[]{MimeMessageBuilder.bodyPartBuilder().filename("removeMe.tmp")}).build();
        Mail mail = (Mail)Mockito.mock(Mail.class);
        boolean actual = mailet.processMultipartPartMessage((Part)mimeMessage, mail);
        Assertions.assertThat((boolean)actual).isTrue();
    }

    @Test
    void processMultipartPartMessageShouldPutTwoPartsInDefaultAttributeWhenTwoPartsMatch(TemporaryFolderExtension.TemporaryFolder temporaryFolder) throws Exception {
        StripAttachment mailet = new StripAttachment();
        FakeMailetConfig mci = FakeMailetConfig.builder().mailetName("Test").setProperty("remove", "matched").setProperty("directory", temporaryFolder.getFolderPath()).setProperty("pattern", ".*").build();
        mailet.init((MailetConfig)mci);
        MimeMessage mimeMessage = MimeMessageBuilder.mimeMessageBuilder().setMultipartWithBodyParts(new MimeMessageBuilder.BodyPartBuilder[]{MimeMessageBuilder.bodyPartBuilder().filename("removeMe.tmp"), MimeMessageBuilder.bodyPartBuilder().filename("removeMe.tmp")}).build();
        FakeMail mail = FakeMail.builder().name("mail").build();
        boolean actual = mailet.processMultipartPartMessage((Part)mimeMessage, (Mail)mail);
        Assertions.assertThat((boolean)actual).isTrue();
        Optional removedAttachments = AttributeUtils.getValueAndCastFromMail((Mail)mail, (AttributeName)StripAttachment.SAVED_ATTACHMENTS, COLLECTION_STRING_CLASS);
        ((OptionalAssert)Assertions.assertThat((Optional)removedAttachments).isPresent()).hasValueSatisfying(attachments -> Assertions.assertThat((Collection)attachments).hasSize(2));
    }

    @Test
    void processMultipartPartMessageShouldPutTwoPartsInCustomAttributeWhenTwoPartsMatch(TemporaryFolderExtension.TemporaryFolder temporaryFolder) throws Exception {
        StripAttachment mailet = new StripAttachment();
        String customAttribute = "my.custom.attribute";
        FakeMailetConfig mci = FakeMailetConfig.builder().mailetName("Test").setProperty("remove", "matched").setProperty("directory", temporaryFolder.getFolderPath()).setProperty("pattern", ".*").setProperty("attribute", customAttribute).build();
        mailet.init((MailetConfig)mci);
        MimeMessage mimeMessage = MimeMessageBuilder.mimeMessageBuilder().setMultipartWithBodyParts(new MimeMessageBuilder.BodyPartBuilder[]{MimeMessageBuilder.bodyPartBuilder().filename("removeMe1.tmp"), MimeMessageBuilder.bodyPartBuilder().filename("removeMe2.tmp")}).build();
        FakeMail mail = FakeMail.builder().name("mail").build();
        boolean actual = mailet.processMultipartPartMessage((Part)mimeMessage, (Mail)mail);
        Assertions.assertThat((boolean)actual).isTrue();
        Optional savedValue = AttributeUtils.getValueAndCastFromMail((Mail)mail, (AttributeName)AttributeName.of((String)customAttribute), MAP_STRING_BYTES_CLASS);
        ((OptionalAssert)Assertions.assertThat((Optional)savedValue).isPresent()).hasValueSatisfying(saved -> Assertions.assertThat((Map)saved).hasSize(2));
    }

    @Test
    void processMultipartPartMessageShouldReturnTrueWhenAtLeastOneSubMultipartShouldHaveBeenRemoved() throws Exception {
        StripAttachment mailet = new StripAttachment();
        FakeMailetConfig mci = FakeMailetConfig.builder().mailetName("Test").setProperty("remove", "all").setProperty("pattern", ".*\\.tmp").build();
        mailet.init((MailetConfig)mci);
        MimeMessage message = MimeMessageBuilder.mimeMessageBuilder().setMultipartWithSubMessage(MimeMessageBuilder.mimeMessageBuilder().setMultipartWithBodyParts(new MimeMessageBuilder.BodyPartBuilder[]{MimeMessageBuilder.bodyPartBuilder().filename("removeMe.tmp")})).build();
        Mail mail = (Mail)Mockito.mock(Mail.class);
        boolean actual = mailet.processMultipartPartMessage((Part)message, mail);
        Assertions.assertThat((boolean)actual).isTrue();
    }

    @Test
    void processMultipartPartMessageShouldReturnFalseWhenNoPartHasBeenRemovedInSubMultipart() throws Exception {
        StripAttachment mailet = new StripAttachment();
        FakeMailetConfig mci = FakeMailetConfig.builder().mailetName("Test").setProperty("remove", "matched").setProperty("pattern", ".*\\.tmp").build();
        mailet.init((MailetConfig)mci);
        MimeMessage message = MimeMessageBuilder.mimeMessageBuilder().setMultipartWithSubMessage(MimeMessageBuilder.mimeMessageBuilder().setMultipartWithBodyParts(new MimeMessageBuilder.BodyPartBuilder[]{MimeMessageBuilder.bodyPartBuilder().filename("dontRemoveMe.other")})).build();
        Mail mail = (Mail)Mockito.mock(Mail.class);
        boolean actual = mailet.processMultipartPartMessage((Part)message, mail);
        Assertions.assertThat((boolean)actual).isFalse();
    }

    @Test
    void processMultipartPartMessageShouldRemovePartWhenOnePartShouldHaveBeenRemoved() throws Exception {
        StripAttachment mailet = new StripAttachment();
        FakeMailetConfig mci = FakeMailetConfig.builder().mailetName("Test").setProperty("remove", "all").setProperty("pattern", ".*").build();
        mailet.init((MailetConfig)mci);
        MimeMessage mimeMessage = MimeMessageBuilder.mimeMessageBuilder().setContent(MimeMessageBuilder.multipartBuilder().addBody(MimeMessageBuilder.bodyPartBuilder().filename("removeMe.tmp"))).build();
        Mail mail = (Mail)Mockito.mock(Mail.class);
        mailet.processMultipartPartMessage((Part)mimeMessage, mail);
        Assertions.assertThat((Object)mimeMessage.getContent()).isInstanceOf(MimeMultipart.class);
        MimeMultipart multipart = (MimeMultipart)mimeMessage.getContent();
        Assertions.assertThat((int)multipart.getCount()).isZero();
    }

    @Test
    void processMultipartPartMessageShouldSetFilenameToMatchingAttachmentsWhenAttachmentWithoutFilename(TemporaryFolderExtension.TemporaryFolder temporaryFolder) throws Exception {
        StripAttachment mailet = new StripAttachment();
        FakeMailetConfig mci = FakeMailetConfig.builder().mailetName("Test").setProperty("remove", "matched").setProperty("directory", temporaryFolder.getFolderPath()).setProperty("pattern", ".*").build();
        mailet.init((MailetConfig)mci);
        MimeMessage mimeMessage = MimeMessageBuilder.mimeMessageBuilder().setMultipartWithBodyParts(new BodyPart[]{MimeMessageBuilder.bodyPartBuilder().build()}).build();
        FakeMail mail = FakeMail.builder().name("mail").build();
        boolean actual = mailet.processMultipartPartMessage((Part)mimeMessage, (Mail)mail);
        Assertions.assertThat((boolean)actual).isTrue();
        Optional removedAttachments = AttributeUtils.getValueAndCastFromMail((Mail)mail, (AttributeName)StripAttachment.SAVED_ATTACHMENTS, COLLECTION_STRING_CLASS);
        ((OptionalAssert)Assertions.assertThat((Optional)removedAttachments).isPresent()).hasValueSatisfying(attachments -> Assertions.assertThat((Collection)attachments).hasSize(1));
    }

    @Test
    void saveAttachmentShouldUsePartNameIfNoFilename(TemporaryFolderExtension.TemporaryFolder temporaryFolder) throws Exception {
        StripAttachment mailet = new StripAttachment();
        FakeMailetConfig mci = FakeMailetConfig.builder().setProperty("directory", temporaryFolder.getFolderPath()).setProperty("pattern", ".*\\.tmp").build();
        mailet.init((MailetConfig)mci);
        BodyPart part = MimeMessageBuilder.bodyPartBuilder().filename("example.tmp").build();
        Optional maybeFilename = mailet.saveAttachmentToFile((Part)part, ABSENT_MIME_TYPE);
        Assertions.assertThat((Optional)maybeFilename).isPresent();
        String filename = (String)maybeFilename.get();
        Assertions.assertThat((String)filename).startsWith((CharSequence)"example");
        Assertions.assertThat((String)filename).endsWith((CharSequence)".tmp");
    }

    @Test
    void saveAttachmentShouldReturnAbsentWhenNoFilenameAtAll(TemporaryFolderExtension.TemporaryFolder temporaryFolder) throws Exception {
        StripAttachment mailet = new StripAttachment();
        FakeMailetConfig mci = FakeMailetConfig.builder().setProperty("directory", temporaryFolder.getFolderPath()).setProperty("pattern", ".*\\.tmp").build();
        mailet.init((MailetConfig)mci);
        BodyPart part = MimeMessageBuilder.bodyPartBuilder().build();
        Optional maybeFilename = mailet.saveAttachmentToFile((Part)part, ABSENT_MIME_TYPE);
        Assertions.assertThat((Optional)maybeFilename).isEmpty();
    }

    @Test
    void saveAttachmentShouldAddBinExtensionWhenNoFileNameExtension(TemporaryFolderExtension.TemporaryFolder temporaryFolder) throws Exception {
        StripAttachment mailet = new StripAttachment();
        FakeMailetConfig mci = FakeMailetConfig.builder().setProperty("directory", temporaryFolder.getFolderPath()).setProperty("pattern", ".*").build();
        mailet.init((MailetConfig)mci);
        BodyPart part = MimeMessageBuilder.bodyPartBuilder().build();
        String fileName = "exampleWithoutSuffix";
        Optional maybeFilename = mailet.saveAttachmentToFile((Part)part, Optional.of(fileName));
        Assertions.assertThat((Optional)maybeFilename).isPresent();
        String filename = (String)maybeFilename.get();
        Assertions.assertThat((String)filename).startsWith((CharSequence)"exampleWithoutSuffix");
        Assertions.assertThat((String)filename).endsWith((CharSequence)".bin");
    }

    private Mailet initMailet(TemporaryFolderExtension.TemporaryFolder temporaryFolder) throws MessagingException {
        StripAttachment mailet = new StripAttachment();
        FakeMailetConfig mci = FakeMailetConfig.builder().mailetName("Test").setProperty("directory", temporaryFolder.getFolderPath()).setProperty("remove", "all").setProperty("pattern", ".*\\.tmp").setProperty("decodeFilename", "true").setProperty("replaceFilenamePattern", "/[\u00c0\u00c1\u00c2\u00c3\u00c4\u00c5]/A//,/[\u00c6]/AE//,/[\u00c8\u00c9\u00ca\u00cb]/E//,/[\u00cc\u00cd\u00ce\u00cf]/I//,/[\u00d2\u00d3\u00d4\u00d5\u00d6]/O//,/[\u00d7]/x//,/[\u00d9\u00da\u00db\u00dc]/U//,/[\u00e0\u00e1\u00e2\u00e3\u00e4\u00e5]/a//,/[\u00e6]/ae//,/[\u00e8\u00e9\u00ea\u00eb]/e/r/,/[\u00ec\u00ed\u00ee\u00ef]/i//,/[\u00f2\u00f3\u00f4\u00f5\u00f6]/o//,/[\u00f9\u00fa\u00fb\u00fc]/u//,/[^A-Za-z0-9._-]+/_/r/").build();
        mailet.init((MailetConfig)mci);
        return mailet;
    }

    @Test
    void fileNameMatchesShouldThrowWhenPatternIsNull() throws Exception {
        StripAttachment mailet = new StripAttachment();
        FakeMailetConfig mci = FakeMailetConfig.builder().setProperty("pattern", ".*pattern.*").build();
        mailet.init((MailetConfig)mci);
        Assertions.assertThatThrownBy(() -> mailet.fileNameMatches(null)).isInstanceOf(NullPointerException.class);
    }

    @Test
    void fileNameMatchesShouldReturnFalseWhenPatternDoesntMatch() throws Exception {
        StripAttachment mailet = new StripAttachment();
        FakeMailetConfig mci = FakeMailetConfig.builder().setProperty("pattern", ".*pattern.*").build();
        mailet.init((MailetConfig)mci);
        Assertions.assertThat((boolean)mailet.fileNameMatches("not matching")).isFalse();
    }

    @Test
    void fileNameMatchesShouldReturnTrueWhenPatternMatches() throws Exception {
        StripAttachment mailet = new StripAttachment();
        FakeMailetConfig mci = FakeMailetConfig.builder().setProperty("pattern", ".*pattern.*").build();
        mailet.init((MailetConfig)mci);
        Assertions.assertThat((boolean)mailet.fileNameMatches("I've got a pattern.")).isTrue();
    }

    @Test
    void fileNameMatchesShouldReturnFalseWhenNotPatternMatches() throws Exception {
        StripAttachment mailet = new StripAttachment();
        FakeMailetConfig mci = FakeMailetConfig.builder().setProperty("notpattern", ".*pattern.*").build();
        mailet.init((MailetConfig)mci);
        Assertions.assertThat((boolean)mailet.fileNameMatches("I've got a pattern.")).isFalse();
    }

    @Test
    void fileNameMatchesShouldReturnTrueWhenNotPatternDoesntMatch() throws Exception {
        StripAttachment mailet = new StripAttachment();
        FakeMailetConfig mci = FakeMailetConfig.builder().setProperty("notpattern", ".*pattern.*").build();
        mailet.init((MailetConfig)mci);
        Assertions.assertThat((boolean)mailet.fileNameMatches("not matching")).isTrue();
    }

    @Test
    void fileNameMatchesShouldReturnFalseWhenPatternAndNotPatternAreTheSame() throws Exception {
        StripAttachment mailet = new StripAttachment();
        FakeMailetConfig mci = FakeMailetConfig.builder().setProperty("pattern", ".*pattern.*").setProperty("notpattern", ".*pattern.*").build();
        mailet.init((MailetConfig)mci);
        Assertions.assertThat((boolean)mailet.fileNameMatches("not matching")).isFalse();
        Assertions.assertThat((boolean)mailet.fileNameMatches("I've got a pattern.")).isFalse();
    }

    @Test
    void fileNameMatchesShouldReturnTrueWhenPatternMatchesAndNotPatternDoesntMatch() throws Exception {
        StripAttachment mailet = new StripAttachment();
        FakeMailetConfig mci = FakeMailetConfig.builder().setProperty("pattern", ".*pattern.*").setProperty("notpattern", ".*notpattern.*").build();
        mailet.init((MailetConfig)mci);
        Assertions.assertThat((boolean)mailet.fileNameMatches("I've got a pattern.")).isTrue();
    }

    @Test
    void fileNameMatchesShouldReturnTrueWhenPatternDoesntMatchesAndNotPatternDoesntMatch() throws Exception {
        StripAttachment mailet = new StripAttachment();
        FakeMailetConfig mci = FakeMailetConfig.builder().setProperty("pattern", ".*pattern.*").setProperty("notpattern", ".*notpattern.*").build();
        mailet.init((MailetConfig)mci);
        Assertions.assertThat((boolean)mailet.fileNameMatches("o.")).isTrue();
    }

    @Test
    void prependedPrefixShouldAddUnderscoreWhenPrefixIsLessThanThreeCharacters() {
        String prefix = StripAttachment.OutputFileName.prependedPrefix((String)"a");
        Assertions.assertThat((String)prefix).isEqualTo("__a");
    }

    @Test
    void prependedPrefixShouldReturnPrefixWhenPrefixIsGreaterThanThreeCharacters() {
        String expectedPrefix = "abcd";
        String prefix = StripAttachment.OutputFileName.prependedPrefix((String)expectedPrefix);
        Assertions.assertThat((String)prefix).isEqualTo(expectedPrefix);
    }

    @Test
    void getFilenameShouldReturnRandomFilenameWhenExceptionOccured() throws Exception {
        BodyPart bodyPart = (BodyPart)Mockito.mock(BodyPart.class);
        Mockito.when((Object)bodyPart.getFileName()).thenThrow(new Throwable[]{new MessagingException()});
        StripAttachment mailet = new StripAttachment();
        String filename = mailet.getFilename(bodyPart);
        Assertions.assertThat((String)filename).isNotNull();
    }

    private static /* synthetic */ void lambda$initShouldThrowWhenWrongNotPattern$10(Mailet mailet, FakeMailetConfig mci) throws Throwable {
        mailet.init((MailetConfig)mci);
    }

    private static /* synthetic */ void lambda$initShouldThrowWhenWrongPattern$9(Mailet mailet, FakeMailetConfig mci) throws Throwable {
        mailet.init((MailetConfig)mci);
    }

    private static /* synthetic */ void lambda$initShouldThrowWhenMimeTypeIsEmpty$8(Mailet mailet, FakeMailetConfig mci) throws Throwable {
        mailet.init((MailetConfig)mci);
    }

    private static /* synthetic */ void lambda$initShouldThrowWhenPatternAndNotPatternAndMimeTypeAreNull$7(Mailet mailet, FakeMailetConfig mci) throws Throwable {
        mailet.init((MailetConfig)mci);
    }
}

