/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.transport.mailets;

import javax.mail.MessagingException;
import javax.mail.internet.MimeMessage;
import org.apache.james.transport.mailets.SetMimeHeader;
import org.apache.mailet.Mail;
import org.apache.mailet.Mailet;
import org.apache.mailet.MailetConfig;
import org.apache.mailet.base.test.FakeMail;
import org.apache.mailet.base.test.FakeMailetConfig;
import org.apache.mailet.base.test.MailUtil;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;

class SetMimeHeaderTest {
    private Mailet mailet;

    SetMimeHeaderTest() {
    }

    @BeforeEach
    void setUp() {
        this.mailet = new SetMimeHeader();
    }

    @Test
    void shouldAddHeaderToMime() throws MessagingException {
        FakeMailetConfig mailetConfig = FakeMailetConfig.builder().mailetName("Test").setProperty("name", "header-name").setProperty("value", "test-value").build();
        this.mailet.init((MailetConfig)mailetConfig);
        MimeMessage mimeMessage = MailUtil.createMimeMessage();
        FakeMail mail = MailUtil.createMockMail2Recipients((MimeMessage)mimeMessage);
        this.mailet.service((Mail)mail);
        Assertions.assertThat((Object[])mail.getMessage().getHeader("header-name")).containsExactly((Object[])new String[]{"test-value"});
    }

    @Test
    void shouldAddHeaderWhenAlreadyPresent() throws MessagingException {
        FakeMailetConfig mailetConfig = FakeMailetConfig.builder().mailetName("Test").setProperty("name", "header-name").setProperty("value", "test-value").build();
        this.mailet.init((MailetConfig)mailetConfig);
        MimeMessage mimeMessage = MailUtil.createMimeMessage();
        mimeMessage.addHeader("header-name", "first-value");
        FakeMail mail = MailUtil.createMockMail2Recipients((MimeMessage)mimeMessage);
        this.mailet.service((Mail)mail);
        Assertions.assertThat((Object[])mail.getMessage().getHeader("header-name")).containsOnly((Object[])new String[]{"test-value", "first-value"});
    }

    @Test
    void shouldThrowOnMessagingException() throws MessagingException {
        FakeMailetConfig mailetConfig = FakeMailetConfig.builder().mailetName("Test").setProperty("name", "header-name").setProperty("value", "test-value").build();
        this.mailet.init((MailetConfig)mailetConfig);
        Mail mail = (Mail)Mockito.mock(Mail.class);
        Mockito.when((Object)mail.getMessage()).thenThrow(new Throwable[]{new MessagingException()});
        Assertions.assertThatThrownBy(() -> this.mailet.service(mail)).isInstanceOf(MessagingException.class);
    }

    @Test
    void shouldThrowWhenNoConfiguration() {
        FakeMailetConfig mailetConfig = FakeMailetConfig.builder().mailetName("Test").build();
        Assertions.assertThatThrownBy(() -> this.mailet.init((MailetConfig)mailetConfig)).isInstanceOf(MessagingException.class);
    }

    @Test
    void shouldThrowWhenNoValue() {
        FakeMailetConfig mailetConfig = FakeMailetConfig.builder().mailetName("Test").setProperty("name", "correct").build();
        Assertions.assertThatThrownBy(() -> this.mailet.init((MailetConfig)mailetConfig)).isInstanceOf(MessagingException.class);
    }

    @Test
    void shouldThrowWhenNoHeader() {
        FakeMailetConfig mailetConfig = FakeMailetConfig.builder().mailetName("Test").setProperty("value", "correct").build();
        Assertions.assertThatThrownBy(() -> this.mailet.init((MailetConfig)mailetConfig)).isInstanceOf(MessagingException.class);
    }

    @Test
    void shouldThrowWhenEmptyValue() {
        FakeMailetConfig mailetConfig = FakeMailetConfig.builder().mailetName("Test").setProperty("value", "").setProperty("name", "correct").build();
        Assertions.assertThatThrownBy(() -> this.mailet.init((MailetConfig)mailetConfig)).isInstanceOf(MessagingException.class);
    }

    @Test
    void shouldThrowWhenEmptyHeader() {
        FakeMailetConfig mailetConfig = FakeMailetConfig.builder().mailetName("Test").setProperty("name", "").setProperty("value", "correct").build();
        Assertions.assertThatThrownBy(() -> this.mailet.init((MailetConfig)mailetConfig)).isInstanceOf(MessagingException.class);
    }
}

