/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.transport.mailets;

import java.util.Optional;
import java.util.stream.Stream;
import javax.mail.MessagingException;
import javax.mail.internet.MimeMessage;
import org.apache.james.transport.mailets.SetMailAttribute;
import org.apache.james.util.MimeMessageUtil;
import org.apache.mailet.Attribute;
import org.apache.mailet.AttributeName;
import org.apache.mailet.AttributeValue;
import org.apache.mailet.Mail;
import org.apache.mailet.Mailet;
import org.apache.mailet.MailetConfig;
import org.apache.mailet.base.test.FakeMail;
import org.apache.mailet.base.test.FakeMailetConfig;
import org.apache.mailet.base.test.MailUtil;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

class SetMailAttributeTest {
    private Mailet mailet;

    SetMailAttributeTest() {
    }

    @BeforeEach
    void setupMailet() {
        this.mailet = new SetMailAttribute();
    }

    @Test
    void shouldAddConfiguredAttributes() throws MessagingException {
        AttributeName name1 = AttributeName.of((String)"org.apache.james.junit1");
        AttributeName name2 = AttributeName.of((String)"org.apache.james.junit2");
        AttributeValue value1 = AttributeValue.of((String)"true");
        AttributeValue value2 = AttributeValue.of((String)"happy");
        Attribute attribute1 = new Attribute(name1, value1);
        Attribute attribute2 = new Attribute(name2, value2);
        FakeMailetConfig mailetConfig = FakeMailetConfig.builder().mailetName("Test").setProperty(name1.asString(), (String)value1.value()).setProperty(name2.asString(), (String)value2.value()).build();
        this.mailet.init((MailetConfig)mailetConfig);
        FakeMail mail = MailUtil.createMockMail2Recipients((MimeMessage)MimeMessageUtil.defaultMimeMessage());
        this.mailet.service((Mail)mail);
        Assertions.assertThat((Optional)mail.getAttribute(name1)).contains((Object)attribute1);
        Assertions.assertThat((Optional)mail.getAttribute(name2)).contains((Object)attribute2);
    }

    @Test
    void shouldAddNothingWhenNoConfiguredAttribute() throws MessagingException {
        FakeMailetConfig mailetConfig = FakeMailetConfig.builder().mailetName("Test").build();
        this.mailet.init((MailetConfig)mailetConfig);
        FakeMail mail = MailUtil.createMockMail2Recipients((MimeMessage)MimeMessageUtil.defaultMimeMessage());
        this.mailet.service((Mail)mail);
        Assertions.assertThat((Stream)mail.attributes()).isEmpty();
    }

    @Test
    void shouldOverwriteAttributeWhenAttributeAlreadyPresent() throws MessagingException {
        AttributeName name = AttributeName.of((String)"org.apache.james.junit1");
        Attribute mailAttribute = new Attribute(name, AttributeValue.of((String)"foo"));
        Attribute replacedAttribute = new Attribute(name, AttributeValue.of((String)"bar"));
        FakeMailetConfig mailetConfig = FakeMailetConfig.builder().mailetName("Test").setProperty(name.asString(), (String)replacedAttribute.getValue().value()).build();
        this.mailet.init((MailetConfig)mailetConfig);
        FakeMail mail = MailUtil.createMockMail2Recipients((MimeMessage)MimeMessageUtil.defaultMimeMessage());
        mail.setAttribute(mailAttribute);
        this.mailet.service((Mail)mail);
        Assertions.assertThat((Optional)mail.getAttribute(name)).contains((Object)replacedAttribute);
    }
}

