/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.transport.mailets;

import org.apache.james.transport.mailets.SetErrorMessage;
import org.apache.mailet.Mail;
import org.apache.mailet.Mailet;
import org.apache.mailet.MailetConfig;
import org.apache.mailet.base.test.FakeMail;
import org.apache.mailet.base.test.FakeMailetConfig;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

class SetErrorMessageTest {
    private static final String MY_MESSAGE = "my message";
    private Mailet testee;

    SetErrorMessageTest() {
    }

    @BeforeEach
    void setUp() {
        this.testee = new SetErrorMessage();
    }

    @Test
    void initShouldThrowWhenNoErrorMessage() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.testee.init((MailetConfig)FakeMailetConfig.builder().build())).isInstanceOf(IllegalStateException.class)).hasMessage("'errorMessage' needs to be specified and cannot be empty");
    }

    @Test
    void initShouldThrowOnEmptyErrorMessage() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.testee.init((MailetConfig)FakeMailetConfig.builder().setProperty("errorMessage", "").build())).isInstanceOf(IllegalStateException.class)).hasMessage("'errorMessage' needs to be specified and cannot be empty");
    }

    @Test
    void serviceShouldPositionErrorMessage() throws Exception {
        this.testee.init((MailetConfig)FakeMailetConfig.builder().setProperty("errorMessage", MY_MESSAGE).build());
        FakeMail myMail = FakeMail.builder().name("myMail").build();
        this.testee.service((Mail)myMail);
        Assertions.assertThat((String)myMail.getErrorMessage()).isEqualTo(MY_MESSAGE);
    }

    @Test
    void serviceShouldOverwriteErrorMessage() throws Exception {
        this.testee.init((MailetConfig)FakeMailetConfig.builder().setProperty("errorMessage", MY_MESSAGE).build());
        FakeMail myMail = FakeMail.builder().name("myMail").errorMessage("Old error message").build();
        this.testee.service((Mail)myMail);
        Assertions.assertThat((String)myMail.getErrorMessage()).isEqualTo(MY_MESSAGE);
    }
}

