/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.transport.mailets;

import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.mail.MessagingException;
import javax.mail.internet.MimeMessage;
import org.apache.http.ExceptionLogger;
import org.apache.http.HttpEntity;
import org.apache.http.client.utils.URLEncodedUtils;
import org.apache.http.config.SocketConfig;
import org.apache.http.entity.BasicHttpEntity;
import org.apache.http.impl.bootstrap.HttpServer;
import org.apache.http.impl.bootstrap.ServerBootstrap;
import org.apache.http.message.BasicHttpEntityEnclosingRequest;
import org.apache.http.protocol.HttpRequestHandlerMapper;
import org.apache.http.protocol.UriHttpRequestHandlerMapper;
import org.apache.http.util.EntityUtils;
import org.apache.james.transport.mailets.SerialiseToHTTP;
import org.apache.james.util.MimeMessageUtil;
import org.apache.mailet.Mail;
import org.apache.mailet.MailetConfig;
import org.apache.mailet.base.test.FakeMailetConfig;
import org.apache.mailet.base.test.MailUtil;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ListAssert;
import org.assertj.core.api.ObjectArrayAssert;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class SerialiseToHTTPTest {
    private static HttpServer server;
    private static UriHttpRequestHandlerMapper mapper;
    private Mail mail;
    private String urlTestPattern;

    @BeforeAll
    static void setupServer() throws MessagingException, IOException {
        mapper = new UriHttpRequestHandlerMapper();
        SocketConfig socketConfig = SocketConfig.custom().setSoTimeout(50000).build();
        server = ServerBootstrap.bootstrap().setListenerPort(0).setSocketConfig(socketConfig).setExceptionLogger(ExceptionLogger.NO_OP).setHandlerMapper((HttpRequestHandlerMapper)mapper).create();
        server.start();
    }

    @AfterAll
    static void shutdown() {
        server.shutdown(5L, TimeUnit.SECONDS);
    }

    @BeforeEach
    void setup() throws MessagingException, IOException {
        this.mail = MailUtil.createMockMail2Recipients((MimeMessage)MimeMessageUtil.mimeMessageFromStream((InputStream)ClassLoader.getSystemResourceAsStream("mime/sendToRemoteHttp.mime")));
    }

    @AfterEach
    void cleanMapper() throws MessagingException, IOException {
        mapper.unregister(this.urlTestPattern);
    }

    @Test
    void shouldBeFailedWhenServiceResponseIsNotOk() throws Exception {
        this.urlTestPattern = "/path/to/service/internal/error";
        FakeMailetConfig mailetConfig = FakeMailetConfig.builder().setProperty("parameterKey", "pKey").setProperty("parameterValue", "pValue").setProperty("messageKey", "mKey").setProperty("url", "http://" + server.getInetAddress().getHostAddress() + ":" + server.getLocalPort() + this.urlTestPattern).build();
        mapper.register(this.urlTestPattern, (request, response, context) -> response.setStatusCode(500));
        SerialiseToHTTP mailet = new SerialiseToHTTP();
        mailet.init((MailetConfig)mailetConfig);
        mailet.service(this.mail);
        ((ObjectArrayAssert)Assertions.assertThat((Object[])this.mail.getMessage().getHeader("X-toHTTP")).hasSize(1)).allSatisfy(header -> Assertions.assertThat((String)header).isEqualTo("Failed"));
        ((ObjectArrayAssert)Assertions.assertThat((Object[])this.mail.getMessage().getHeader("X-toHTTPFailure")).hasSize(1)).allSatisfy(header -> Assertions.assertThat((String)header).isEqualTo("HTTP/1.1 500 Internal Server Error"));
    }

    @Test
    void shouldBeFailedWhenServiceNotExists() throws Exception {
        this.urlTestPattern = "/path/to/service/failed";
        FakeMailetConfig mailetConfig = FakeMailetConfig.builder().setProperty("parameterKey", "pKey").setProperty("parameterValue", "pValue").setProperty("messageKey", "mKey").setProperty("url", "ftp://" + server.getInetAddress().getHostAddress() + ":" + server.getLocalPort() + this.urlTestPattern).build();
        SerialiseToHTTP mailet = new SerialiseToHTTP();
        mailet.init((MailetConfig)mailetConfig);
        mailet.service(this.mail);
        ((ObjectArrayAssert)Assertions.assertThat((Object[])this.mail.getMessage().getHeader("X-toHTTP")).hasSize(1)).allSatisfy(header -> Assertions.assertThat((String)header).isEqualTo("Failed"));
        ((ObjectArrayAssert)Assertions.assertThat((Object[])this.mail.getMessage().getHeader("X-toHTTPFailure")).hasSize(1)).allSatisfy(header -> Assertions.assertThat((String)header).isNotBlank());
    }

    @Test
    void shouldBeSucceededWhenServiceResponseIsOk() throws Exception {
        this.urlTestPattern = "/path/to/service/succeeded";
        FakeMailetConfig mailetConfig = FakeMailetConfig.builder().setProperty("parameterKey", "pKey").setProperty("parameterValue", "pValue").setProperty("messageKey", "mKey").setProperty("url", "http://" + server.getInetAddress().getHostAddress() + ":" + server.getLocalPort() + this.urlTestPattern).build();
        mapper.register(this.urlTestPattern, (request, response, context) -> response.setStatusCode(200));
        SerialiseToHTTP mailet = new SerialiseToHTTP();
        mailet.init((MailetConfig)mailetConfig);
        mailet.service(this.mail);
        ((ObjectArrayAssert)Assertions.assertThat((Object[])this.mail.getMessage().getHeader("X-toHTTP")).hasSize(1)).allSatisfy(header -> Assertions.assertThat((String)header).isEqualTo("Succeeded"));
    }

    @Test
    void serviceShouldNotModifyMessageContent() throws Exception {
        this.urlTestPattern = "/path/to/service/succeeded";
        String originalMessage = MimeMessageUtil.asString((MimeMessage)this.mail.getMessage());
        FakeMailetConfig mailetConfig = FakeMailetConfig.builder().setProperty("parameterKey", "pKey").setProperty("parameterValue", "pValue").setProperty("messageKey", "mKey").setProperty("url", "http://" + server.getInetAddress().getHostAddress() + ":" + server.getLocalPort() + this.urlTestPattern).build();
        mapper.register(this.urlTestPattern, (request, response, context) -> {
            Assertions.assertThat((String)request.getRequestLine().getMethod()).isEqualTo("POST");
            BasicHttpEntityEnclosingRequest basicRequest = (BasicHttpEntityEnclosingRequest)request;
            BasicHttpEntity entity = (BasicHttpEntity)basicRequest.getEntity();
            try {
                List params = URLEncodedUtils.parse((HttpEntity)entity);
                ((ListAssert)((ListAssert)Assertions.assertThat((List)params).hasSize(2)).anySatisfy(param -> {
                    Assertions.assertThat((String)param.getName()).isEqualTo("pKey");
                    Assertions.assertThat((String)param.getValue()).isEqualTo("pValue");
                })).anySatisfy(param -> {
                    Assertions.assertThat((String)param.getName()).isEqualTo("message");
                    Assertions.assertThat((String)param.getValue()).isEqualTo(originalMessage);
                });
            }
            finally {
                EntityUtils.consume((HttpEntity)basicRequest.getEntity());
            }
            response.setStatusCode(200);
        });
        SerialiseToHTTP mailet = new SerialiseToHTTP();
        mailet.init((MailetConfig)mailetConfig);
        mailet.service(this.mail);
    }

    @Test
    void shouldSetTheMailStateWhenPassThroughIsFalse() throws Exception {
        this.urlTestPattern = "/path/to/service/PassThroughIsFalse";
        FakeMailetConfig mailetConfig = FakeMailetConfig.builder().setProperty("parameterKey", "pKey").setProperty("parameterValue", "pValue").setProperty("messageKey", "mKey").setProperty("url", "http://" + server.getInetAddress().getHostAddress() + ":" + server.getLocalPort() + this.urlTestPattern).setProperty("passThrough", "false").build();
        mapper.register(this.urlTestPattern, (request, response, context) -> response.setStatusCode(200));
        SerialiseToHTTP mailet = new SerialiseToHTTP();
        mailet.init((MailetConfig)mailetConfig);
        mailet.service(this.mail);
        Assertions.assertThat((Object[])this.mail.getMessage().getHeader("X-toHTTP")).isNull();
        Assertions.assertThat((String)this.mail.getState()).isEqualTo("ghost");
    }

    @Test
    void shouldThrowMessagingExceptionWhenInvalidUrl() throws Exception {
        FakeMailetConfig mailetConfig = FakeMailetConfig.builder().setProperty("parameterKey", "pKey").setProperty("parameterValue", "pValue").setProperty("messageKey", "mKey").setProperty("url", "qwerty://invalid.url").build();
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> new SerialiseToHTTP().init((MailetConfig)mailetConfig)).isExactlyInstanceOf(MessagingException.class)).hasMessageContaining("Unable to contruct URL object from url");
    }

    @Test
    void shouldThrowMessagingExceptionWhenUrlIsNull() throws Exception {
        FakeMailetConfig mailetConfig = FakeMailetConfig.builder().setProperty("parameterKey", "pKey").setProperty("parameterValue", "pValue").setProperty("messageKey", "mKey").build();
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> new SerialiseToHTTP().init((MailetConfig)mailetConfig)).isExactlyInstanceOf(MessagingException.class)).hasMessageContaining("Please configure a targetUrl (\"url\")");
    }
}

