/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.transport.mailets;

import java.nio.charset.StandardCharsets;
import java.util.Properties;
import javax.mail.Session;
import javax.mail.internet.MimeMessage;
import org.apache.james.core.builder.MimeMessageBuilder;
import org.apache.james.transport.mailets.ReplaceContent;
import org.apache.james.util.MimeMessageUtil;
import org.apache.mailet.Mail;
import org.apache.mailet.MailetConfig;
import org.apache.mailet.base.test.FakeMail;
import org.apache.mailet.base.test.FakeMailetConfig;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class ReplaceContentTest {
    private ReplaceContent mailet;

    @BeforeEach
    void setup() {
        this.mailet = new ReplaceContent();
    }

    @Test
    void getMailetInfoShouldReturnValue() {
        Assertions.assertThat((String)this.mailet.getMailetInfo()).isEqualTo("ReplaceContent");
    }

    @Test
    void serviceShouldReplaceSubjectWhenMatching() throws Exception {
        FakeMailetConfig mailetConfig = FakeMailetConfig.builder().mailetName("Test").setProperty("subjectPattern", "/test/TEST/i/,/o/a//,/s/s/i/").build();
        this.mailet.init((MailetConfig)mailetConfig);
        FakeMail mail = FakeMail.builder().name("mail").mimeMessage(MimeMessageBuilder.mimeMessageBuilder().setSubject("one test")).build();
        this.mailet.service((Mail)mail);
        Assertions.assertThat((String)mail.getMessage().getSubject()).isEqualTo("ane TEsT");
    }

    @Test
    void serviceShouldReplaceBodyWhenMatching() throws Exception {
        FakeMailetConfig mailetConfig = FakeMailetConfig.builder().mailetName("Test").setProperty("bodyPattern", "/test/TEST/i/,/o/a/r/,/S/s/r/,/\u00e8/e'//,/test([^\\/]*?)bla/X$1Y/im/,/X(.\\n)Y/P$1Q//,/\\/\\/,//").build();
        this.mailet.init((MailetConfig)mailetConfig);
        MimeMessage message = new MimeMessage(Session.getDefaultInstance((Properties)new Properties()));
        message.setText("This is one simple test/ \u00e8 one simple test.\nBlo blo blo blo.\n");
        FakeMail mail = FakeMail.builder().name("mail").mimeMessage(message).build();
        this.mailet.service((Mail)mail);
        Assertions.assertThat((Object)mail.getMessage().getContent()).isEqualTo((Object)"This is ane simple TEsT, e' ane simple P.\nQ bla bla bla.\n");
    }

    @Test
    void serviceShouldNotLoopWhenCaseInsensitiveAndRepeat() throws Exception {
        FakeMailetConfig mailetConfig = FakeMailetConfig.builder().mailetName("Test").setProperty("bodyPattern", "/a/a/ir/").build();
        this.mailet.init((MailetConfig)mailetConfig);
        FakeMail mail = FakeMail.builder().name("mail").mimeMessage(MimeMessageBuilder.mimeMessageBuilder().setText("aaa")).build();
        this.mailet.service((Mail)mail);
        Assertions.assertThat((Object)mail.getMessage().getContent()).isEqualTo((Object)"aaa");
    }

    @Test
    void serviceShouldReplaceSubjectWhenConfigurationFromFile() throws Exception {
        FakeMailetConfig mailetConfig = FakeMailetConfig.builder().mailetName("Test").setProperty("subjectPatternFile", "#/org/apache/james/mailet/standard/mailets/replaceSubject.patterns").build();
        this.mailet.init((MailetConfig)mailetConfig);
        FakeMail mail = FakeMail.builder().name("mail").mimeMessage(MimeMessageBuilder.mimeMessageBuilder().setSubject("re: r:ri:one test")).build();
        this.mailet.service((Mail)mail);
        Assertions.assertThat((String)mail.getMessage().getSubject()).isEqualTo("Re: Re: Re: one test");
    }

    @Test
    void serviceShouldRemoveOrAddTextInBody() throws Exception {
        FakeMailetConfig mailetConfig = FakeMailetConfig.builder().mailetName("Test").setProperty("bodyPattern", "/--original message--/<quote>/i/,/<quote>(.*)(\\r\\n)([^>]+)/<quote>$1$2>$3/imrs/,/<quote>\\r\\n//im/").build();
        this.mailet.init((MailetConfig)mailetConfig);
        FakeMail mail = FakeMail.builder().name("mail").mimeMessage(MimeMessageBuilder.mimeMessageBuilder().setText("Test.\r\n\r\n--original message--\r\npart of\r\nmessage\\ that\\0 must0 be\r\nquoted. Let's see if\r\nhe can do it.")).build();
        this.mailet.service((Mail)mail);
        Assertions.assertThat((Object)mail.getMessage().getContent()).isEqualTo((Object)"Test.\r\n\r\n>part of\r\n>message\\ that\\0 must0 be\r\n>quoted. Let's see if\r\n>he can do it.");
    }

    @Test
    void serviceShouldReplaceBodyWhenMatchingASCIICharacter() throws Exception {
        FakeMailetConfig mailetConfig = FakeMailetConfig.builder().mailetName("Test").setProperty("bodyPattern", "/\\u2026/.../r/").build();
        this.mailet.init((MailetConfig)mailetConfig);
        FakeMail mail = FakeMail.builder().name("mail").mimeMessage(MimeMessageBuilder.mimeMessageBuilder().setSubject("one test").setText("Replacement \u2026 one test \u2026")).build();
        this.mailet.service((Mail)mail);
        Assertions.assertThat((Object)mail.getMessage().getContent()).isEqualTo((Object)"Replacement ... one test ...");
    }

    @Test
    void serviceShouldReplaceBodyWhenMatchingCharset() throws Exception {
        String messageSource = "Content-Type: text/plain; charset=\"iso-8859-1\"\r\nContent-Transfer-Encoding: quoted-printable\r\n\r\n=93test=94 with th=92 apex";
        FakeMailetConfig mailetConfig = FakeMailetConfig.builder().mailetName("Test").setProperty("bodyPattern", "/[\\u2018\\u2019\\u201A]/'//,/[\\u201C\\u201D\\u201E]/\"//,/[\\x91\\x92\\x82]/'//,/[\\x93\\x94\\x84]/\"/r/,/\\x85/...//,/\\x8B/<//,/\\x9B/>//,/\\x96/-//,/\\x97/--//,").build();
        this.mailet.init((MailetConfig)mailetConfig);
        MimeMessage message = MimeMessageUtil.mimeMessageFromString((String)messageSource);
        FakeMail mail = FakeMail.builder().name("mail").mimeMessage(message).build();
        this.mailet.service((Mail)mail);
        Assertions.assertThat((Object)mail.getMessage().getContent()).isEqualTo((Object)"\"test\" with th' apex");
    }

    @Test
    void serviceShouldSetContenTypeWhenInitialized() throws Exception {
        FakeMailetConfig mailetConfig = FakeMailetConfig.builder().mailetName("Test").setProperty("subjectPattern", "/test/TEST/i/,/o/a//,/s/s/i/").setProperty("charset", StandardCharsets.UTF_8.name()).build();
        this.mailet.init((MailetConfig)mailetConfig);
        FakeMail mail = FakeMail.builder().name("mail").mimeMessage(MimeMessageBuilder.mimeMessageBuilder().setSubject("one test").setText("This is one simple test/ \u00e8 one simple test.\nBlo blo blo blo.\n")).build();
        this.mailet.service((Mail)mail);
        Assertions.assertThat((String)mail.getMessage().getContentType()).isEqualTo("text/plain; charset=UTF-8");
    }
}

