/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.transport.mailets;

import java.io.InputStream;
import java.util.Collection;
import javax.mail.MessagingException;
import javax.mail.internet.MimeMessage;
import org.apache.james.core.MailAddress;
import org.apache.james.core.builder.MimeMessageBuilder;
import org.apache.james.transport.mailets.RemoveMimeHeader;
import org.apache.james.util.MimeMessageUtil;
import org.apache.mailet.Mail;
import org.apache.mailet.MailetConfig;
import org.apache.mailet.PerRecipientHeaders;
import org.apache.mailet.base.GenericMailet;
import org.apache.mailet.base.test.FakeMail;
import org.apache.mailet.base.test.FakeMailetConfig;
import org.apache.mailet.base.test.MailUtil;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;

class RemoveMimeHeaderTest {
    private static final String HEADER1 = "header1";
    private static final String HEADER2 = "header2";
    private static final String RECIPIENT1 = "r1@example.com";
    private static final String RECIPIENT2 = "r2@example.com";
    private GenericMailet mailet;

    RemoveMimeHeaderTest() {
    }

    @BeforeEach
    void setup() {
        this.mailet = new RemoveMimeHeader();
    }

    @Test
    void getMailetInfoShouldReturnValue() {
        Assertions.assertThat((String)this.mailet.getMailetInfo()).isEqualTo("RemoveMimeHeader Mailet");
    }

    @Test
    void serviceShouldRemoveHeaderWhenOneMatching() throws MessagingException {
        FakeMailetConfig mailetConfig = FakeMailetConfig.builder().mailetName("Test").setProperty("name", HEADER1).build();
        this.mailet.init((MailetConfig)mailetConfig);
        FakeMail mail = FakeMail.fromMessage((MimeMessageBuilder)MimeMessageBuilder.mimeMessageBuilder().addHeader(HEADER1, "true").addHeader(HEADER2, "true"));
        this.mailet.service((Mail)mail);
        Assertions.assertThat((Object[])mail.getMessage().getHeader(HEADER1)).isNull();
        Assertions.assertThat((Object[])mail.getMessage().getHeader(HEADER2)).isNotNull();
    }

    @Test
    public void serviceShouldRemoveSpecificHeaderWhenOneMatching() throws MessagingException {
        FakeMailetConfig mailetConfig = FakeMailetConfig.builder().mailetName("Test").setProperty("name", HEADER1).build();
        this.mailet.init((MailetConfig)mailetConfig);
        FakeMail mail = FakeMail.fromMessage((MimeMessageBuilder)MimeMessageBuilder.mimeMessageBuilder().addToRecipient(RECIPIENT1).addToRecipient(RECIPIENT2));
        mail.addSpecificHeaderForRecipient(PerRecipientHeaders.Header.builder().name(HEADER1).value("1").build(), new MailAddress(RECIPIENT1));
        mail.addSpecificHeaderForRecipient(PerRecipientHeaders.Header.builder().name(HEADER2).value("1").build(), new MailAddress(RECIPIENT2));
        this.mailet.service((Mail)mail);
        Assertions.assertThat((Object[])mail.getMessage().getHeader(HEADER1)).isNull();
        Assertions.assertThat((Object[])mail.getMessage().getHeader(HEADER2)).isNull();
        Assertions.assertThat((Collection)mail.getPerRecipientSpecificHeaders().getHeaderNamesForRecipient(new MailAddress(RECIPIENT1))).isEmpty();
        Assertions.assertThat((Collection)mail.getPerRecipientSpecificHeaders().getHeaderNamesForRecipient(new MailAddress(RECIPIENT2))).isNotEmpty();
    }

    @Test
    void serviceShouldRemoveHeadersWhenTwoMatching() throws MessagingException {
        FakeMailetConfig mailetConfig = FakeMailetConfig.builder().mailetName("Test").setProperty("name", "header1,header2").build();
        this.mailet.init((MailetConfig)mailetConfig);
        FakeMail mail = FakeMail.fromMessage((MimeMessageBuilder)MimeMessageBuilder.mimeMessageBuilder().addHeader(HEADER1, "true").addHeader(HEADER2, "true"));
        this.mailet.service((Mail)mail);
        Assertions.assertThat((Object[])mail.getMessage().getHeader(HEADER1)).isNull();
        Assertions.assertThat((Object[])mail.getMessage().getHeader(HEADER2)).isNull();
    }

    @Test
    public void serviceShouldRemoveSpecificHeadersWhenTwoMatching() throws MessagingException {
        FakeMailetConfig mailetConfig = FakeMailetConfig.builder().mailetName("Test").setProperty("name", "header1,header2").build();
        this.mailet.init((MailetConfig)mailetConfig);
        FakeMail mail = FakeMail.fromMessage((MimeMessageBuilder)MimeMessageBuilder.mimeMessageBuilder().addToRecipient(RECIPIENT1).addToRecipient(RECIPIENT2));
        mail.addSpecificHeaderForRecipient(PerRecipientHeaders.Header.builder().name(HEADER1).value("1").build(), new MailAddress(RECIPIENT1));
        mail.addSpecificHeaderForRecipient(PerRecipientHeaders.Header.builder().name(HEADER2).value("1").build(), new MailAddress(RECIPIENT2));
        this.mailet.service((Mail)mail);
        Assertions.assertThat((Object[])mail.getMessage().getHeader(HEADER1)).isNull();
        Assertions.assertThat((Object[])mail.getMessage().getHeader(HEADER2)).isNull();
        Assertions.assertThat((Collection)mail.getPerRecipientSpecificHeaders().getHeaderNamesForRecipient(new MailAddress(RECIPIENT1))).isEmpty();
        Assertions.assertThat((Collection)mail.getPerRecipientSpecificHeaders().getHeaderNamesForRecipient(new MailAddress(RECIPIENT2))).isEmpty();
    }

    @Test
    public void serviceShouldRemoveSpecificAndGlobalHeadersWhenMixed() throws MessagingException {
        FakeMailetConfig mailetConfig = FakeMailetConfig.builder().mailetName("Test").setProperty("name", HEADER1).build();
        this.mailet.init((MailetConfig)mailetConfig);
        FakeMail mail = FakeMail.fromMessage((MimeMessageBuilder)MimeMessageBuilder.mimeMessageBuilder().addToRecipient(RECIPIENT1).addToRecipient(RECIPIENT2).addHeader(HEADER1, "true").addHeader(HEADER2, "true"));
        mail.addSpecificHeaderForRecipient(PerRecipientHeaders.Header.builder().name(HEADER1).value("1").build(), new MailAddress(RECIPIENT1));
        mail.addSpecificHeaderForRecipient(PerRecipientHeaders.Header.builder().name(HEADER2).value("1").build(), new MailAddress(RECIPIENT2));
        this.mailet.service((Mail)mail);
        Assertions.assertThat((Object[])mail.getMessage().getHeader(HEADER1)).isNull();
        Assertions.assertThat((Object[])mail.getMessage().getHeader(HEADER2)).isNotNull();
        Assertions.assertThat((Collection)mail.getPerRecipientSpecificHeaders().getHeaderNamesForRecipient(new MailAddress(RECIPIENT1))).isEmpty();
        Assertions.assertThat((Collection)mail.getPerRecipientSpecificHeaders().getHeaderNamesForRecipient(new MailAddress(RECIPIENT2))).isNotEmpty();
    }

    @Test
    void serviceShouldNotRemoveHeaderWhenNoneMatching() throws MessagingException {
        FakeMailetConfig mailetConfig = FakeMailetConfig.builder().mailetName("Test").setProperty("name", "other1").setProperty("name", "other2").build();
        this.mailet.init((MailetConfig)mailetConfig);
        FakeMail mail = FakeMail.fromMessage((MimeMessageBuilder)MimeMessageBuilder.mimeMessageBuilder().addHeader(HEADER1, "true").addHeader(HEADER2, "true"));
        this.mailet.service((Mail)mail);
        Assertions.assertThat((Object[])mail.getMessage().getHeader(HEADER1)).isNotNull();
        Assertions.assertThat((Object[])mail.getMessage().getHeader(HEADER2)).isNotNull();
    }

    @Test
    void serviceShouldNotThrowWhenNoneMatchingAndIncorrectHeaders() throws MessagingException {
        FakeMailetConfig mailetConfig = FakeMailetConfig.builder().mailetName("Test").setProperty("name", "").build();
        this.mailet.init((MailetConfig)mailetConfig);
        FakeMail mail = MailUtil.createMockMail2Recipients((MimeMessage)MimeMessageUtil.mimeMessageFromStream((InputStream)ClassLoader.getSystemResourceAsStream("mime/incorrect-headers.mime")));
        Assertions.assertThatCode(() -> this.lambda$serviceShouldNotThrowWhenNoneMatchingAndIncorrectHeaders$0((Mail)mail)).doesNotThrowAnyException();
    }

    @Test
    void serviceShouldNotRemoveHeaderWhenEmptyConfig() throws MessagingException {
        FakeMailetConfig mailetConfig = FakeMailetConfig.builder().mailetName("Test").setProperty("name", "").build();
        this.mailet.init((MailetConfig)mailetConfig);
        FakeMail mail = FakeMail.fromMessage((MimeMessageBuilder)MimeMessageBuilder.mimeMessageBuilder().addHeader(HEADER1, "true").addHeader(HEADER2, "true"));
        this.mailet.service((Mail)mail);
        Assertions.assertThat((Object[])mail.getMessage().getHeader(HEADER1)).isNotNull();
        Assertions.assertThat((Object[])mail.getMessage().getHeader(HEADER2)).isNotNull();
    }

    @Test
    void initShouldThrowWhenInvalidConfig() {
        FakeMailetConfig mailetConfig = FakeMailetConfig.builder().mailetName("Test").build();
        Assertions.assertThatThrownBy(() -> this.mailet.init((MailetConfig)mailetConfig)).isInstanceOf(MessagingException.class);
    }

    @Test
    void serviceShouldThrowWhenExceptionOccured() throws MessagingException {
        FakeMailetConfig mailetConfig = FakeMailetConfig.builder().mailetName("Test").setProperty("name", "").build();
        this.mailet.init((MailetConfig)mailetConfig);
        Mail mail = (Mail)Mockito.mock(Mail.class);
        Mockito.when((Object)mail.getMessage()).thenThrow(MessagingException.class);
        Assertions.assertThatThrownBy(() -> this.mailet.service(mail)).isInstanceOf(MessagingException.class);
    }

    private /* synthetic */ void lambda$serviceShouldNotThrowWhenNoneMatchingAndIncorrectHeaders$0(Mail mail) throws Throwable {
        this.mailet.service(mail);
    }
}

