/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.transport.mailets;

import java.util.Collection;
import java.util.List;
import javax.mail.MessagingException;
import org.apache.james.core.MailAddress;
import org.apache.james.core.builder.MimeMessageBuilder;
import org.apache.james.transport.mailets.RemoveMimeHeaderByPrefix;
import org.apache.james.transport.mailets.utils.MimeMessageUtils;
import org.apache.mailet.Mail;
import org.apache.mailet.MailetConfig;
import org.apache.mailet.PerRecipientHeaders;
import org.apache.mailet.base.GenericMailet;
import org.apache.mailet.base.test.FakeMail;
import org.apache.mailet.base.test.FakeMailetConfig;
import org.assertj.core.api.AbstractListAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

class RemoveMimeHeaderByPrefixTest {
    private static final String PREFIX = "X-OPENPAAS-";
    private static final String HEADER_NAME_PREFIX_1 = "X-OPENPAAS-FEATURE-A";
    private static final String HEADER_NAME_PREFIX_2 = "X-OPENPAAS-FEATURE-B";
    private static final String HEADER_NAME_NO_PREFIX = "X-OTHER-BUSINESS";
    private static final String RECIPIENT1 = "r1@example.com";
    private static final String RECIPIENT2 = "r2@example.com";
    private static final String RECIPIENT3 = "r3@example.com";
    private GenericMailet mailet;

    RemoveMimeHeaderByPrefixTest() {
    }

    @BeforeEach
    void setup() {
        this.mailet = new RemoveMimeHeaderByPrefix();
    }

    @Test
    void getMailetInfoShouldReturnValue() {
        Assertions.assertThat((String)this.mailet.getMailetInfo()).isEqualTo("RemoveMimeHeaderByPrefix Mailet");
    }

    @Test
    void serviceShouldRemoveHeaderWhenPrefixed() throws MessagingException {
        FakeMailetConfig mailetConfig = FakeMailetConfig.builder().mailetName("Test").setProperty("prefix", PREFIX).build();
        this.mailet.init((MailetConfig)mailetConfig);
        FakeMail mail = FakeMail.fromMessage((MimeMessageBuilder)MimeMessageBuilder.mimeMessageBuilder().addHeader(HEADER_NAME_PREFIX_1, "true"));
        this.mailet.service((Mail)mail);
        Assertions.assertThat((List)new MimeMessageUtils(mail.getMessage()).toHeaderList()).extracting("name").doesNotContain(new Object[]{HEADER_NAME_PREFIX_1});
    }

    @Test
    void serviceShouldRemoveAllPrefixedHeaders() throws MessagingException {
        FakeMailetConfig mailetConfig = FakeMailetConfig.builder().mailetName("Test").setProperty("prefix", PREFIX).build();
        this.mailet.init((MailetConfig)mailetConfig);
        FakeMail mail = FakeMail.fromMessage((MimeMessageBuilder)MimeMessageBuilder.mimeMessageBuilder().addHeader(HEADER_NAME_PREFIX_1, "true").addHeader(HEADER_NAME_PREFIX_2, "true"));
        this.mailet.service((Mail)mail);
        Assertions.assertThat((List)new MimeMessageUtils(mail.getMessage()).toHeaderList()).extracting("name").doesNotContain(new Object[]{HEADER_NAME_PREFIX_1, HEADER_NAME_PREFIX_2});
    }

    @Test
    void serviceShouldRemoveAllPrefixedHeadersMixed() throws MessagingException {
        FakeMailetConfig mailetConfig = FakeMailetConfig.builder().mailetName("Test").setProperty("prefix", PREFIX).build();
        this.mailet.init((MailetConfig)mailetConfig);
        FakeMail mail = FakeMail.fromMessage((MimeMessageBuilder)MimeMessageBuilder.mimeMessageBuilder().addHeader(HEADER_NAME_PREFIX_1, "true"));
        mail.addSpecificHeaderForRecipient(PerRecipientHeaders.Header.builder().name(HEADER_NAME_PREFIX_2).value("1").build(), new MailAddress(RECIPIENT1));
        mail.addSpecificHeaderForRecipient(PerRecipientHeaders.Header.builder().name(PREFIX).value("1").build(), new MailAddress(RECIPIENT2));
        mail.addSpecificHeaderForRecipient(PerRecipientHeaders.Header.builder().name(HEADER_NAME_NO_PREFIX).value("1").build(), new MailAddress(RECIPIENT3));
        this.mailet.service((Mail)mail);
        Assertions.assertThat((List)new MimeMessageUtils(mail.getMessage()).toHeaderList()).extracting("name").doesNotContain(new Object[]{PREFIX, HEADER_NAME_PREFIX_1, HEADER_NAME_PREFIX_2});
        Assertions.assertThat((Collection)mail.getPerRecipientSpecificHeaders().getHeaderNamesForRecipient(new MailAddress(RECIPIENT1))).isEmpty();
        Assertions.assertThat((Collection)mail.getPerRecipientSpecificHeaders().getHeaderNamesForRecipient(new MailAddress(RECIPIENT2))).isEmpty();
        Assertions.assertThat((Collection)mail.getPerRecipientSpecificHeaders().getHeaderNamesForRecipient(new MailAddress(RECIPIENT3))).isNotEmpty();
    }

    @Test
    void serviceShouldNotRemoveNonPrefixedHeaders() throws MessagingException {
        FakeMailetConfig mailetConfig = FakeMailetConfig.builder().mailetName("Test").setProperty("prefix", PREFIX).build();
        this.mailet.init((MailetConfig)mailetConfig);
        FakeMail mail = FakeMail.fromMessage((MimeMessageBuilder)MimeMessageBuilder.mimeMessageBuilder().addHeader(HEADER_NAME_PREFIX_1, "true").addHeader(HEADER_NAME_NO_PREFIX, "true"));
        this.mailet.service((Mail)mail);
        ((AbstractListAssert)Assertions.assertThat((List)new MimeMessageUtils(mail.getMessage()).toHeaderList()).extracting("name").contains(new Object[]{HEADER_NAME_NO_PREFIX})).doesNotContain(new Object[]{HEADER_NAME_PREFIX_1});
    }

    @Test
    void exactMatchOfPrefixShouldBeAllowed() throws MessagingException {
        FakeMailetConfig mailetConfig = FakeMailetConfig.builder().mailetName("Test").setProperty("prefix", PREFIX).build();
        this.mailet.init((MailetConfig)mailetConfig);
        FakeMail mail = FakeMail.fromMessage((MimeMessageBuilder)MimeMessageBuilder.mimeMessageBuilder().addHeader(PREFIX, "true").addHeader(HEADER_NAME_NO_PREFIX, "true"));
        this.mailet.service((Mail)mail);
        Assertions.assertThat((List)new MimeMessageUtils(mail.getMessage()).toHeaderList()).extracting("name").doesNotContain(new Object[]{PREFIX});
        Assertions.assertThat((Object[])mail.getMessage().getHeader(PREFIX)).isNull();
    }

    @Test
    void initShouldThrowWhenInvalidConfig() {
        FakeMailetConfig mailetConfig = FakeMailetConfig.builder().mailetName("Test").build();
        Assertions.assertThatThrownBy(() -> this.mailet.init((MailetConfig)mailetConfig)).isInstanceOf(MessagingException.class);
    }

    @Test
    void initShouldThrowWhenPrefixEmpty() {
        FakeMailetConfig mailetConfig = FakeMailetConfig.builder().mailetName("Test").setProperty("prefix", "").build();
        Assertions.assertThatThrownBy(() -> this.mailet.init((MailetConfig)mailetConfig)).isInstanceOf(MessagingException.class);
    }
}

