/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.transport.mailets;

import java.util.stream.Stream;
import javax.mail.MessagingException;
import org.apache.james.transport.mailets.RemoveMailAttribute;
import org.apache.mailet.Attribute;
import org.apache.mailet.AttributeName;
import org.apache.mailet.AttributeValue;
import org.apache.mailet.Mail;
import org.apache.mailet.Mailet;
import org.apache.mailet.MailetConfig;
import org.apache.mailet.MailetException;
import org.apache.mailet.base.test.FakeMail;
import org.apache.mailet.base.test.FakeMailetConfig;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

class RemoveMailAttributeTest {
    private static final AttributeName ATTRIBUTE_1 = AttributeName.of((String)"attribute1");
    private static final AttributeName ATTRIBUTE_2 = AttributeName.of((String)"attribute2");
    private static final AttributeName ATTRIBUTE_3 = AttributeName.of((String)"attribute3");
    private static final Attribute VALUE_1 = new Attribute(ATTRIBUTE_1, AttributeValue.of((String)"value1"));
    private static final Attribute VALUE_2 = new Attribute(ATTRIBUTE_2, AttributeValue.of((String)"value2"));
    private static final Attribute VALUE_3 = new Attribute(ATTRIBUTE_3, AttributeValue.of((String)"value3"));
    private static final String ATTRIBUTE1_ATTRIBUTE2 = "attribute1, attribute2";
    private Mailet removeMailet;

    RemoveMailAttributeTest() {
    }

    @BeforeEach
    void setup() {
        this.removeMailet = new RemoveMailAttribute();
    }

    @Test
    void getMailetInfoShouldReturnCorrectInformation() {
        Assertions.assertThat((String)this.removeMailet.getMailetInfo()).isEqualTo("Remove Mail Attribute Mailet");
    }

    @Test
    void initShouldThrowExceptionIfMailetConfigDoesNotContainAttribute() {
        FakeMailetConfig mailetConfig = FakeMailetConfig.builder().mailetName("Test").build();
        Assertions.assertThatThrownBy(() -> this.removeMailet.init((MailetConfig)mailetConfig)).isInstanceOf(MailetException.class);
    }

    @Test
    void serviceShouldThrowExceptionWithMailNull() {
        Assertions.assertThatThrownBy(() -> this.removeMailet.service(null)).isInstanceOf(NullPointerException.class);
    }

    @Test
    void serviceShouldDoNothingWhenMailHasEmptyAttribute() throws MessagingException {
        FakeMailetConfig mailetConfig = FakeMailetConfig.builder().mailetName("Test").setProperty("name", ATTRIBUTE1_ATTRIBUTE2).build();
        this.removeMailet.init((MailetConfig)mailetConfig);
        FakeMail mail = FakeMail.builder().name("mail").build();
        this.removeMailet.service((Mail)mail);
        Assertions.assertThat((Stream)mail.attributes()).isEmpty();
    }

    @Test
    void serviceShouldDoNothingWhenMailDoNotMatchAttribute() throws MessagingException {
        FakeMailetConfig mailetConfig = FakeMailetConfig.builder().mailetName("Test").setProperty("name", ATTRIBUTE1_ATTRIBUTE2).build();
        this.removeMailet.init((MailetConfig)mailetConfig);
        FakeMail mail = FakeMail.builder().name("mail").attribute(VALUE_3).build();
        this.removeMailet.service((Mail)mail);
        Assertions.assertThat((Stream)mail.attributes()).containsExactly((Object[])new Attribute[]{VALUE_3});
    }

    @Test
    void serviceShouldRemoveSpecifiedAttribute() throws MessagingException {
        FakeMailetConfig mailetConfig = FakeMailetConfig.builder().mailetName("Test").setProperty("name", ATTRIBUTE_1.asString()).build();
        this.removeMailet.init((MailetConfig)mailetConfig);
        FakeMail mail = FakeMail.builder().name("mail").attribute(VALUE_1).attribute(VALUE_2).attribute(VALUE_3).build();
        this.removeMailet.service((Mail)mail);
        Assertions.assertThat((Stream)mail.attributes()).containsOnly((Object[])new Attribute[]{VALUE_2, VALUE_3});
    }

    @Test
    void serviceShouldRemoveSpecifiedAttributes() throws MessagingException {
        FakeMailetConfig mailetConfig = FakeMailetConfig.builder().mailetName("Test").setProperty("name", ATTRIBUTE1_ATTRIBUTE2).build();
        this.removeMailet.init((MailetConfig)mailetConfig);
        FakeMail mail = FakeMail.builder().name("mail").attribute(VALUE_1).attribute(VALUE_2).attribute(VALUE_3).build();
        this.removeMailet.service((Mail)mail);
        Assertions.assertThat((Stream)mail.attributes()).containsExactly((Object[])new Attribute[]{VALUE_3});
    }
}

