/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.transport.mailets;

import java.util.stream.Stream;
import javax.mail.MessagingException;
import org.apache.james.transport.mailets.RemoveAllMailAttributes;
import org.apache.mailet.Attribute;
import org.apache.mailet.Mail;
import org.apache.mailet.Mailet;
import org.apache.mailet.MailetConfig;
import org.apache.mailet.base.test.FakeMailetConfig;
import org.apache.mailet.base.test.MailUtil;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class RemoveAllMailAttributesTest {
    private Mail mail;
    private Mailet mailet;

    @BeforeEach
    public void setUp() throws Exception {
        FakeMailetConfig mailetConfig = FakeMailetConfig.builder().mailetName("Test").build();
        this.mailet = new RemoveAllMailAttributes();
        this.mailet.init((MailetConfig)mailetConfig);
    }

    @Test
    public void getMailetInfoShouldReturnValue() {
        Assertions.assertThat((String)this.mailet.getMailetInfo()).isEqualTo("Remove All Mail Attributes Mailet");
    }

    @Test
    public void serviceShouldRemoveAllMailAttributes() throws MessagingException {
        this.mail = MailUtil.createMockMail2Recipients();
        this.mail.setAttribute(Attribute.convertToAttribute((String)"org.apache.james.test.junit", (Object)"true"));
        this.mailet.service(this.mail);
        Assertions.assertThat((Stream)this.mail.attributes()).isEmpty();
    }

    @Test
    public void serviceShouldRemoveAllMailAttributesWhenNone() throws MessagingException {
        this.mail = MailUtil.createMockMail2Recipients();
        this.mailet.service(this.mail);
        Assertions.assertThat((Stream)this.mail.attributes()).isEmpty();
    }
}

