/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.transport.mailets;

import java.util.Collection;
import org.apache.james.core.MailAddress;
import org.apache.james.transport.mailets.RecipientToLowerCase;
import org.apache.mailet.Mail;
import org.apache.mailet.base.test.FakeMail;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class RecipientToLowerCaseTest {
    private RecipientToLowerCase testee;

    @BeforeEach
    public void setUp() {
        this.testee = new RecipientToLowerCase();
    }

    @Test
    public void serviceShouldPutRecipientToLowerCase() throws Exception {
        FakeMail fakeMail = FakeMail.builder().name("mail").recipient("THienan1234@gmail.com").build();
        this.testee.service((Mail)fakeMail);
        Collection recipients = fakeMail.getRecipients();
        Assertions.assertThat((Collection)recipients).extracting(MailAddress::asString).containsOnly((Object[])new String[]{"thienan1234@gmail.com"});
    }

    @Test
    public void serviceShouldHaveNoEffectWhenNoRecipient() throws Exception {
        FakeMail fakeMail = FakeMail.builder().name("mail").build();
        this.testee.service((Mail)fakeMail);
        Assertions.assertThat((Collection)fakeMail.getRecipients()).isEmpty();
    }
}

