/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.transport.mailets;

import javax.mail.MessagingException;
import org.apache.james.transport.mailets.PropagateError;
import org.apache.mailet.Mail;
import org.apache.mailet.MailetConfig;
import org.apache.mailet.base.test.FakeMail;
import org.apache.mailet.base.test.FakeMailContext;
import org.apache.mailet.base.test.FakeMailetConfig;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

class PropagateErrorTest {
    private PropagateError testee;

    PropagateErrorTest() {
    }

    @BeforeEach
    public void setUp() throws Exception {
        this.testee = new PropagateError();
        this.testee.init((MailetConfig)FakeMailetConfig.builder().mailetContext(FakeMailContext.builder()).build());
    }

    @Test
    public void shouldThrowWhenNoErrorMessage() throws Exception {
        FakeMail mail = FakeMail.builder().name("mail").build();
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.lambda$shouldThrowWhenNoErrorMessage$0((Mail)mail)).isInstanceOf(MessagingException.class)).hasMessage("Propagating previously encountered mailet processing errors: null");
    }

    @Test
    public void shouldThrowWhenErrorMessage() throws Exception {
        FakeMail mail = FakeMail.builder().name("mail").errorMessage("This is what happened").build();
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.lambda$shouldThrowWhenErrorMessage$1((Mail)mail)).isInstanceOf(MessagingException.class)).hasMessage("Propagating previously encountered mailet processing errors: This is what happened");
    }

    private /* synthetic */ void lambda$shouldThrowWhenErrorMessage$1(Mail mail) throws Throwable {
        this.testee.service(mail);
    }

    private /* synthetic */ void lambda$shouldThrowWhenNoErrorMessage$0(Mail mail) throws Throwable {
        this.testee.service(mail);
    }
}

