/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.transport.mailets;

import java.util.Collection;
import org.apache.james.core.MailAddress;
import org.apache.james.transport.mailets.PostmasterAlias;
import org.apache.mailet.Mail;
import org.apache.mailet.MailetConfig;
import org.apache.mailet.base.MailAddressFixture;
import org.apache.mailet.base.test.FakeMail;
import org.apache.mailet.base.test.FakeMailContext;
import org.apache.mailet.base.test.FakeMailetConfig;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class PostmasterAliasTest {
    private PostmasterAlias testee;
    private MailAddress postmaster;
    private MailAddress postmasterAlias;

    @BeforeEach
    public void setUp() throws Exception {
        this.postmaster = new MailAddress("admin@localhost");
        this.postmasterAlias = new MailAddress("postmaster@localhost");
        this.testee = new PostmasterAlias();
        this.testee.init((MailetConfig)FakeMailetConfig.builder().mailetContext(FakeMailContext.builder().postmaster(this.postmaster)).build());
    }

    @Test
    public void serviceShouldAcceptMailsWithNoRecipients() throws Exception {
        FakeMail mail = FakeMail.builder().name("mail").build();
        this.testee.service((Mail)mail);
        Assertions.assertThat((Collection)mail.getRecipients()).isEmpty();
    }

    @Test
    public void serviceShouldNotAlterMailsForPostmaster() throws Exception {
        FakeMail mail = FakeMail.builder().name("mail").recipient(this.postmaster).build();
        this.testee.service((Mail)mail);
        Assertions.assertThat((Collection)mail.getRecipients()).containsOnly((Object[])new MailAddress[]{this.postmaster});
    }

    @Test
    public void serviceShouldNotAlterMailForOtherUsers() throws Exception {
        FakeMail mail = FakeMail.builder().name("mail").recipient(MailAddressFixture.ANY_AT_JAMES).build();
        this.testee.service((Mail)mail);
        Assertions.assertThat((Collection)mail.getRecipients()).containsOnly((Object[])new MailAddress[]{MailAddressFixture.ANY_AT_JAMES});
    }

    @Test
    public void serviceShouldNotAlterPostmasterAliasWhenForOtherDomains() throws Exception {
        MailAddress otherDomainPostmaster = new MailAddress("postmaster@otherDomain");
        FakeMail mail = FakeMail.builder().name("mail").recipient(otherDomainPostmaster).build();
        this.testee.service((Mail)mail);
        Assertions.assertThat((Collection)mail.getRecipients()).containsOnly((Object[])new MailAddress[]{otherDomainPostmaster});
    }

    @Test
    public void serviceShouldRewritePostmasterAlias() throws Exception {
        FakeMail mail = FakeMail.builder().name("mail").recipient(this.postmasterAlias).build();
        this.testee.service((Mail)mail);
        Assertions.assertThat((Collection)mail.getRecipients()).containsOnly((Object[])new MailAddress[]{this.postmaster});
    }

    @Test
    public void serviceShouldNotAlterOtherRecipientsWhenRewritingPostmaster() throws Exception {
        FakeMail mail = FakeMail.builder().name("mail").recipients(new MailAddress[]{this.postmasterAlias, MailAddressFixture.ANY_AT_JAMES}).build();
        this.testee.service((Mail)mail);
        Assertions.assertThat((Collection)mail.getRecipients()).containsOnly((Object[])new MailAddress[]{this.postmaster, MailAddressFixture.ANY_AT_JAMES});
    }

    @Test
    public void serviceShouldNotDuplicatePostmaster() throws Exception {
        FakeMail mail = FakeMail.builder().name("mail").recipients(new MailAddress[]{this.postmasterAlias, this.postmaster}).build();
        this.testee.service((Mail)mail);
        Assertions.assertThat((Collection)mail.getRecipients()).containsOnly((Object[])new MailAddress[]{this.postmaster});
    }
}

