/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.transport.mailets;

import java.util.List;
import java.util.regex.Pattern;
import org.apache.james.transport.mailets.PatternExtractor;
import org.apache.james.transport.mailets.ReplacingPattern;
import org.apache.mailet.MailetException;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

class PatternExtractorTest {
    private PatternExtractor testee;

    PatternExtractorTest() {
    }

    @BeforeEach
    void setup() {
        this.testee = new PatternExtractor();
    }

    @Test
    void getPatternsFromStringShouldReturnValuesWhenMultiplePatterns() throws Exception {
        List patternsFromString = this.testee.getPatternsFromString("/test/TEST/i/,/a/e//,/o/o/ir/");
        Assertions.assertThat((List)patternsFromString).containsOnly((Object[])new ReplacingPattern[]{new ReplacingPattern(Pattern.compile("test"), false, "TEST"), new ReplacingPattern(Pattern.compile("a"), false, "e"), new ReplacingPattern(Pattern.compile("o"), true, "o")});
    }

    @Test
    void getPatternsFromFileListShouldReturnValuesWhenMultiplePatterns() throws Exception {
        List patternsFromFileList = this.testee.getPatternsFromFileList("#/org/apache/james/mailet/standard/mailets/replaceSubject.patterns");
        Assertions.assertThat((List)patternsFromFileList).containsOnly((Object[])new ReplacingPattern[]{new ReplacingPattern(Pattern.compile("re:[ ]*"), false, "Re: "), new ReplacingPattern(Pattern.compile("ri:[ ]*"), false, "Re: "), new ReplacingPattern(Pattern.compile("r:[ ]*"), false, "Re: ")});
    }

    @Test
    void getPatternsFromStringShouldThrowWhenPatternIsLessThanTwoCharacters() {
        Assertions.assertThatThrownBy(() -> this.testee.getPatternsFromString("a")).isInstanceOf(MailetException.class);
    }

    @Test
    void getPatternsFromStringShouldThrowWhenPatternDoesNotStartWithSlash() {
        Assertions.assertThatThrownBy(() -> this.testee.getPatternsFromString("abc/")).isInstanceOf(MailetException.class);
    }

    @Test
    void getPatternsFromStringShouldThrowWhenPatternDoesNotEndWithSlash() {
        Assertions.assertThatThrownBy(() -> this.testee.getPatternsFromString("/abc")).isInstanceOf(MailetException.class);
    }

    @Test
    void serviceShouldUnescapeCarriageReturn() throws Exception {
        List patternsFromString = this.testee.getPatternsFromString("/a/\\\\r/i/");
        Assertions.assertThat((List)patternsFromString).containsOnly((Object[])new ReplacingPattern[]{new ReplacingPattern(Pattern.compile("a"), false, "\\\r")});
    }

    @Test
    void serviceShouldUnescapeLineBreak() throws Exception {
        List patternsFromString = this.testee.getPatternsFromString("/a/\\\\n/i/");
        Assertions.assertThat((List)patternsFromString).containsOnly((Object[])new ReplacingPattern[]{new ReplacingPattern(Pattern.compile("a"), false, "\\\n")});
    }

    @Test
    void serviceShouldUnescapeTabReturn() throws Exception {
        List patternsFromString = this.testee.getPatternsFromString("/a/\\\\t/i/");
        Assertions.assertThat((List)patternsFromString).containsOnly((Object[])new ReplacingPattern[]{new ReplacingPattern(Pattern.compile("a"), false, "\\\t")});
    }
}

