/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.transport.mailets;

import java.io.IOException;
import java.util.Properties;
import javax.mail.BodyPart;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.Session;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import org.apache.james.transport.mailets.OnlyText;
import org.apache.mailet.Mail;
import org.apache.mailet.MailetConfig;
import org.apache.mailet.base.test.FakeMail;
import org.apache.mailet.base.test.FakeMailetConfig;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class OnlyTextTest {
    OnlyTextTest() {
    }

    @Test
    void testService() throws MessagingException, IOException {
        OnlyText mailet = new OnlyText();
        FakeMailetConfig mci = FakeMailetConfig.builder().mailetName("Test").build();
        mailet.init((MailetConfig)mci);
        MimeMessage message = new MimeMessage(Session.getDefaultInstance((Properties)new Properties()));
        message.setSubject("prova");
        message.setText("Questa \u00e8 una prova");
        message.saveChanges();
        FakeMail mail = FakeMail.builder().name("mail").mimeMessage(message).build();
        mailet.service((Mail)mail);
        Assertions.assertThat((String)mail.getMessage().getSubject()).isEqualTo("prova");
        Assertions.assertThat((Object)mail.getMessage().getContent()).isEqualTo((Object)"Questa \u00e8 una prova");
        message = new MimeMessage(Session.getDefaultInstance((Properties)new Properties()));
        message.setSubject("prova");
        MimeMultipart mp = new MimeMultipart();
        MimeBodyPart bp = new MimeBodyPart();
        bp.setText("Questo \u00e8 un part interno1");
        mp.addBodyPart((BodyPart)bp);
        bp = new MimeBodyPart();
        bp.setText("Questo \u00e8 un part interno2");
        mp.addBodyPart((BodyPart)bp);
        bp = new MimeBodyPart();
        MimeMessage message2 = new MimeMessage(Session.getDefaultInstance((Properties)new Properties()));
        bp.setContent((Object)message2, "message/rfc822");
        mp.addBodyPart((BodyPart)bp);
        message.setContent((Multipart)mp);
        message.saveChanges();
        mail = FakeMail.builder().name("mail").mimeMessage(message).build();
        mailet.service((Mail)mail);
        Assertions.assertThat((String)mail.getMessage().getSubject()).isEqualTo("prova");
        Assertions.assertThat((Object)mail.getMessage().getContent()).isEqualTo((Object)"Questo \u00e8 un part interno1");
        message = new MimeMessage(Session.getDefaultInstance((Properties)new Properties()));
        message.setSubject("prova");
        mp = new MimeMultipart();
        bp = new MimeBodyPart();
        bp.setText("Questo \u00e8 un part interno1");
        mp.addBodyPart((BodyPart)bp);
        bp = new MimeBodyPart();
        bp.setText("Questo \u00e8 un part interno2");
        mp.addBodyPart((BodyPart)bp);
        bp = new MimeBodyPart();
        message2 = new MimeMessage(Session.getDefaultInstance((Properties)new Properties()));
        bp.setContent((Object)message2, "message/rfc822");
        mp.addBodyPart((BodyPart)bp);
        MimeMultipart mpext = new MimeMultipart();
        bp = new MimeBodyPart();
        bp.setContent((Multipart)mp);
        mpext.addBodyPart((BodyPart)bp);
        message.setContent((Multipart)mpext);
        message.saveChanges();
        mail = FakeMail.builder().name("mail").mimeMessage(message).build();
        mailet.service((Mail)mail);
        Assertions.assertThat((String)mail.getMessage().getSubject()).isEqualTo("prova");
        Assertions.assertThat((Object)mail.getMessage().getContent()).isEqualTo((Object)"Questo \u00e8 un part interno1");
        message = new MimeMessage(Session.getDefaultInstance((Properties)new Properties()));
        message.setSubject("prova");
        message.setContent((Object)"<p>Questa \u00e8 una prova<br />di html</p>", "text/html");
        message.saveChanges();
        mail = FakeMail.builder().name("mail").mimeMessage(message).build();
        mailet.service((Mail)mail);
        Assertions.assertThat((String)mail.getMessage().getSubject()).isEqualTo("prova");
        Assertions.assertThat((Object)mail.getMessage().getContent()).isEqualTo((Object)"Questa \u00e8 una prova\ndi html\n");
        Assertions.assertThat((boolean)mail.getMessage().isMimeType("text/plain")).isTrue();
        message = new MimeMessage(Session.getDefaultInstance((Properties)new Properties()));
        message.setSubject("prova");
        mp = new MimeMultipart();
        bp = new MimeBodyPart();
        message2 = new MimeMessage(Session.getDefaultInstance((Properties)new Properties()));
        bp.setContent((Object)message2, "message/rfc822");
        mp.addBodyPart((BodyPart)bp);
        bp = new MimeBodyPart();
        bp.setContent((Object)"<p>Questa \u00e8 una prova<br />di html</p>", "text/html");
        mp.addBodyPart((BodyPart)bp);
        message.setContent((Multipart)mp);
        message.saveChanges();
        mail = FakeMail.builder().name("mail").mimeMessage(message).build();
        mailet.service((Mail)mail);
        Assertions.assertThat((String)mail.getMessage().getSubject()).isEqualTo("prova");
        Assertions.assertThat((Object)mail.getMessage().getContent()).isEqualTo((Object)"Questa \u00e8 una prova\ndi html\n");
        Assertions.assertThat((boolean)mail.getMessage().isMimeType("text/plain")).isTrue();
    }

    @Test
    void testHtml2Text() throws MessagingException {
        OnlyText mailet = new OnlyText();
        mailet.init((MailetConfig)FakeMailetConfig.builder().mailetName("Test").build());
        String html = "<b>Prova di html</b><br /><p>Un paragrafo</p><LI>e ci mettiamo anche una lista</LI><br>";
        Assertions.assertThat((String)mailet.html2Text(html)).isEqualTo("Prova di html\nUn paragrafo\n\n* e ci mettiamo anche una lista\n");
        html = "<b>Vediamo invece come andiamo con gli entities</b><br />&egrave;&agrave; &amp;grave;<br>";
        Assertions.assertThat((String)mailet.html2Text(html)).isEqualTo("Vediamo invece come andiamo con gli entities\n\u00e8\u00e0 &grave;\n");
    }
}

