/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.transport.mailets;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import javax.mail.MessagingException;
import org.apache.james.transport.mailets.MimeDecodingMailet;
import org.apache.mailet.Attribute;
import org.apache.mailet.AttributeName;
import org.apache.mailet.AttributeUtils;
import org.apache.mailet.AttributeValue;
import org.apache.mailet.Mail;
import org.apache.mailet.MailetConfig;
import org.apache.mailet.MailetContext;
import org.apache.mailet.MailetException;
import org.apache.mailet.base.test.FakeMail;
import org.apache.mailet.base.test.FakeMailContext;
import org.apache.mailet.base.test.FakeMailetConfig;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.slf4j.Logger;

class MimeDecodingMailetTest {
    private static final AttributeName MAIL_ATTRIBUTE = AttributeName.of((String)"mime.attachments");
    private static final Class<Map<String, AttributeValue<byte[]>>> MAP_STRING_BYTES_CLASS = Map.class;
    private MailetContext mailetContext;
    private MimeDecodingMailet testee;

    MimeDecodingMailetTest() {
    }

    @BeforeEach
    void setUp() {
        this.testee = new MimeDecodingMailet();
        Logger logger = (Logger)Mockito.mock(Logger.class);
        this.mailetContext = FakeMailContext.builder().logger(logger).build();
    }

    @Test
    void initShouldThrowWhenNoAttributeParameter() {
        FakeMailetConfig mailetConfig = FakeMailetConfig.builder().mailetName("Test").mailetContext(this.mailetContext).build();
        Assertions.assertThatThrownBy(() -> this.testee.init((MailetConfig)mailetConfig)).isInstanceOf(MailetException.class);
    }

    @Test
    void initShouldThrowWhenAttributeParameterIsEmpty() {
        FakeMailetConfig mailetConfig = FakeMailetConfig.builder().mailetName("Test").mailetContext(this.mailetContext).setProperty("attribute", "").build();
        Assertions.assertThatThrownBy(() -> this.testee.init((MailetConfig)mailetConfig)).isInstanceOf(MailetException.class);
    }

    @Test
    void serviceShouldNotThrowWhenAttributeContentIsNotAMap() throws MessagingException {
        FakeMailetConfig mailetConfig = FakeMailetConfig.builder().mailetName("Test").mailetContext(this.mailetContext).setProperty("attribute", MAIL_ATTRIBUTE.asString()).build();
        this.testee.init((MailetConfig)mailetConfig);
        FakeMail mail = FakeMail.defaultFakeMail();
        mail.setAttribute(new Attribute(MAIL_ATTRIBUTE, AttributeValue.of((Collection)ImmutableList.of())));
        this.testee.service((Mail)mail);
    }

    @Test
    void serviceShouldNotThrowWhenAttributeContentIsAMapOfWrongTypes() throws MessagingException {
        FakeMailetConfig mailetConfig = FakeMailetConfig.builder().mailetName("Test").mailetContext(this.mailetContext).setProperty("attribute", MAIL_ATTRIBUTE.asString()).build();
        this.testee.init((MailetConfig)mailetConfig);
        FakeMail mail = FakeMail.defaultFakeMail();
        AttributeValue value = AttributeValue.of((Map)ImmutableMap.of((Object)"1", (Object)AttributeValue.of((String)"2")));
        mail.setAttribute(new Attribute(MAIL_ATTRIBUTE, value));
        this.testee.service((Mail)mail);
    }

    @Test
    void serviceShouldNotSetAttributeWhenNone() throws MessagingException {
        FakeMailetConfig mailetConfig = FakeMailetConfig.builder().mailetName("Test").mailetContext(this.mailetContext).setProperty("attribute", MAIL_ATTRIBUTE.asString()).build();
        this.testee.init((MailetConfig)mailetConfig);
        FakeMail mail = FakeMail.defaultFakeMail();
        this.testee.service((Mail)mail);
        Assertions.assertThat((Optional)mail.getAttribute(MAIL_ATTRIBUTE)).isEmpty();
    }

    @Test
    void serviceShouldChangeAttributeWhenDefined() throws MessagingException {
        FakeMailetConfig mailetConfig = FakeMailetConfig.builder().mailetName("Test").mailetContext(this.mailetContext).setProperty("attribute", MAIL_ATTRIBUTE.asString()).build();
        this.testee.init((MailetConfig)mailetConfig);
        FakeMail mail = FakeMail.defaultFakeMail();
        String text = "Attachment content";
        String content = "Content-Transfer-Encoding: 8bit\r\nContent-Type: application/octet-stream; charset=utf-8\r\n\r\n" + text;
        String expectedKey = "mimePart1";
        AttributeValue value = AttributeValue.of((Map)ImmutableMap.of((Object)expectedKey, (Object)AttributeValue.of((byte[])content.getBytes(StandardCharsets.UTF_8))));
        mail.setAttribute(new Attribute(MAIL_ATTRIBUTE, value));
        AttributeValue expectedValue = AttributeValue.of((byte[])text.getBytes(StandardCharsets.UTF_8));
        this.testee.service((Mail)mail);
        Optional processedAttribute = AttributeUtils.getValueAndCastFromMail((Mail)mail, (AttributeName)MAIL_ATTRIBUTE, MAP_STRING_BYTES_CLASS);
        Assertions.assertThat((Optional)processedAttribute).hasValueSatisfying(map -> Assertions.assertThat((byte[])((byte[])((AttributeValue)map.values().stream().findFirst().get()).getValue())).contains((byte[])expectedValue.value()));
    }
}

