/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.transport.mailets;

import java.util.Map;
import javax.mail.MessagingException;
import org.apache.james.transport.mailets.MappingArgument;
import org.assertj.core.api.Assertions;
import org.assertj.core.data.MapEntry;
import org.junit.jupiter.api.Test;

class MappingArgumentTest {
    MappingArgumentTest() {
    }

    @Test
    void parseShouldFailIfCalledWithNull() {
        Assertions.assertThatThrownBy(() -> MappingArgument.parse(null)).isInstanceOf(IllegalArgumentException.class);
    }

    @Test
    void parseShouldFailIfCalledWhenMissingMappingParts() {
        Assertions.assertThatThrownBy(() -> MappingArgument.parse((String)"key1;value1,key2")).isInstanceOf(IllegalArgumentException.class);
    }

    @Test
    void parseShouldFailIfCalledWhenExtraMappingParts() {
        Assertions.assertThatThrownBy(() -> MappingArgument.parse((String)"key1;value1,key2;value1;value3")).isInstanceOf(IllegalArgumentException.class);
    }

    @Test
    void parseShouldWorkForEmptyMapping() throws MessagingException {
        Assertions.assertThat((Map)MappingArgument.parse((String)"")).isEmpty();
    }

    @Test
    void parseShouldWorkForEmptyMappingWithSpace() throws MessagingException {
        Assertions.assertThat((Map)MappingArgument.parse((String)"  ")).isEmpty();
    }

    @Test
    void parseShouldWorkForValidParsingWithOnlyOneKey() throws MessagingException {
        Assertions.assertThat((Map)MappingArgument.parse((String)"key1;value1")).containsExactly(new Map.Entry[]{MapEntry.entry((Object)"key1", (Object)"value1")});
    }

    @Test
    void parseShouldWorkForValidParsingWithMoreThanOneKey() throws MessagingException {
        Assertions.assertThat((Map)MappingArgument.parse((String)"key1;value1,key2;value2")).containsExactly(new Map.Entry[]{MapEntry.entry((Object)"key1", (Object)"value1"), MapEntry.entry((Object)"key2", (Object)"value2")});
    }

    @Test
    void parserShouldTrimSpacesAroundSemiColon() throws MessagingException {
        Assertions.assertThat((Map)MappingArgument.parse((String)"key1;    value1")).containsExactly(new Map.Entry[]{MapEntry.entry((Object)"key1", (Object)"value1")});
    }

    @Test
    void parserShouldTrimSpacesAroundComa() throws MessagingException {
        Assertions.assertThat((Map)MappingArgument.parse((String)"key1;value1,  key2;value2")).containsExactly(new Map.Entry[]{MapEntry.entry((Object)"key1", (Object)"value1"), MapEntry.entry((Object)"key2", (Object)"value2")});
    }

    @Test
    void parserShouldNotFailWhenExtraComa() throws MessagingException {
        Assertions.assertThat((Map)MappingArgument.parse((String)"key1;value1,")).containsExactly(new Map.Entry[]{MapEntry.entry((Object)"key1", (Object)"value1")});
    }
}

