/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.transport.mailets;

import javax.mail.MessagingException;
import javax.mail.internet.MimeMessage;
import org.apache.james.core.builder.MimeMessageBuilder;
import org.apache.james.transport.mailets.MailAttributesToMimeHeaders;
import org.apache.mailet.Attribute;
import org.apache.mailet.AttributeName;
import org.apache.mailet.AttributeValue;
import org.apache.mailet.Mail;
import org.apache.mailet.Mailet;
import org.apache.mailet.MailetConfig;
import org.apache.mailet.base.test.FakeMail;
import org.apache.mailet.base.test.FakeMailetConfig;
import org.apache.mailet.base.test.MailUtil;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

class MailAttributesToMimeHeadersTest {
    private Mailet mailet;
    private static final String HEADER_NAME1 = "JUNIT";
    private static final String HEADER_NAME2 = "JUNIT2";
    private static final AttributeName MAIL_ATTRIBUTE_NAME1 = AttributeName.of((String)"org.apache.james.test");
    private static final AttributeValue<String> MAIL_ATTRIBUTE_VALUE1 = AttributeValue.of((String)"test1");
    private static final Attribute MAIL_ATTRIBUTE1 = new Attribute(MAIL_ATTRIBUTE_NAME1, MAIL_ATTRIBUTE_VALUE1);
    private static final AttributeName MAIL_ATTRIBUTE_NAME2 = AttributeName.of((String)"org.apache.james.test2");
    private static final AttributeValue<String> MAIL_ATTRIBUTE_VALUE2 = AttributeValue.of((String)"test2");
    private static final Attribute MAIL_ATTRIBUTE2 = new Attribute(MAIL_ATTRIBUTE_NAME2, MAIL_ATTRIBUTE_VALUE2);

    MailAttributesToMimeHeadersTest() {
    }

    @BeforeEach
    void setup() {
        this.mailet = new MailAttributesToMimeHeaders();
    }

    @Test
    void shouldThrowMessagingExceptionIfMappingIsNotGiven() {
        FakeMailetConfig mailetConfig = FakeMailetConfig.builder().mailetName("Test").build();
        Assertions.assertThatThrownBy(() -> this.mailet.init((MailetConfig)mailetConfig)).isInstanceOf(MessagingException.class);
    }

    @Test
    void shouldThrowMessagingExceptionIfMappingIsEmpty() {
        FakeMailetConfig mailetConfig = FakeMailetConfig.builder().mailetName("Test").setProperty("simplemmapping", "").build();
        Assertions.assertThatThrownBy(() -> this.mailet.init((MailetConfig)mailetConfig)).isInstanceOf(MessagingException.class);
    }

    @Test
    void shouldIgnoreAttributeOfMappingThatDoesNotExistOnTheMessage() throws MessagingException {
        FakeMailetConfig mailetConfig = FakeMailetConfig.builder().mailetName("Test").setProperty("simplemapping", MAIL_ATTRIBUTE_NAME1.asString() + "; JUNIT," + MAIL_ATTRIBUTE_NAME2.asString() + "; JUNIT2,another.attribute; Another-Header").build();
        this.mailet.init((MailetConfig)mailetConfig);
        FakeMail mockedMail = MailUtil.createMockMail2Recipients((MimeMessage)MailUtil.createMimeMessage());
        mockedMail.setAttribute(MAIL_ATTRIBUTE1);
        mockedMail.setAttribute(MAIL_ATTRIBUTE2);
        this.mailet.service((Mail)mockedMail);
        Assertions.assertThat((Object[])mockedMail.getMessage().getHeader("another.attribute")).isNull();
    }

    @Test
    void shouldWorkWithMappingWithASingleBinding() throws MessagingException {
        FakeMailetConfig mailetConfig = FakeMailetConfig.builder().mailetName("Test").setProperty("simplemapping", MAIL_ATTRIBUTE_NAME1.asString() + "; JUNIT").build();
        this.mailet.init((MailetConfig)mailetConfig);
        FakeMail mockedMail = MailUtil.createMockMail2Recipients((MimeMessage)MailUtil.createMimeMessage());
        mockedMail.setAttribute(MAIL_ATTRIBUTE1);
        this.mailet.service((Mail)mockedMail);
        Assertions.assertThat((Object[])mockedMail.getMessage().getHeader(HEADER_NAME1)).containsExactly((Object[])new String[]{(String)MAIL_ATTRIBUTE_VALUE1.value()});
    }

    @Test
    void shouldPutAttributesIntoHeadersWhenMappingDefined() throws MessagingException {
        FakeMailetConfig mailetConfig = FakeMailetConfig.builder().mailetName("Test").setProperty("simplemapping", MAIL_ATTRIBUTE_NAME1.asString() + "; JUNIT," + MAIL_ATTRIBUTE_NAME2.asString() + "; JUNIT2,another.attribute; Another-Header").build();
        this.mailet.init((MailetConfig)mailetConfig);
        FakeMail mockedMail = MailUtil.createMockMail2Recipients((MimeMessage)MailUtil.createMimeMessage());
        mockedMail.setAttribute(MAIL_ATTRIBUTE1);
        mockedMail.setAttribute(MAIL_ATTRIBUTE2);
        mockedMail.setAttribute(Attribute.convertToAttribute((String)"unmatched.attribute", (Object)"value"));
        this.mailet.service((Mail)mockedMail);
        Assertions.assertThat((Object[])mockedMail.getMessage().getHeader(HEADER_NAME1)).containsExactly((Object[])new String[]{(String)MAIL_ATTRIBUTE_VALUE1.value()});
        Assertions.assertThat((Object[])mockedMail.getMessage().getHeader(HEADER_NAME2)).containsExactly((Object[])new String[]{(String)MAIL_ATTRIBUTE_VALUE2.value()});
    }

    @Test
    void shouldAddAttributeIntoHeadersWhenHeaderAlreadyPresent() throws MessagingException {
        FakeMailetConfig mailetConfig = FakeMailetConfig.builder().mailetName("Test").setProperty("simplemapping", MAIL_ATTRIBUTE_NAME1.asString() + "; JUNIT").build();
        this.mailet.init((MailetConfig)mailetConfig);
        FakeMail mockedMail = MailUtil.createMockMail2Recipients((MimeMessage)MimeMessageBuilder.mimeMessageBuilder().addHeader(HEADER_NAME1, "first value").build());
        mockedMail.setAttribute(MAIL_ATTRIBUTE1);
        this.mailet.service((Mail)mockedMail);
        Assertions.assertThat((Object[])mockedMail.getMessage().getHeader(HEADER_NAME1)).containsExactly((Object[])new String[]{"first value", (String)MAIL_ATTRIBUTE_VALUE1.value()});
    }

    @Test
    void shouldThrowAtInitWhenNoSemicolumnInConfigurationEntry() {
        FakeMailetConfig mailetConfig = FakeMailetConfig.builder().mailetName("Test").setProperty("simplemapping", "invalidConfigEntry").build();
        Assertions.assertThatThrownBy(() -> this.mailet.init((MailetConfig)mailetConfig)).isInstanceOf(IllegalArgumentException.class);
    }

    @Test
    void shouldThrowAtInitWhenTwoSemicolumnsInConfigurationEntry() {
        FakeMailetConfig mailetConfig = FakeMailetConfig.builder().mailetName("Test").setProperty("simplemapping", "first;second;third").build();
        Assertions.assertThatThrownBy(() -> this.mailet.init((MailetConfig)mailetConfig)).isInstanceOf(IllegalArgumentException.class);
    }

    @Test
    void shouldThrowAtInitWhenNoConfigurationEntry() {
        FakeMailetConfig mailetConfig = FakeMailetConfig.builder().mailetName("Test").build();
        Assertions.assertThatThrownBy(() -> this.mailet.init((MailetConfig)mailetConfig)).isInstanceOf(MessagingException.class);
    }
}

