/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.transport.mailets;

import com.google.common.collect.ImmutableList;
import javax.mail.MessagingException;
import org.apache.james.core.builder.MimeMessageBuilder;
import org.apache.james.transport.mailets.MailAttributesListToMimeHeaders;
import org.apache.mailet.Attribute;
import org.apache.mailet.AttributeValue;
import org.apache.mailet.Mail;
import org.apache.mailet.Mailet;
import org.apache.mailet.MailetConfig;
import org.apache.mailet.base.test.FakeMail;
import org.apache.mailet.base.test.FakeMailetConfig;
import org.apache.mailet.base.test.MailUtil;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

class MailAttributesListToMimeHeadersTest {
    private static final String VALUE_1_1 = "test1.1";
    private static final String VALUE_1_2 = "test1.2";
    private static final String VALUE_2_1 = "test2.1";
    private static final String VALUE_2_2 = "test2.2";
    private static final ImmutableList<AttributeValue<String>> MAIL_ATTRIBUTE_VALUE1 = ImmutableList.of((Object)AttributeValue.of((String)"test1.1"), (Object)AttributeValue.of((String)"test1.2"));
    private static final ImmutableList<AttributeValue<String>> MAIL_ATTRIBUTE_VALUE2 = ImmutableList.of((Object)AttributeValue.of((String)"test2.1"), (Object)AttributeValue.of((String)"test2.2"));
    private static final String MAIL_ATTRIBUTE_NAME1 = "org.apache.james.test";
    private static final String MAIL_ATTRIBUTE_NAME2 = "org.apache.james.test2";
    private static final String HEADER_NAME1 = "JUNIT";
    private static final String HEADER_NAME2 = "JUNIT2";
    private static final Attribute MAIL_ATTRIBUTE1 = Attribute.convertToAttribute((String)"org.apache.james.test", MAIL_ATTRIBUTE_VALUE1);
    private static final Attribute MAIL_ATTRIBUTE2 = Attribute.convertToAttribute((String)"org.apache.james.test2", MAIL_ATTRIBUTE_VALUE2);
    private Mailet mailet;

    MailAttributesListToMimeHeadersTest() {
    }

    @BeforeEach
    void setup() {
        this.mailet = new MailAttributesListToMimeHeaders();
    }

    @Test
    void shouldThrowMessagingExceptionIfMappingIsNotGiven() {
        FakeMailetConfig mailetConfig = FakeMailetConfig.builder().mailetName("Test").build();
        Assertions.assertThatThrownBy(() -> this.mailet.init((MailetConfig)mailetConfig)).isInstanceOf(MessagingException.class);
    }

    @Test
    void shouldThrowMessagingExceptionIfMappingIsEmpty() {
        FakeMailetConfig mailetConfig = FakeMailetConfig.builder().mailetName("Test").setProperty("simplemmapping", "").build();
        Assertions.assertThatThrownBy(() -> this.mailet.init((MailetConfig)mailetConfig)).isInstanceOf(MessagingException.class);
    }

    @Test
    void shouldIgnoreAttributeOfMappingThatDoesNotExistOnTheMessage() throws MessagingException {
        FakeMailetConfig mailetConfig = FakeMailetConfig.builder().mailetName("Test").setProperty("simplemapping", "org.apache.james.test; JUNIT,org.apache.james.test2; JUNIT2,another.attribute; Another-Header").build();
        this.mailet.init((MailetConfig)mailetConfig);
        FakeMail mail = FakeMail.builder().name("mail").mimeMessage(MailUtil.createMimeMessage()).attribute(MAIL_ATTRIBUTE1).attribute(MAIL_ATTRIBUTE2).build();
        this.mailet.service((Mail)mail);
        Assertions.assertThat((Object[])mail.getMessage().getHeader("another.attribute")).isNull();
    }

    @Test
    void shouldWorkWithMappingWithASingleBinding() throws MessagingException {
        FakeMailetConfig mailetConfig = FakeMailetConfig.builder().mailetName("Test").setProperty("simplemapping", "org.apache.james.test; JUNIT").build();
        this.mailet.init((MailetConfig)mailetConfig);
        FakeMail mail = FakeMail.builder().name("mail").mimeMessage(MailUtil.createMimeMessage()).attribute(MAIL_ATTRIBUTE1).build();
        this.mailet.service((Mail)mail);
        Assertions.assertThat((Object[])mail.getMessage().getHeader(HEADER_NAME1)).containsExactly((Object[])new String[]{VALUE_1_1, VALUE_1_2});
    }

    @Test
    void shouldPutAttributesIntoHeadersWhenMappingDefined() throws MessagingException {
        FakeMailetConfig mailetConfig = FakeMailetConfig.builder().mailetName("Test").setProperty("simplemapping", "org.apache.james.test; JUNIT,org.apache.james.test2; JUNIT2,another.attribute; Another-Header").build();
        this.mailet.init((MailetConfig)mailetConfig);
        FakeMail mail = FakeMail.builder().name("mail").mimeMessage(MailUtil.createMimeMessage()).attribute(MAIL_ATTRIBUTE1).attribute(MAIL_ATTRIBUTE2).attribute(Attribute.convertToAttribute((String)"unmatched.attribute", (Object)"value")).build();
        this.mailet.service((Mail)mail);
        Assertions.assertThat((Object[])mail.getMessage().getHeader(HEADER_NAME1)).containsExactlyElementsOf((Iterable)MAIL_ATTRIBUTE_VALUE1.stream().map(AttributeValue::getValue).collect(ImmutableList.toImmutableList()));
        Assertions.assertThat((Object[])mail.getMessage().getHeader(HEADER_NAME2)).containsExactlyElementsOf((Iterable)MAIL_ATTRIBUTE_VALUE2.stream().map(AttributeValue::getValue).collect(ImmutableList.toImmutableList()));
    }

    @Test
    void shouldNotRemovePreviousAttributeValueWhenAttributeAlreadyPresent() throws MessagingException {
        FakeMailetConfig mailetConfig = FakeMailetConfig.builder().mailetName("Test").setProperty("simplemapping", "org.apache.james.test; JUNIT").build();
        this.mailet.init((MailetConfig)mailetConfig);
        String firstValue = "first value";
        FakeMail mail = FakeMail.builder().name("mail").mimeMessage(MimeMessageBuilder.mimeMessageBuilder().addHeader(HEADER_NAME1, firstValue)).attribute(MAIL_ATTRIBUTE1).build();
        this.mailet.service((Mail)mail);
        Assertions.assertThat((Object[])mail.getMessage().getHeader(HEADER_NAME1)).containsOnly((Object[])new String[]{VALUE_1_1, VALUE_1_2, firstValue});
    }

    @Test
    void shouldFilterAttributeOfWrongClass() throws MessagingException {
        FakeMailetConfig mailetConfig = FakeMailetConfig.builder().mailetName("Test").setProperty("simplemapping", "org.apache.james.test; JUNIT,org.apache.james.test2; JUNIT2").build();
        this.mailet.init((MailetConfig)mailetConfig);
        FakeMail mail = FakeMail.builder().name("mail").mimeMessage(MimeMessageBuilder.mimeMessageBuilder()).attribute(Attribute.convertToAttribute((String)MAIL_ATTRIBUTE_NAME1, (Object)3L)).attribute(MAIL_ATTRIBUTE2).build();
        this.mailet.service((Mail)mail);
        Assertions.assertThat((Object[])mail.getMessage().getHeader(HEADER_NAME1)).isNull();
        Assertions.assertThat((Object[])mail.getMessage().getHeader(HEADER_NAME2)).containsExactlyElementsOf((Iterable)MAIL_ATTRIBUTE_VALUE2.stream().map(AttributeValue::getValue).collect(ImmutableList.toImmutableList()));
    }

    @Test
    void shouldFilterAttributeElementsOfWrongClass() throws MessagingException {
        FakeMailetConfig mailetConfig = FakeMailetConfig.builder().mailetName("Test").setProperty("simplemapping", "org.apache.james.test; JUNIT").build();
        this.mailet.init((MailetConfig)mailetConfig);
        String value = "value";
        FakeMail mail = FakeMail.builder().name("mail").mimeMessage(MimeMessageBuilder.mimeMessageBuilder()).attribute(Attribute.convertToAttribute((String)MAIL_ATTRIBUTE_NAME1, (Object)ImmutableList.of((Object)AttributeValue.of((Long)3L), (Object)AttributeValue.of((String)value)))).build();
        this.mailet.service((Mail)mail);
        Assertions.assertThat((Object[])mail.getMessage().getHeader(HEADER_NAME1)).containsOnly((Object[])new String[]{value});
    }

    @Test
    void shouldThrowAtInitWhenNoSemicolumnInConfigurationEntry() {
        FakeMailetConfig mailetConfig = FakeMailetConfig.builder().mailetName("Test").setProperty("simplemapping", "invalidConfigEntry").build();
        Assertions.assertThatThrownBy(() -> this.mailet.init((MailetConfig)mailetConfig)).isInstanceOf(IllegalArgumentException.class);
    }

    @Test
    void shouldThrowAtInitWhenTwoSemicolumnsInConfigurationEntry() {
        FakeMailetConfig mailetConfig = FakeMailetConfig.builder().mailetName("Test").setProperty("simplemapping", "first;second;third").build();
        Assertions.assertThatThrownBy(() -> this.mailet.init((MailetConfig)mailetConfig)).isInstanceOf(IllegalArgumentException.class);
    }

    @Test
    void shouldThrowAtInitWhenNoConfigurationEntry() {
        FakeMailetConfig mailetConfig = FakeMailetConfig.builder().mailetName("Test").build();
        Assertions.assertThatThrownBy(() -> this.mailet.init((MailetConfig)mailetConfig)).isInstanceOf(MessagingException.class);
    }
}

