/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.transport.mailets;

import javax.mail.MessagingException;
import javax.mail.internet.MimeMessage;
import org.apache.james.core.builder.MimeMessageBuilder;
import org.apache.james.transport.mailets.LogMessage;
import org.apache.james.util.MimeMessageUtil;
import org.apache.mailet.Mail;
import org.apache.mailet.MailetConfig;
import org.apache.mailet.MailetContext;
import org.apache.mailet.base.test.FakeMail;
import org.apache.mailet.base.test.FakeMailContext;
import org.apache.mailet.base.test.FakeMailetConfig;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.slf4j.Logger;

class LogMessageTest {
    private LogMessage mailet;
    private FakeMailContext mailContext;
    private Logger logger;

    LogMessageTest() {
    }

    @BeforeEach
    void setup() {
        this.logger = (Logger)Mockito.mock(Logger.class);
        Mockito.when((Object)this.logger.isInfoEnabled()).thenReturn((Object)true);
        this.mailContext = FakeMailContext.builder().logger(this.logger).build();
        this.mailet = new LogMessage(this.logger);
    }

    @Test
    void getMailetInfoShouldReturnValue() {
        Assertions.assertThat((String)this.mailet.getMailetInfo()).isEqualTo("LogHeaders Mailet");
    }

    @Test
    void initShouldIgnoreExceptions() throws Exception {
        FakeMailetConfig mailetConfig = FakeMailetConfig.builder().mailetName("LogContext").mailetContext((MailetContext)this.mailContext).setProperty("maxBody", "comment").build();
        this.mailet.init((MailetConfig)mailetConfig);
    }

    @Test
    public void serviceShouldNotFailWhenTextContent() throws Exception {
        FakeMailetConfig mailetConfig = FakeMailetConfig.builder().mailetName("LogContext").mailetContext((MailetContext)this.mailContext).build();
        this.mailet.init((MailetConfig)mailetConfig);
        this.mailet.service((Mail)FakeMail.builder().name("mail").mimeMessage(MimeMessageBuilder.mimeMessageBuilder().addHeader("Date", "Tue, 16 Jan 2018 10:23:03 +0100").setSubject("subject").setText("This is a fake mail")).build());
        ((Logger)Mockito.verify((Object)this.logger, (VerificationMode)Mockito.times((int)0))).error(ArgumentMatchers.anyString(), (Throwable)ArgumentMatchers.any(MessagingException.class));
    }

    @Test
    void serviceShouldLog() throws Exception {
        FakeMailetConfig mailetConfig = FakeMailetConfig.builder().mailetName("LogContext").mailetContext((MailetContext)this.mailContext).build();
        this.mailet.init((MailetConfig)mailetConfig);
        this.mailet.service((Mail)this.createMail());
        ((Logger)Mockito.verify((Object)this.logger)).info("Logging mail {}", (Object)"name");
        ((Logger)Mockito.verify((Object)this.logger, (VerificationMode)Mockito.times((int)2))).isInfoEnabled();
        ((Logger)Mockito.verify((Object)this.logger)).info("\n");
        ((Logger)Mockito.verify((Object)this.logger)).info("Subject: subject\n");
        ((Logger)Mockito.verify((Object)this.logger)).info("Content-Type: text/plain\n");
        ((Logger)Mockito.verify((Object)this.logger)).info("This is a fake mail");
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.logger});
    }

    @Test
    void serviceShouldLogWhenExceptionOccured() throws Exception {
        FakeMailetConfig mailetConfig = FakeMailetConfig.builder().mailetName("LogContext").mailetContext((MailetContext)this.mailContext).build();
        this.mailet.init((MailetConfig)mailetConfig);
        Mail mail = (Mail)Mockito.mock(Mail.class);
        Mockito.when((Object)mail.getName()).thenReturn((Object)"name");
        MessagingException messagingException = new MessagingException("exception message");
        Mockito.when((Object)mail.getMessage()).thenThrow(new Throwable[]{messagingException});
        this.mailet.service(mail);
        ((Logger)Mockito.verify((Object)this.logger)).info("Logging mail {}", (Object)"name");
        ((Logger)Mockito.verify((Object)this.logger)).error("Error logging message.", (Throwable)messagingException);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.logger});
    }

    @Test
    void serviceShouldSetTheMailStateWhenPassThroughIsFalse() throws Exception {
        FakeMailetConfig mailetConfig = FakeMailetConfig.builder().mailetName("LogContext").mailetContext((MailetContext)this.mailContext).setProperty("passThrough", "false").build();
        this.mailet.init((MailetConfig)mailetConfig);
        FakeMail mail = this.createMail();
        this.mailet.service((Mail)mail);
        Assertions.assertThat((String)mail.getState()).isEqualTo("ghost");
    }

    @Test
    void serviceShouldNotChangeTheMailStateWhenPassThroughIsTrue() throws Exception {
        FakeMailetConfig mailetConfig = FakeMailetConfig.builder().mailetName("LogContext").mailetContext((MailetContext)this.mailContext).setProperty("passThrough", "true").build();
        this.mailet.init((MailetConfig)mailetConfig);
        FakeMail mail = this.createMail();
        String initialState = mail.getState();
        this.mailet.service((Mail)mail);
        Assertions.assertThat((String)mail.getState()).isEqualTo(initialState);
    }

    @Test
    void serviceShouldNotLogHeadersWhenFalse() throws Exception {
        FakeMailetConfig mailetConfig = FakeMailetConfig.builder().mailetName("LogContext").mailetContext((MailetContext)this.mailContext).setProperty("headers", "false").build();
        this.mailet.init((MailetConfig)mailetConfig);
        this.mailet.service((Mail)this.createMail());
        ((Logger)Mockito.verify((Object)this.logger)).info("Logging mail {}", (Object)"name");
        ((Logger)Mockito.verify((Object)this.logger)).isInfoEnabled();
        ((Logger)Mockito.verify((Object)this.logger)).info("This is a fake mail");
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.logger});
    }

    @Test
    void serviceShouldNotLogBodyWhenFalse() throws Exception {
        FakeMailetConfig mailetConfig = FakeMailetConfig.builder().mailetName("LogContext").mailetContext((MailetContext)this.mailContext).setProperty("body", "false").build();
        this.mailet.init((MailetConfig)mailetConfig);
        this.mailet.service((Mail)this.createMail());
        ((Logger)Mockito.verify((Object)this.logger)).info("Logging mail {}", (Object)"name");
        ((Logger)Mockito.verify((Object)this.logger)).isInfoEnabled();
        ((Logger)Mockito.verify((Object)this.logger)).info("\n");
        ((Logger)Mockito.verify((Object)this.logger)).info("Subject: subject\n");
        ((Logger)Mockito.verify((Object)this.logger)).info("Content-Type: text/plain\n");
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.logger});
    }

    @Test
    void serviceShouldNotLogFullBodyWhenBodyMaxIsSet() throws Exception {
        FakeMailetConfig mailetConfig = FakeMailetConfig.builder().mailetName("LogContext").mailetContext((MailetContext)this.mailContext).setProperty("maxBody", "2").build();
        this.mailet.init((MailetConfig)mailetConfig);
        this.mailet.service((Mail)this.createMail());
        ((Logger)Mockito.verify((Object)this.logger)).info("Logging mail {}", (Object)"name");
        ((Logger)Mockito.verify((Object)this.logger, (VerificationMode)Mockito.times((int)2))).isInfoEnabled();
        ((Logger)Mockito.verify((Object)this.logger)).info("\n");
        ((Logger)Mockito.verify((Object)this.logger)).info("Subject: subject\n");
        ((Logger)Mockito.verify((Object)this.logger)).info("Content-Type: text/plain\n");
        ((Logger)Mockito.verify((Object)this.logger)).info("Th");
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.logger});
    }

    @Test
    void serviceShouldLogAdditionalCommentWhenCommentIsSet() throws Exception {
        FakeMailetConfig mailetConfig = FakeMailetConfig.builder().mailetName("LogContext").mailetContext((MailetContext)this.mailContext).setProperty("comment", "comment").build();
        this.mailet.init((MailetConfig)mailetConfig);
        this.mailet.service((Mail)this.createMail());
        ((Logger)Mockito.verify((Object)this.logger)).info("Logging mail {}", (Object)"name");
        ((Logger)Mockito.verify((Object)this.logger)).info("comment");
        ((Logger)Mockito.verify((Object)this.logger, (VerificationMode)Mockito.times((int)2))).isInfoEnabled();
        ((Logger)Mockito.verify((Object)this.logger)).info("\n");
        ((Logger)Mockito.verify((Object)this.logger)).info("Subject: subject\n");
        ((Logger)Mockito.verify((Object)this.logger)).info("Content-Type: text/plain\n");
        ((Logger)Mockito.verify((Object)this.logger)).info("This is a fake mail");
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.logger});
    }

    private FakeMail createMail() throws MessagingException {
        MimeMessage message = MimeMessageUtil.mimeMessageFromString((String)"Subject: subject\r\nContent-Type: text/plain\r\n\r\nThis is a fake mail");
        return FakeMail.builder().name("name").mimeMessage(message).state("root").recipient("receiver@domain.com").sender("sender@any.com").build();
    }
}

