/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.transport.mailets;

import java.io.InputStream;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.mail.MessagingException;
import javax.mail.internet.MimeMessage;
import org.apache.http.ExceptionLogger;
import org.apache.http.HttpEntity;
import org.apache.http.client.utils.URLEncodedUtils;
import org.apache.http.config.SocketConfig;
import org.apache.http.entity.BasicHttpEntity;
import org.apache.http.impl.bootstrap.HttpServer;
import org.apache.http.impl.bootstrap.ServerBootstrap;
import org.apache.http.message.BasicHttpEntityEnclosingRequest;
import org.apache.http.protocol.HttpRequestHandlerMapper;
import org.apache.http.protocol.UriHttpRequestHandlerMapper;
import org.apache.http.util.EntityUtils;
import org.apache.james.transport.mailets.HeadersToHTTP;
import org.apache.james.util.MimeMessageUtil;
import org.apache.mailet.Mail;
import org.apache.mailet.MailetConfig;
import org.apache.mailet.base.test.FakeMailetConfig;
import org.apache.mailet.base.test.MailUtil;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ListAssert;
import org.assertj.core.api.ObjectArrayAssert;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

class HeadersToHTTPTest {
    private static HttpServer server;
    private static UriHttpRequestHandlerMapper mapper;
    private Mail mail;
    private String urlTestPattern;

    HeadersToHTTPTest() {
    }

    @BeforeAll
    static void setupServer() throws Exception {
        mapper = new UriHttpRequestHandlerMapper();
        SocketConfig socketConfig = SocketConfig.custom().setSoTimeout(50000).build();
        server = ServerBootstrap.bootstrap().setListenerPort(0).setSocketConfig(socketConfig).setExceptionLogger(ExceptionLogger.NO_OP).setHandlerMapper((HttpRequestHandlerMapper)mapper).create();
        server.start();
    }

    @AfterAll
    static void shutdown() {
        server.shutdown(5L, TimeUnit.SECONDS);
    }

    @BeforeEach
    void setup() throws Exception {
        this.mail = MailUtil.createMockMail2Recipients((MimeMessage)MimeMessageUtil.mimeMessageFromStream((InputStream)ClassLoader.getSystemResourceAsStream("mime/sendToRemoteHttp.mime")));
    }

    @AfterEach
    void cleanMapper() {
        mapper.unregister(this.urlTestPattern);
    }

    @Test
    void shouldBeFailedWhenServiceNotExists() throws Exception {
        this.urlTestPattern = "/path/to/service/failed";
        FakeMailetConfig mailetConfig = FakeMailetConfig.builder().setProperty("parameterKey", "pKey").setProperty("parameterValue", "pValue").setProperty("url", "http://qwerty.localhost:12345" + this.urlTestPattern).build();
        HeadersToHTTP mailet = new HeadersToHTTP();
        mailet.init((MailetConfig)mailetConfig);
        mailet.service(this.mail);
        ((ObjectArrayAssert)Assertions.assertThat((Object[])this.mail.getMessage().getHeader("X-headerToHTTP")).hasSize(1)).allSatisfy(header -> Assertions.assertThat((String)header).isEqualTo("Failed"));
        ((ObjectArrayAssert)Assertions.assertThat((Object[])this.mail.getMessage().getHeader("X-headerToHTTPFailure")).hasSize(1)).allSatisfy(header -> Assertions.assertThat((String)header).isNotBlank());
    }

    @Test
    void shouldBeSucceededWhenServiceResponseIsOk() throws Exception {
        this.urlTestPattern = "/path/to/service/succeeded";
        FakeMailetConfig mailetConfig = FakeMailetConfig.builder().setProperty("parameterKey", "pKey").setProperty("parameterValue", "pValue").setProperty("url", "http://" + server.getInetAddress().getHostAddress() + ":" + server.getLocalPort() + this.urlTestPattern).build();
        mapper.register(this.urlTestPattern, (request, response, context) -> response.setStatusCode(200));
        HeadersToHTTP mailet = new HeadersToHTTP();
        mailet.init((MailetConfig)mailetConfig);
        mailet.service(this.mail);
        ((ObjectArrayAssert)Assertions.assertThat((Object[])this.mail.getMessage().getHeader("X-headerToHTTP")).hasSize(1)).allSatisfy(header -> Assertions.assertThat((String)header).isEqualTo("Succeeded"));
    }

    @Test
    void serviceShouldNotModifyHeadersContent() throws Exception {
        this.urlTestPattern = "/path/to/service/succeeded";
        FakeMailetConfig mailetConfig = FakeMailetConfig.builder().setProperty("parameterKey", "pKey").setProperty("parameterValue", "pValue").setProperty("url", "http://" + server.getInetAddress().getHostAddress() + ":" + server.getLocalPort() + this.urlTestPattern).build();
        mapper.register(this.urlTestPattern, (request, response, context) -> {
            Assertions.assertThat((String)request.getRequestLine().getMethod()).isEqualTo("POST");
            BasicHttpEntityEnclosingRequest basicRequest = (BasicHttpEntityEnclosingRequest)request;
            BasicHttpEntity entity = (BasicHttpEntity)basicRequest.getEntity();
            try {
                List params = URLEncodedUtils.parse((HttpEntity)entity);
                ((ListAssert)((ListAssert)((ListAssert)((ListAssert)((ListAssert)Assertions.assertThat((List)params).hasSize(5)).anySatisfy(param -> {
                    Assertions.assertThat((String)param.getName()).isEqualTo("pKey");
                    Assertions.assertThat((String)param.getValue()).isEqualTo("pValue");
                })).anySatisfy(param -> {
                    Assertions.assertThat((String)param.getName()).isEqualTo("subject");
                    Assertions.assertThat((String)param.getValue()).isEqualTo("Fwd: Invitation: (Aucun objet) - ven. 20 janv. 2017 14:00 - 15:00 (CET) (aduprat@linagora.com)");
                })).anySatisfy(param -> {
                    Assertions.assertThat((String)param.getName()).isEqualTo("message_id");
                    Assertions.assertThat((String)param.getValue()).isEqualTo("<f18fa52e-2e9d-1125-327d-2100b23f8a6b@linagora.com>");
                })).anySatisfy(param -> {
                    Assertions.assertThat((String)param.getName()).isEqualTo("reply_to");
                    Assertions.assertThat((String)param.getValue()).isEqualTo("[aduprat <duprat@linagora.com>]");
                })).anySatisfy(param -> {
                    Assertions.assertThat((String)param.getName()).isEqualTo("size");
                    Assertions.assertThat((String)param.getValue()).isEqualTo("5242");
                });
            }
            finally {
                EntityUtils.consume((HttpEntity)basicRequest.getEntity());
            }
            response.setStatusCode(200);
        });
        HeadersToHTTP mailet = new HeadersToHTTP();
        mailet.init((MailetConfig)mailetConfig);
        mailet.service(this.mail);
    }

    @Test
    void shouldSetTheMailStateWhenPassThroughIsFalse() throws Exception {
        this.urlTestPattern = "/path/to/service/PassThroughIsFalse";
        FakeMailetConfig mailetConfig = FakeMailetConfig.builder().setProperty("parameterKey", "pKey").setProperty("parameterValue", "pValue").setProperty("url", "http://" + server.getInetAddress().getHostAddress() + ":" + server.getLocalPort() + this.urlTestPattern).setProperty("passThrough", "false").build();
        mapper.register(this.urlTestPattern, (request, response, context) -> response.setStatusCode(200));
        HeadersToHTTP mailet = new HeadersToHTTP();
        mailet.init((MailetConfig)mailetConfig);
        mailet.service(this.mail);
        Assertions.assertThat((Object[])this.mail.getMessage().getHeader("X-headerToHTTP")).isNull();
        Assertions.assertThat((String)this.mail.getState()).isEqualTo("ghost");
    }

    @Test
    void shouldThrowMessagingExceptionWhenInvalidUrl() {
        FakeMailetConfig mailetConfig = FakeMailetConfig.builder().setProperty("parameterKey", "pKey").setProperty("parameterValue", "pValue").setProperty("url", "qwerty://invalid.url").build();
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> new HeadersToHTTP().init((MailetConfig)mailetConfig)).isExactlyInstanceOf(MessagingException.class)).hasMessageContaining("Unable to contruct URL object from url");
    }

    @Test
    void shouldThrowMessagingExceptionWhenUrlIsNull() {
        FakeMailetConfig mailetConfig = FakeMailetConfig.builder().setProperty("parameterKey", "pKey").setProperty("parameterValue", "pValue").build();
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> new HeadersToHTTP().init((MailetConfig)mailetConfig)).isExactlyInstanceOf(MessagingException.class)).hasMessageContaining("Please configure a targetUrl (\"url\")");
    }
}

