/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.transport.mailets;

import com.google.common.collect.ImmutableList;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Optional;
import java.util.regex.Pattern;
import javax.mail.internet.MimeMessage;
import org.apache.james.transport.mailets.ContentReplacer;
import org.apache.james.transport.mailets.ReplaceConfig;
import org.apache.james.transport.mailets.ReplacingPattern;
import org.apache.mailet.Mail;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;

public class ContentReplacerTest {
    @Test
    public void applyPatternsShouldModifyWhenMatching() {
        ContentReplacer testee = new ContentReplacer(false);
        ImmutableList patterns = ImmutableList.of((Object)new ReplacingPattern(Pattern.compile("test"), false, "TEST"), (Object)new ReplacingPattern(Pattern.compile("a"), true, "e"), (Object)new ReplacingPattern(Pattern.compile("o"), false, "o"));
        String value = testee.applyPatterns((List)patterns, "test aa o");
        Assertions.assertThat((String)value).isEqualTo("TEST ee o");
    }

    @Test
    public void applyPatternsShouldNotRepeatWhenNotAskedFor() {
        ContentReplacer testee = new ContentReplacer(false);
        ImmutableList patterns = ImmutableList.of((Object)new ReplacingPattern(Pattern.compile("test"), false, "TEST"));
        String value = testee.applyPatterns((List)patterns, "test test");
        Assertions.assertThat((String)value).isEqualTo("TEST test");
    }

    @Test
    public void applyPatternsShouldRepeatWhenAskedFor() {
        ContentReplacer testee = new ContentReplacer(false);
        ImmutableList patterns = ImmutableList.of((Object)new ReplacingPattern(Pattern.compile("test"), true, "TEST"));
        String value = testee.applyPatterns((List)patterns, "test test");
        Assertions.assertThat((String)value).isEqualTo("TEST TEST");
    }

    @Test
    public void applyPatternShouldModifyWhenMatchingBody() throws Exception {
        ContentReplacer testee = new ContentReplacer(false);
        Mail mail = (Mail)Mockito.mock(Mail.class);
        MimeMessage mimeMessage = (MimeMessage)Mockito.mock(MimeMessage.class);
        Mockito.when((Object)mail.getMessage()).thenReturn((Object)mimeMessage);
        Mockito.when((Object)mimeMessage.getContent()).thenReturn((Object)"test aa o");
        Mockito.when((Object)mimeMessage.getContentType()).thenReturn((Object)"text/plain");
        ImmutableList patterns = ImmutableList.of((Object)new ReplacingPattern(Pattern.compile("test"), false, "TEST"), (Object)new ReplacingPattern(Pattern.compile("a"), true, "e"), (Object)new ReplacingPattern(Pattern.compile("o"), false, "o"));
        ReplaceConfig replaceConfig = ReplaceConfig.builder().addAllBodyReplacingUnits((List)patterns).build();
        testee.replaceMailContentAndSubject(mail, replaceConfig, Optional.of(StandardCharsets.UTF_8));
        ((MimeMessage)Mockito.verify((Object)mimeMessage)).setContent((Object)"TEST ee o", "text/plain; charset=UTF-8");
    }

    @Test
    public void applyPatternShouldModifyWhenMatchingSubject() throws Exception {
        ContentReplacer testee = new ContentReplacer(false);
        Mail mail = (Mail)Mockito.mock(Mail.class);
        MimeMessage mimeMessage = (MimeMessage)Mockito.mock(MimeMessage.class);
        Mockito.when((Object)mail.getMessage()).thenReturn((Object)mimeMessage);
        Mockito.when((Object)mimeMessage.getSubject()).thenReturn((Object)"test aa o");
        Mockito.when((Object)mimeMessage.getContentType()).thenReturn((Object)"text/plain");
        ImmutableList patterns = ImmutableList.of((Object)new ReplacingPattern(Pattern.compile("test"), false, "TEST"), (Object)new ReplacingPattern(Pattern.compile("a"), true, "e"), (Object)new ReplacingPattern(Pattern.compile("o"), false, "o"));
        ReplaceConfig replaceConfig = ReplaceConfig.builder().addAllSubjectReplacingUnits((List)patterns).build();
        testee.replaceMailContentAndSubject(mail, replaceConfig, Optional.of(StandardCharsets.UTF_8));
        ((MimeMessage)Mockito.verify((Object)mimeMessage)).setSubject("TEST ee o", StandardCharsets.UTF_8.name());
    }

    @Test
    public void applyPatternShouldKeepPreviousCharsetWhenNoneSet() throws Exception {
        ContentReplacer testee = new ContentReplacer(false);
        Mail mail = (Mail)Mockito.mock(Mail.class);
        MimeMessage mimeMessage = (MimeMessage)Mockito.mock(MimeMessage.class);
        Mockito.when((Object)mail.getMessage()).thenReturn((Object)mimeMessage);
        Mockito.when((Object)mimeMessage.getSubject()).thenReturn((Object)"test aa o");
        Mockito.when((Object)mimeMessage.getContentType()).thenReturn((Object)"text/plain; charset= UTF-8");
        ImmutableList patterns = ImmutableList.of((Object)new ReplacingPattern(Pattern.compile("test"), false, "TEST"), (Object)new ReplacingPattern(Pattern.compile("a"), true, "e"), (Object)new ReplacingPattern(Pattern.compile("o"), false, "o"));
        ReplaceConfig replaceConfig = ReplaceConfig.builder().addAllSubjectReplacingUnits((List)patterns).build();
        testee.replaceMailContentAndSubject(mail, replaceConfig, Optional.empty());
        ((MimeMessage)Mockito.verify((Object)mimeMessage)).setSubject("TEST ee o", StandardCharsets.UTF_8.name());
    }
}

