/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.transport.mailets;

import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Optional;
import javax.mail.MessagingException;
import javax.mail.internet.MimeMessage;
import net.javacrumbs.jsonunit.assertj.JsonAssertions;
import org.apache.james.core.builder.MimeMessageBuilder;
import org.apache.james.transport.mailets.ContactExtractor;
import org.apache.james.util.MimeMessageUtil;
import org.apache.mailet.AttributeName;
import org.apache.mailet.Mail;
import org.apache.mailet.MailetConfig;
import org.apache.mailet.MailetContext;
import org.apache.mailet.MailetException;
import org.apache.mailet.base.test.FakeMail;
import org.apache.mailet.base.test.FakeMailContext;
import org.apache.mailet.base.test.FakeMailetConfig;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;

public class ContactExtractorTest {
    private static final AttributeName ATTRIBUTE_NAME = AttributeName.of((String)"ExtractedContacts");
    private static final String SENDER = "sender@james.org";
    private static final String TO = "to@james.org";
    private ContactExtractor mailet;
    private MailetContext mailetContext;
    private FakeMailetConfig mailetConfig;

    @BeforeEach
    public void setUp() throws Exception {
        this.mailet = new ContactExtractor();
        this.mailetContext = FakeMailContext.builder().build();
        this.mailetConfig = FakeMailetConfig.builder().mailetName("Test").mailetContext(this.mailetContext).setProperty("attribute", ATTRIBUTE_NAME.asString()).build();
    }

    @Test
    public void initShouldThrowWhenNoAttributeParameter() throws MessagingException {
        FakeMailetConfig customMailetConfig = FakeMailetConfig.builder().mailetName("Test").mailetContext(this.mailetContext).build();
        Assertions.assertThatThrownBy(() -> this.mailet.init((MailetConfig)customMailetConfig)).isInstanceOf(MailetException.class);
    }

    @Test
    public void initShouldNotThrowWithAllParameters() throws MessagingException {
        this.mailet.init((MailetConfig)this.mailetConfig);
    }

    @Test
    public void getMailetInfoShouldReturnInfo() {
        Assertions.assertThat((String)this.mailet.getMailetInfo()).isEqualTo("ContactExtractor Mailet");
    }

    @Test
    public void serviceShouldNotThrowWhenJsonProcessingFails() throws Exception {
        FakeMail mail = FakeMail.builder().name("mail").mimeMessage(MimeMessageUtil.defaultMimeMessage()).sender(SENDER).recipient(TO).build();
        ObjectMapper objectMapper = (ObjectMapper)Mockito.mock(ObjectMapper.class);
        JsonGenerator jsonGenerator = null;
        Mockito.when((Object)objectMapper.writeValueAsString(ArgumentMatchers.any(ContactExtractor.ExtractedContacts.class))).thenThrow(new Throwable[]{new JsonGenerationException("", jsonGenerator)});
        this.mailet.init((MailetConfig)this.mailetConfig);
        this.mailet.objectMapper = objectMapper;
        this.mailet.service((Mail)mail);
    }

    @Test
    public void serviceShouldAddTheAttribute() throws Exception {
        MimeMessageBuilder message = MimeMessageBuilder.mimeMessageBuilder().setSender(SENDER).addToRecipient(TO).setSubject("Contact collection Rocks").setText("This is my email");
        FakeMail mail = FakeMail.builder().name("mail").mimeMessage(message).sender(SENDER).recipient(TO).build();
        this.mailet.init((MailetConfig)this.mailetConfig);
        String expectedMessage = "{\"userEmail\" : \"sender@james.org\", \"emails\" : [ \"to@james.org\" ]}";
        this.mailet.service((Mail)mail);
        Assertions.assertThat((Optional)mail.getAttribute(ATTRIBUTE_NAME)).hasValueSatisfying(json -> JsonAssertions.assertThatJson((Object)json.getValue().value().toString()).isEqualTo((Object)expectedMessage));
    }

    @Test
    public void serviceShouldPreserveRecipientsEmailAddress() throws Exception {
        MimeMessageBuilder message = MimeMessageBuilder.mimeMessageBuilder().setSender(SENDER).addToRecipient("To <to@james.org>").setSubject("Contact collection Rocks").setText("This is my email");
        FakeMail mail = FakeMail.builder().name("mail").mimeMessage(message).sender(SENDER).recipient(TO).build();
        this.mailet.init((MailetConfig)this.mailetConfig);
        String expectedMessage = "{\"userEmail\" : \"sender@james.org\", \"emails\" : [ \"To <to@james.org>\" ]}";
        this.mailet.service((Mail)mail);
        Assertions.assertThat((Optional)mail.getAttribute(ATTRIBUTE_NAME)).hasValueSatisfying(json -> JsonAssertions.assertThatJson((Object)json.getValue().value().toString()).isEqualTo((Object)expectedMessage));
    }

    @Test
    public void serviceShouldUnscrambleRecipients() throws Exception {
        MimeMessageBuilder message = MimeMessageBuilder.mimeMessageBuilder().setSender(SENDER).addToRecipient("=?ISO-8859-1?Q?Beno=EEt_TELLIER?= <tellier@linagora.com>").setSubject("Contact collection Rocks").setText("This is my email");
        FakeMail mail = FakeMail.builder().name("mail").mimeMessage(message).sender(SENDER).recipient(TO).build();
        this.mailet.init((MailetConfig)this.mailetConfig);
        String expectedMessage = "{\"userEmail\" : \"sender@james.org\", \"emails\" : [ \"Beno\u00eet TELLIER <tellier@linagora.com>\" ]}";
        this.mailet.service((Mail)mail);
        Assertions.assertThat((Optional)mail.getAttribute(ATTRIBUTE_NAME)).hasValueSatisfying(json -> JsonAssertions.assertThatJson((Object)json.getValue().value().toString()).isEqualTo((Object)expectedMessage));
    }

    @Test
    public void serviceShouldUnscrambleRecipientsWhenNameContainsSuperiors() throws Exception {
        String rawMessage = "From: sender@example.com\r\nTo: =?UTF-8?Q?recip_>>_Fr=c3=a9d=c3=a9ric_RECIPIENT?= <frecipient@example.com>\r\nSubject: extract this recipient please\r\n\r\nPlease!";
        MimeMessage message = MimeMessageUtil.mimeMessageFromString((String)rawMessage);
        FakeMail mail = FakeMail.builder().name("mail").mimeMessage(message).sender(SENDER).recipient("recipient@example.com").build();
        this.mailet.init((MailetConfig)this.mailetConfig);
        String expectedMessage = "{\"userEmail\" : \"sender@james.org\", \"emails\" : [ \"\\\"recip >> Fr\u00e9d\u00e9ric RECIPIENT\\\" <frecipient@example.com>\" ]}";
        this.mailet.service((Mail)mail);
        Assertions.assertThat((Optional)mail.getAttribute(ATTRIBUTE_NAME)).hasValueSatisfying(json -> JsonAssertions.assertThatJson((Object)json.getValue().value().toString()).isEqualTo((Object)expectedMessage));
    }

    @Test
    public void serviceShouldParseMultipleRecipients() throws Exception {
        String rawMessage = "From: sender@example.com\r\nTo: User 1 <user1@example.com>, =?UTF-8?Q?recip_>>_Fr=c3=a9d=c3=a9ric_RECIPIENT?= <frecipient@example.com>\r\nSubject: extract this recipient please\r\n\r\nPlease!";
        MimeMessage message = MimeMessageUtil.mimeMessageFromString((String)rawMessage);
        FakeMail mail = FakeMail.builder().name("mail").mimeMessage(message).sender(SENDER).recipient("recipient@example.com").build();
        this.mailet.init((MailetConfig)this.mailetConfig);
        String expectedMessage = "{\"userEmail\" : \"sender@james.org\", \"emails\" : [ \"User 1 <user1@example.com>\", \"\\\"recip >> Fr\u00e9d\u00e9ric RECIPIENT\\\" <frecipient@example.com>\" ]}";
        this.mailet.service((Mail)mail);
        Assertions.assertThat((Optional)mail.getAttribute(ATTRIBUTE_NAME)).hasValueSatisfying(json -> JsonAssertions.assertThatJson((Object)json.getValue().value().toString()).isEqualTo((Object)expectedMessage));
    }

    @Test
    public void serviceShouldParseRecipientWithCommaInName() throws Exception {
        String rawMessage = "From: sender@example.com\r\nTo: \"User, the first one\" <user1@example.com>\r\nSubject: extract this recipient please\r\n\r\nPlease!";
        MimeMessage message = MimeMessageUtil.mimeMessageFromString((String)rawMessage);
        FakeMail mail = FakeMail.builder().name("mail").mimeMessage(message).sender(SENDER).recipient("recipient@example.com").build();
        this.mailet.init((MailetConfig)this.mailetConfig);
        String expectedMessage = "{\"userEmail\" : \"sender@james.org\", \"emails\" : [ \"\\\"User, the first one\\\" <user1@example.com>\" ]}";
        this.mailet.service((Mail)mail);
        Assertions.assertThat((Optional)mail.getAttribute(ATTRIBUTE_NAME)).hasValueSatisfying(json -> JsonAssertions.assertThatJson((Object)json.getValue().value().toString()).isEqualTo((Object)expectedMessage));
    }

    @Test
    public void serviceShouldNotOverwriteSenderWhenDifferentFromField() throws Exception {
        MimeMessageBuilder message = MimeMessageBuilder.mimeMessageBuilder().addFrom("other@sender.org").addToRecipient("To <to@james.org>").setSubject("Contact collection Rocks").setText("This is my email");
        FakeMail mail = FakeMail.builder().name("mail").mimeMessage(message).sender(SENDER).recipient(TO).build();
        this.mailet.init((MailetConfig)this.mailetConfig);
        String expectedMessage = "{\"userEmail\" : \"sender@james.org\", \"emails\" : [ \"To <to@james.org>\" ]}";
        this.mailet.service((Mail)mail);
        Assertions.assertThat((Optional)mail.getAttribute(ATTRIBUTE_NAME)).hasValueSatisfying(json -> JsonAssertions.assertThatJson((Object)json.getValue().value().toString()).isEqualTo((Object)expectedMessage));
    }

    @Test
    public void serviceShouldNotOverwriteSenderWhenDifferentSenderField() throws Exception {
        MimeMessageBuilder message = MimeMessageBuilder.mimeMessageBuilder().setSender("other@sender.org").addToRecipient("To <to@james.org>").setSubject("Contact collection Rocks").setText("This is my email");
        FakeMail mail = FakeMail.builder().name("mail").mimeMessage(message).sender(SENDER).recipient(TO).build();
        this.mailet.init((MailetConfig)this.mailetConfig);
        String expectedMessage = "{\"userEmail\" : \"sender@james.org\", \"emails\" : [ \"To <to@james.org>\" ]}";
        this.mailet.service((Mail)mail);
        Assertions.assertThat((Optional)mail.getAttribute(ATTRIBUTE_NAME)).hasValueSatisfying(json -> JsonAssertions.assertThatJson((Object)json.getValue().value().toString()).isEqualTo((Object)expectedMessage));
    }

    @Test
    public void serviceShouldSkipMessagesWithoutSenderEnvelope() throws Exception {
        MimeMessageBuilder message = MimeMessageBuilder.mimeMessageBuilder().addToRecipient("To <to@james.org>").setSubject("Contact collection Rocks").setText("This is my email");
        FakeMail mail = FakeMail.builder().name("mail").mimeMessage(message).recipient(TO).build();
        this.mailet.init((MailetConfig)this.mailetConfig);
        this.mailet.service((Mail)mail);
        Assertions.assertThat((Optional)mail.getAttribute(ATTRIBUTE_NAME)).isEmpty();
    }

    @Test
    public void serviceShouldNotAddTheAttributeWhenNoRecipient() throws Exception {
        MimeMessageBuilder message = MimeMessageBuilder.mimeMessageBuilder().setSender(SENDER).setSubject("Contact collection Rocks").setText("This is my email");
        FakeMail mail = FakeMail.builder().name("mail").mimeMessage(message).sender(SENDER).build();
        this.mailet.init((MailetConfig)this.mailetConfig);
        this.mailet.service((Mail)mail);
        Assertions.assertThat((Optional)mail.getAttribute(ATTRIBUTE_NAME)).isEmpty();
    }

    @Test
    public void extractContactsShouldNotThrowWhenNoRecipient() throws Exception {
        MimeMessageBuilder message = MimeMessageBuilder.mimeMessageBuilder().setSender(SENDER).setSubject("Contact collection Rocks").setText("This is my email");
        FakeMail mail = FakeMail.builder().name("mail").mimeMessage(message).sender(SENDER).build();
        this.mailet.extractContacts((Mail)mail);
    }
}

