/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.transport.mailets;

import javax.mail.MessagingException;
import javax.mail.internet.MimeMessage;
import org.apache.james.transport.mailets.AddSubjectPrefix;
import org.apache.mailet.Mail;
import org.apache.mailet.Mailet;
import org.apache.mailet.MailetConfig;
import org.apache.mailet.base.test.FakeMail;
import org.apache.mailet.base.test.FakeMailetConfig;
import org.apache.mailet.base.test.MailUtil;
import org.assertj.core.api.AbstractStringAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

class AddSubjectPrefixTest {
    private Mailet mailet;

    AddSubjectPrefixTest() {
    }

    @BeforeEach
    void setup() {
        this.mailet = new AddSubjectPrefix();
    }

    @Test
    void shouldAddPrefixToSubject() throws MessagingException {
        FakeMailetConfig mailetConfig = FakeMailetConfig.builder().mailetName("Test").setProperty("subjectPrefix", "JUNIT").build();
        this.mailet.init((MailetConfig)mailetConfig);
        MimeMessage mimeMessage = MailUtil.createMimeMessageWithSubject((String)"test");
        FakeMail mail = MailUtil.createMockMail2Recipients((MimeMessage)mimeMessage);
        this.mailet.service((Mail)mail);
        Assertions.assertThat((String)mail.getMessage().getSubject()).isEqualTo("JUNIT test");
    }

    @Test
    void shouldAddPrefixToEncodedSubject() throws MessagingException {
        FakeMailetConfig mailetConfig = FakeMailetConfig.builder().mailetName("Test").setProperty("subjectPrefix", "\u0420\u0443\u0441\u0441\u043a\u0438\u0439").build();
        this.mailet.init((MailetConfig)mailetConfig);
        String subject = "=?iso8859-15?Q?Beno=EEt_TELLIER_vous_a_d=E9pos=E9_des_fichiers?=";
        MimeMessage mimeMessage = MailUtil.createMimeMessageWithSubject((String)subject);
        FakeMail mail = MailUtil.createMockMail2Recipients((MimeMessage)mimeMessage);
        this.mailet.service((Mail)mail);
        ((AbstractStringAssert)Assertions.assertThat((String)mail.getMessage().getSubject()).startsWith((CharSequence)"\u0420\u0443\u0441\u0441\u043a\u0438\u0439")).endsWith((CharSequence)"Beno\u00eet TELLIER vous a d\u00e9pos\u00e9 des fichiers");
    }

    @Test
    void shouldDefinePrefixAsSubjectWhenNoSubject() throws MessagingException {
        FakeMailetConfig mailetConfig = FakeMailetConfig.builder().mailetName("Test").setProperty("subjectPrefix", "JUNIT").build();
        this.mailet.init((MailetConfig)mailetConfig);
        String noSubject = null;
        MimeMessage mimeMessage = MailUtil.createMimeMessageWithSubject(noSubject);
        FakeMail mail = MailUtil.createMockMail2Recipients((MimeMessage)mimeMessage);
        this.mailet.service((Mail)mail);
        Assertions.assertThat((String)mail.getMessage().getSubject()).isEqualTo("JUNIT");
    }

    @Test
    void shouldDefinePrefixAsSubjectWhenEmptySubject() throws MessagingException {
        FakeMailetConfig mailetConfig = FakeMailetConfig.builder().mailetName("Test").setProperty("subjectPrefix", "JUNIT").build();
        this.mailet.init((MailetConfig)mailetConfig);
        MimeMessage mimeMessage = MailUtil.createMimeMessageWithSubject((String)"");
        FakeMail mail = MailUtil.createMockMail2Recipients((MimeMessage)mimeMessage);
        this.mailet.service((Mail)mail);
        Assertions.assertThat((String)mail.getMessage().getSubject()).isEqualTo("JUNIT");
    }

    @Test
    void shouldThrowWhenEmptyPrefix() throws MessagingException {
        FakeMailetConfig mailetConfig = FakeMailetConfig.builder().mailetName("Test").setProperty("subjectPrefix", "").build();
        Assertions.assertThatThrownBy(() -> this.mailet.init((MailetConfig)mailetConfig)).isInstanceOf(MessagingException.class);
    }
}

