/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.transport.mailets;

import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.ArrayList;
import java.util.stream.Stream;
import javax.mail.MessagingException;
import org.apache.james.transport.mailets.AddFooter;
import org.apache.mailet.Mail;
import org.apache.mailet.Mailet;
import org.apache.mailet.MailetConfig;
import org.apache.mailet.base.test.FakeMail;
import org.apache.mailet.base.test.FakeMailetConfig;
import org.apache.mailet.base.test.MailUtil;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.ArgumentsProvider;
import org.junit.jupiter.params.provider.ArgumentsSource;

class AddFooterTest {
    private static final String MY_FOOTER = "my footer";
    private Mailet mailet;

    AddFooterTest() {
    }

    @BeforeEach
    void setup() {
        this.mailet = new AddFooter();
    }

    @ParameterizedTest
    @ArgumentsSource(value=CharsetTuples.class)
    void shouldAddFooterWhenQuotedPrintableTextPlainMessage(String javaCharset, String javaMailCharset) throws MessagingException, IOException {
        FakeMailetConfig mailetConfig = FakeMailetConfig.builder().mailetName("Test").setProperty("text", "------ my footer \u00e0/\u20ac ------").build();
        this.mailet.init((MailetConfig)mailetConfig);
        String quotedPrintableTextPlainMessage = Joiner.on((String)"\r\n").join((Object)"Subject: test", (Object)"Content-Type: text/plain; charset=ISO-8859-15", new Object[]{"MIME-Version: 1.0", "Content-Transfer-Encoding: quoted-printable", "", "Test=E0 and one =A4", ""});
        String expectedFooter = "------ my footer =E0/=A4 ------";
        FakeMail mail = FakeMail.fromMime((String)quotedPrintableTextPlainMessage, (String)javaCharset, (String)javaMailCharset);
        this.mailet.service((Mail)mail);
        Assertions.assertThat((String)MailUtil.toString((Mail)mail, (String)javaCharset)).endsWith((CharSequence)expectedFooter);
    }

    @ParameterizedTest
    @ArgumentsSource(value=CharsetTuples.class)
    void shouldEnsureCarriageReturnWhenAddFooterWithTextPlainMessage(String javaCharset, String javaMailCharset) throws MessagingException, IOException {
        FakeMailetConfig mailetConfig = FakeMailetConfig.builder().mailetName("Test").setProperty("text", "------ my footer \u00e0/\u20ac ------").build();
        this.mailet.init((MailetConfig)mailetConfig);
        String quotedPrintableTextPlainMessage = Joiner.on((String)"\r\n").join((Object)"Subject: test", (Object)"Content-Type: text/plain; charset=ISO-8859-15", new Object[]{"MIME-Version: 1.0", "Content-Transfer-Encoding: quoted-printable", "", "Test=E0 and one =A4"});
        String expectedFooter = "------ my footer =E0/=A4 ------";
        FakeMail mail = FakeMail.fromMime((String)quotedPrintableTextPlainMessage, (String)javaCharset, (String)javaMailCharset);
        this.mailet.service((Mail)mail);
        Assertions.assertThat((String)MailUtil.toString((Mail)mail, (String)javaCharset)).endsWith((CharSequence)("\r\n" + expectedFooter));
    }

    @ParameterizedTest
    @ArgumentsSource(value=CharsetTuples.class)
    void shouldNotAddFooterWhenUnsupportedEncoding(String javaCharset, String javaMailCharset) throws MessagingException, IOException {
        FakeMailetConfig mailetConfig = FakeMailetConfig.builder().mailetName("Test").setProperty("text", "------ my footer \u00e0/\u20ac ------").build();
        this.mailet.init((MailetConfig)mailetConfig);
        String quotedPrintableTextPlainMessage = Joiner.on((String)"\r\n").join((Object)"Subject: test", (Object)"Content-Type: text/plain; charset=UNSUPPORTED_ENCODING", new Object[]{"MIME-Version: 1.0", "Content-Transfer-Encoding: quoted-printable", "", "Test=E0 and one", ""});
        FakeMail mail = FakeMail.fromMime((String)quotedPrintableTextPlainMessage, (String)javaCharset, (String)javaMailCharset);
        this.mailet.service((Mail)mail);
        Assertions.assertThat((String)MailUtil.toString((Mail)mail, (String)javaCharset)).doesNotContain(new CharSequence[]{MY_FOOTER});
    }

    @ParameterizedTest
    @ArgumentsSource(value=CharsetTuples.class)
    void shouldNotAddFooterWhenUnsupportedTextContentType(String javaCharset, String javaMailCharset) throws MessagingException, IOException {
        FakeMailetConfig mailetConfig = FakeMailetConfig.builder().mailetName("Test").setProperty("text", "------ my footer \u00e0/\u20ac ------").build();
        this.mailet.init((MailetConfig)mailetConfig);
        String quotedPrintableTextPlainMessage = Joiner.on((String)"\r\n").join((Object)"Subject: test", (Object)"Content-Type: text/calendar; charset=ASCII", new Object[]{"MIME-Version: 1.0", "Content-Transfer-Encoding: quoted-printable", "", "Test=E0 and one", ""});
        FakeMail mail = FakeMail.fromMime((String)quotedPrintableTextPlainMessage, (String)javaCharset, (String)javaMailCharset);
        this.mailet.service((Mail)mail);
        Assertions.assertThat((String)MailUtil.toString((Mail)mail, (String)javaCharset)).isEqualTo(quotedPrintableTextPlainMessage);
    }

    @ParameterizedTest
    @ArgumentsSource(value=CharsetTuples.class)
    void shouldNotAddFooterWhenNestedUnsupportedMultipart(String javaCharset, String javaMailCharset) throws MessagingException, IOException {
        FakeMailetConfig mailetConfig = FakeMailetConfig.builder().mailetName("Test").setProperty("text", "------ my footer \u00e0/\u20ac ------").build();
        this.mailet.init((MailetConfig)mailetConfig);
        String quotedPrintableMultipartMixedMessage = Joiner.on((String)"\r\n").join((Object)"MIME-Version: 1.0", (Object)"Content-Type: multipart/mixed; boundary=\"===============0204599088==\"", new Object[]{"", "This is a cryptographically signed message in MIME format.", "", "--===============0204599088==", "Content-Type: multipart/unsupported; boundary=\"------------ms050404020900070803030808\"", "", "--------------ms050404020900070803030808", "Content-Type: text/plain; charset=ISO-8859-1", "", "test", "", "--------------ms050404020900070803030808--", "", "--===============0204599088==--", ""});
        FakeMail mail = FakeMail.fromMime((String)quotedPrintableMultipartMixedMessage, (String)javaCharset, (String)javaMailCharset);
        this.mailet.service((Mail)mail);
        Assertions.assertThat((String)MailUtil.toString((Mail)mail, (String)javaCharset)).isEqualTo(quotedPrintableMultipartMixedMessage);
    }

    @ParameterizedTest
    @ArgumentsSource(value=CharsetTuples.class)
    void shouldAddFooterWhenMultipartRelatedHtmlMessage(String javaCharset, String javaMailCharset) throws MessagingException, IOException {
        FakeMailetConfig mailetConfig = FakeMailetConfig.builder().mailetName("Test").setProperty("text", "------ my footer \u00e0/\u20ac ------").build();
        this.mailet.init((MailetConfig)mailetConfig);
        String htmlMultipartRelatedMessagePart1 = Joiner.on((String)"\r\n").join((Object)"MIME-Version: 1.0", (Object)"Subject: test", new Object[]{"Content-Type: multipart/related;", "  boundary=\"------------050206010102010306090507\"", "", "--------------050206010102010306090507", "Content-Type: text/html; charset=ISO-8859-15", "Content-Transfer-Encoding: quoted-printable", "", "<!DOCTYPE html PUBLIC \"-//W3C//DTD HTML 4.01 Transitional//EN\">", "<html>", "<head>", "<meta content=3D\"text/html;charset=3DISO-8859-15\" http-equiv=3D\"Content-Typ=", "e\">", "</head>", "<body bgcolor=3D\"#ffffff\" text=3D\"#000000\">", "<br>", "<div class=3D\"moz-signature\">-- <br>", "<img src=3D\"cid:part1.02060605.123@zzz.com\" border=3D\"0\"></div>", ""});
        String htmlMultipartRelatedMessagePart2 = Joiner.on((String)"\r\n").join((Object)"</body>", (Object)"</html>", new Object[]{"", "--------------050206010102010306090507", "Content-Type: image/gif", "Content-Transfer-Encoding: base64", "Content-ID: <part1.02060605.123@zzz.com>", "Content-Disposition: inline;", "", "YQ==", "--------------050206010102010306090507--", ""});
        String expectedFooter = "<br />------ my footer =E0/=A4 ------";
        FakeMail mail = FakeMail.fromMime((String)(htmlMultipartRelatedMessagePart1 + htmlMultipartRelatedMessagePart2), (String)javaCharset, (String)javaMailCharset);
        this.mailet.service((Mail)mail);
        Assertions.assertThat((String)MailUtil.toString((Mail)mail, (String)javaCharset)).contains(new CharSequence[]{expectedFooter});
    }

    @ParameterizedTest
    @ArgumentsSource(value=CharsetTuples.class)
    void shouldAddFooterWhenMultipartAlternivateMessage(String javaCharset, String javaMailCharset) throws MessagingException, IOException {
        FakeMailetConfig mailetConfig = FakeMailetConfig.builder().mailetName("Test").setProperty("text", "------ my footer \u00e0/\u20ac ------").build();
        this.mailet.init((MailetConfig)mailetConfig);
        String multipartAlternativeMessage = Joiner.on((String)"\r\n").join((Object)"Subject: test", (Object)"Content-Type: multipart/alternative;", new Object[]{"    boundary=\"--==--\"", "MIME-Version: 1.0", "", "----==--", "Content-Type: text/plain;", "    charset=\"ISO-8859-15\"", "Content-Transfer-Encoding: quoted-printable", "", "Test=E0 and @=80", "", "----==--", "Content-Type: text/html;", "    charset=\"CP1252\"", "Content-Transfer-Encoding: quoted-printable", "", "<html><body>test =80 ss</body></html>", "----==----"});
        FakeMail mail = FakeMail.fromMime((String)multipartAlternativeMessage, (String)javaCharset, (String)javaMailCharset);
        this.mailet.service((Mail)mail);
        Assertions.assertThat((String)MailUtil.toString((Mail)mail, (String)javaCharset)).matches((CharSequence)"(.|\n|\r)*my footer(.|\n|\r)*my footer(.|\n|\r)*");
    }

    @ParameterizedTest
    @ArgumentsSource(value=CharsetTuples.class)
    void shouldAddFooterWhenHtmlMessageWithMixedCaseBodyTag(String javaCharset, String javaMailCharset) throws MessagingException, IOException {
        FakeMailetConfig mailetConfig = FakeMailetConfig.builder().mailetName("Test").setProperty("text", "------ my footer \u00e0/\u20ac ------").build();
        this.mailet.init((MailetConfig)mailetConfig);
        String htmlMessage = Joiner.on((String)"\r\n").join((Object)"Subject: test", (Object)"MIME-Version: 1.0", new Object[]{"Content-Type: text/html;", "    charset=\"CP1252\"", "Content-Transfer-Encoding: quoted-printable", "", "<html><body>test =80 ss</bOdY></html>", ""});
        FakeMail mail = FakeMail.fromMime((String)htmlMessage, (String)javaCharset, (String)javaMailCharset);
        this.mailet.service((Mail)mail);
        String htmlContent = "<html><body>test =80 ss<br />------ my footer =E0/=80 ------</bOdY></html>";
        Assertions.assertThat((String)MailUtil.toString((Mail)mail, (String)javaCharset)).contains(new CharSequence[]{htmlContent});
    }

    @ParameterizedTest
    @ArgumentsSource(value=CharsetTuples.class)
    void shouldAddFooterWhenHtmlMessageWithNoBodyTag(String javaCharset, String javaMailCharset) throws MessagingException, IOException {
        FakeMailetConfig mailetConfig = FakeMailetConfig.builder().mailetName("Test").setProperty("text", "------ my footer \u00e0/\u20ac ------").build();
        this.mailet.init((MailetConfig)mailetConfig);
        String htmlMessage = Joiner.on((String)"\r\n").join((Object)"Subject: test", (Object)"MIME-Version: 1.0", new Object[]{"Content-Type: text/html;", "    charset=\"CP1252\"", "Content-Transfer-Encoding: quoted-printable", "", "<html><body>test =80 ss", ""});
        FakeMail mail = FakeMail.fromMime((String)htmlMessage, (String)javaCharset, (String)javaMailCharset);
        this.mailet.service((Mail)mail);
        String expectedFooter = "<br />------ my footer =E0/=80 ------";
        Assertions.assertThat((String)MailUtil.toString((Mail)mail, (String)javaCharset)).endsWith((CharSequence)expectedFooter);
    }

    static class CharsetTuples
    implements ArgumentsProvider {
        CharsetTuples() {
        }

        public Stream<? extends Arguments> provideArguments(ExtensionContext context) throws Exception {
            ArrayList charsetNamesToTest = Lists.newArrayList((Object[])new String[]{"ANSI_X3.4-1968", "iso-ir-6", "ANSI_X3.4-1986", "ISO_646.irv:1991", "ASCII", "ISO646-US", "US-ASCII", "us", "IBM367", "cp367", "csASCII"});
            return charsetNamesToTest.stream().flatMap(from -> charsetNamesToTest.stream().map(to -> Arguments.of((Object[])new Object[]{from, to})));
        }
    }
}

