/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.transport.mailets;

import org.apache.james.core.MailAddress;
import org.apache.james.transport.mailets.AddDeliveredToHeader;
import org.apache.mailet.Mail;
import org.apache.mailet.MailetConfig;
import org.apache.mailet.MailetContext;
import org.apache.mailet.PerRecipientHeaders;
import org.apache.mailet.base.MailAddressFixture;
import org.apache.mailet.base.test.FakeMail;
import org.apache.mailet.base.test.FakeMailContext;
import org.apache.mailet.base.test.FakeMailetConfig;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class AddDeliveredToHeaderTest {
    private AddDeliveredToHeader testee;

    @BeforeEach
    public void setUp() throws Exception {
        this.testee = new AddDeliveredToHeader();
        this.testee.init((MailetConfig)FakeMailetConfig.builder().mailetName("AddDeliveredToHeader").mailetContext((MailetContext)FakeMailContext.defaultContext()).build());
    }

    @Test
    public void serviceShouldHandleMailWithoutRecipient() throws Exception {
        FakeMail mail = FakeMail.builder().name("mail").build();
        this.testee.service((Mail)mail);
        Assertions.assertThat((Object)mail.getPerRecipientSpecificHeaders()).isEqualTo((Object)new PerRecipientHeaders());
    }

    @Test
    public void serviceShouldAddPerRecipientDeliveredToSpecificHeader() throws Exception {
        FakeMail mail = FakeMail.builder().name("mail").recipients(new MailAddress[]{MailAddressFixture.ANY_AT_JAMES, MailAddressFixture.OTHER_AT_JAMES}).build();
        this.testee.service((Mail)mail);
        PerRecipientHeaders expectedResult = new PerRecipientHeaders().addHeaderForRecipient(PerRecipientHeaders.Header.builder().name("Delivered-To").value(MailAddressFixture.ANY_AT_JAMES.asString()).build(), MailAddressFixture.ANY_AT_JAMES).addHeaderForRecipient(PerRecipientHeaders.Header.builder().name("Delivered-To").value(MailAddressFixture.OTHER_AT_JAMES.asString()).build(), MailAddressFixture.OTHER_AT_JAMES);
        Assertions.assertThat((Object)mail.getPerRecipientSpecificHeaders()).isEqualTo((Object)expectedResult);
    }
}

