/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.spamassassin;

import com.google.inject.AbstractModule;
import com.google.inject.Provides;
import java.io.FileNotFoundException;
import javax.inject.Singleton;
import org.apache.commons.configuration2.Configuration;
import org.apache.commons.configuration2.ex.ConfigurationException;
import org.apache.james.spamassassin.SpamAssassinConfiguration;
import org.apache.james.util.Host;
import org.apache.james.utils.PropertiesProvider;

public class SpamAssassinModule
extends AbstractModule {
    private static final String SPAMASSASSIN_HOST = "spamassassin.host";
    private static final String SPAMASSASSIN_PORT = "spamassassin.port";
    public static final String DEFAULT_HOST = "127.0.0.1";
    public static final int DEFAULT_PORT = 783;

    @Provides
    @Singleton
    private SpamAssassinConfiguration getSpamAssassinConfiguration(PropertiesProvider propertiesProvider) throws ConfigurationException, FileNotFoundException {
        Configuration configuration = propertiesProvider.getConfiguration("spamassassin");
        Host host = Host.from((String)configuration.getString(SPAMASSASSIN_HOST, DEFAULT_HOST), (int)configuration.getInteger(SPAMASSASSIN_PORT, Integer.valueOf(783)));
        return new SpamAssassinConfiguration(host);
    }
}

