/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.spamassassin;

import com.github.fge.lambdas.Throwing;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import java.io.InputStream;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Stream;
import javax.inject.Inject;
import org.apache.james.core.Username;
import org.apache.james.events.Event;
import org.apache.james.events.EventListener;
import org.apache.james.events.Group;
import org.apache.james.mailbox.MailboxManager;
import org.apache.james.mailbox.MailboxSession;
import org.apache.james.mailbox.Role;
import org.apache.james.mailbox.SystemMailboxesProvider;
import org.apache.james.mailbox.events.MailboxEvents;
import org.apache.james.mailbox.events.MessageMoveEvent;
import org.apache.james.mailbox.exception.MailboxException;
import org.apache.james.mailbox.model.Mailbox;
import org.apache.james.mailbox.model.MailboxId;
import org.apache.james.mailbox.model.MessageRange;
import org.apache.james.mailbox.store.MailboxSessionMapperFactory;
import org.apache.james.mailbox.store.event.SpamEventListener;
import org.apache.james.mailbox.store.mail.MessageMapper;
import org.apache.james.mailbox.store.mail.model.MailboxMessage;
import org.apache.james.mailbox.store.mail.model.Message;
import org.apache.james.spamassassin.SpamAssassinLearner;
import org.apache.james.util.streams.Iterators;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SpamAssassinListener
implements SpamEventListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(SpamAssassinListener.class);
    private static final int LIMIT = 1;
    private static final Group GROUP = new SpamAssassinListenerGroup();
    private final SpamAssassinLearner spamAssassinLearner;
    private final SystemMailboxesProvider systemMailboxesProvider;
    private final MailboxManager mailboxManager;
    private final MailboxSessionMapperFactory mapperFactory;
    private final EventListener.ExecutionMode executionMode;

    @Inject
    public SpamAssassinListener(SpamAssassinLearner spamAssassinLearner, SystemMailboxesProvider systemMailboxesProvider, MailboxManager mailboxManager, MailboxSessionMapperFactory mapperFactory, EventListener.ExecutionMode executionMode) {
        this.spamAssassinLearner = spamAssassinLearner;
        this.systemMailboxesProvider = systemMailboxesProvider;
        this.mailboxManager = mailboxManager;
        this.mapperFactory = mapperFactory;
        this.executionMode = executionMode;
    }

    public Group getDefaultGroup() {
        return GROUP;
    }

    public EventListener.ExecutionMode getExecutionMode() {
        return this.executionMode;
    }

    public boolean isHandling(Event event) {
        return event instanceof MessageMoveEvent || event instanceof MailboxEvents.Added;
    }

    public void event(Event event) throws MailboxException {
        MailboxSession session;
        Username username = Username.of((String)this.getClass().getCanonicalName());
        if (event instanceof MessageMoveEvent) {
            session = this.mailboxManager.createSystemSession(username);
            this.handleMessageMove(event, session, (MessageMoveEvent)event);
        }
        if (event instanceof MailboxEvents.Added) {
            session = this.mailboxManager.createSystemSession(username);
            this.handleAdded(event, session, (MailboxEvents.Added)event);
        }
    }

    private void handleAdded(Event event, MailboxSession session, MailboxEvents.Added addedEvent) {
        if (this.isAppendedToInbox(addedEvent)) {
            Mailbox mailbox = (Mailbox)this.mapperFactory.getMailboxMapper(session).findMailboxById(addedEvent.getMailboxId()).block();
            MessageMapper messageMapper = this.mapperFactory.getMessageMapper(session);
            List contents = (List)MessageRange.toRanges((Collection)addedEvent.getUids()).stream().flatMap(range -> this.retrieveMessages(messageMapper, mailbox, (MessageRange)range)).map(Throwing.function(Message::getFullContent)).collect(ImmutableList.toImmutableList());
            this.spamAssassinLearner.learnHam(contents, event.getUsername());
        }
    }

    private void handleMessageMove(Event event, MailboxSession session, MessageMoveEvent messageMoveEvent) {
        ImmutableList<InputStream> messages;
        if (this.isMessageMovedToSpamMailbox(messageMoveEvent)) {
            LOGGER.debug("Spam event detected");
            messages = this.retrieveMessages(messageMoveEvent, session);
            this.spamAssassinLearner.learnSpam((List<InputStream>)messages, event.getUsername());
        }
        if (this.isMessageMovedOutOfSpamMailbox(messageMoveEvent)) {
            messages = this.retrieveMessages(messageMoveEvent, session);
            this.spamAssassinLearner.learnHam((List<InputStream>)messages, event.getUsername());
        }
    }

    private Stream<MailboxMessage> retrieveMessages(MessageMapper messageMapper, Mailbox mailbox, MessageRange range) {
        try {
            return Iterators.toStream((Iterator)messageMapper.findInMailbox(mailbox, range, MessageMapper.FetchType.FULL, 1));
        }
        catch (MailboxException e) {
            LOGGER.warn("Can not retrieve message {} {}", new Object[]{mailbox.getMailboxId(), range.toString(), e});
            return Stream.empty();
        }
    }

    private boolean isAppendedToInbox(MailboxEvents.Added addedEvent) {
        try {
            return this.systemMailboxesProvider.findMailbox(Role.INBOX, addedEvent.getUsername()).getId().equals(addedEvent.getMailboxId());
        }
        catch (MailboxException e) {
            LOGGER.warn("Could not resolve Inbox mailbox", (Throwable)e);
            return false;
        }
    }

    private ImmutableList<InputStream> retrieveMessages(MessageMoveEvent messageMoveEvent, MailboxSession session) {
        return (ImmutableList)this.mapperFactory.getMessageIdMapper(session).find(messageMoveEvent.getMessageIds(), MessageMapper.FetchType.FULL).stream().map(Throwing.function(Message::getFullContent)).collect(ImmutableList.toImmutableList());
    }

    @VisibleForTesting
    boolean isMessageMovedToSpamMailbox(MessageMoveEvent event) {
        try {
            MailboxId spamMailboxId = this.systemMailboxesProvider.findMailbox(Role.SPAM, event.getUsername()).getId();
            return event.getMessageMoves().addedMailboxIds().contains(spamMailboxId);
        }
        catch (MailboxException e) {
            LOGGER.warn("Could not resolve Spam mailbox", (Throwable)e);
            return false;
        }
    }

    @VisibleForTesting
    boolean isMessageMovedOutOfSpamMailbox(MessageMoveEvent event) {
        try {
            MailboxId spamMailboxId = this.systemMailboxesProvider.findMailbox(Role.SPAM, event.getUsername()).getId();
            MailboxId trashMailboxId = this.systemMailboxesProvider.findMailbox(Role.TRASH, event.getUsername()).getId();
            return event.getMessageMoves().removedMailboxIds().contains(spamMailboxId) && !event.getMessageMoves().addedMailboxIds().contains(trashMailboxId);
        }
        catch (MailboxException e) {
            LOGGER.warn("Could not resolve Spam mailbox", (Throwable)e);
            return false;
        }
    }

    public static class SpamAssassinListenerGroup
    extends Group {
    }
}

