/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.spamassassin;

import com.github.fge.lambdas.Throwing;
import java.io.InputStream;
import java.util.List;
import javax.inject.Inject;
import org.apache.james.core.Username;
import org.apache.james.metrics.api.MetricFactory;
import org.apache.james.spamassassin.SpamAssassinConfiguration;
import org.apache.james.spamassassin.SpamAssassinInvoker;
import org.apache.james.util.Host;

public class SpamAssassinLearner {
    private final MetricFactory metricFactory;
    private final Host spamAssassinHost;

    @Inject
    public SpamAssassinLearner(MetricFactory metricFactory, SpamAssassinConfiguration spamAssassinConfiguration) {
        this.metricFactory = metricFactory;
        this.spamAssassinHost = spamAssassinConfiguration.getHost();
    }

    public void learnSpam(List<InputStream> messages, Username username) {
        SpamAssassinInvoker invoker = new SpamAssassinInvoker(this.metricFactory, this.spamAssassinHost.getHostName(), this.spamAssassinHost.getPort());
        messages.forEach(Throwing.consumer(message -> invoker.learnAsSpam((InputStream)message, username)));
    }

    public void learnHam(List<InputStream> messages, Username username) {
        SpamAssassinInvoker invoker = new SpamAssassinInvoker(this.metricFactory, this.spamAssassinHost.getHostName(), this.spamAssassinHost.getPort());
        messages.forEach(Throwing.consumer(message -> invoker.learnAsHam((InputStream)message, username)));
    }
}

