/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.spamassassin;

import com.google.common.primitives.Ints;
import java.io.IOException;
import java.time.Duration;
import java.util.concurrent.TimeUnit;
import org.rnorth.ducttape.unreliables.Unreliables;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.containers.wait.strategy.WaitStrategy;
import org.testcontainers.containers.wait.strategy.WaitStrategyTarget;

public class SpamAssassinWaitStrategy
implements WaitStrategy {
    private static final Duration DEFAULT_TIMEOUT = Duration.ofMinutes(1L);
    private final GenericContainer<?> spamAssassinContainer;
    private final Duration timeout;

    public SpamAssassinWaitStrategy(GenericContainer<?> spamAssassinContainer) {
        this(spamAssassinContainer, DEFAULT_TIMEOUT);
    }

    public SpamAssassinWaitStrategy(GenericContainer<?> spamAssassinContainer, Duration timeout) {
        this.spamAssassinContainer = spamAssassinContainer;
        this.timeout = timeout;
    }

    public void waitUntilReady(WaitStrategyTarget waitStrategyTarget) {
        Unreliables.retryUntilTrue((int)Ints.checkedCast((long)this.timeout.getSeconds()), (TimeUnit)TimeUnit.SECONDS, () -> {
            try {
                return this.spamAssassinContainer.execInContainer(new String[]{"spamassassin", "-V"}).getStdout().contains("SpamAssassin version 3.4.2");
            }
            catch (IOException | InterruptedException e) {
                return false;
            }
        });
    }

    public WaitStrategy withStartupTimeout(Duration startupTimeout) {
        return new SpamAssassinWaitStrategy(this.spamAssassinContainer, startupTimeout);
    }
}

