/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.spamassassin;

import java.nio.charset.StandardCharsets;
import java.util.Date;
import java.util.List;
import javax.mail.Flags;
import org.apache.james.core.Username;
import org.apache.james.events.Event;
import org.apache.james.events.EventListener;
import org.apache.james.events.Group;
import org.apache.james.mailbox.MailboxManager;
import org.apache.james.mailbox.MailboxSession;
import org.apache.james.mailbox.MailboxSessionUtil;
import org.apache.james.mailbox.SystemMailboxesProvider;
import org.apache.james.mailbox.events.MailboxEvents;
import org.apache.james.mailbox.events.MessageMoveEvent;
import org.apache.james.mailbox.exception.MailboxException;
import org.apache.james.mailbox.inmemory.manager.InMemoryIntegrationResources;
import org.apache.james.mailbox.model.ByteContent;
import org.apache.james.mailbox.model.Content;
import org.apache.james.mailbox.model.Mailbox;
import org.apache.james.mailbox.model.MailboxId;
import org.apache.james.mailbox.model.MailboxPath;
import org.apache.james.mailbox.model.MessageId;
import org.apache.james.mailbox.model.MessageMetaData;
import org.apache.james.mailbox.model.MessageMoves;
import org.apache.james.mailbox.model.TestMessageId;
import org.apache.james.mailbox.model.ThreadId;
import org.apache.james.mailbox.model.UidValidity;
import org.apache.james.mailbox.store.MailboxSessionMapperFactory;
import org.apache.james.mailbox.store.StoreMailboxManager;
import org.apache.james.mailbox.store.SystemMailboxesProviderImpl;
import org.apache.james.mailbox.store.event.EventFactory;
import org.apache.james.mailbox.store.mail.MailboxMapper;
import org.apache.james.mailbox.store.mail.model.MailboxMessage;
import org.apache.james.mailbox.store.mail.model.impl.PropertyBuilder;
import org.apache.james.mailbox.store.mail.model.impl.SimpleMailboxMessage;
import org.apache.james.spamassassin.SpamAssassinLearner;
import org.apache.james.spamassassin.SpamAssassinListener;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;

class SpamAssassinListenerTest {
    static final Username USER = Username.of((String)"user");
    static final MailboxSession MAILBOX_SESSION = MailboxSessionUtil.create((Username)USER);
    static final UidValidity UID_VALIDITY = UidValidity.of((long)43L);
    static final TestMessageId MESSAGE_ID = TestMessageId.of((long)45L);
    static final ThreadId THREAD_ID = ThreadId.fromBaseMessageId((MessageId)MESSAGE_ID);
    SpamAssassinLearner spamAssassinLearner;
    SpamAssassinListener listener;
    Mailbox inbox;
    Mailbox mailbox1;
    MailboxId mailboxId1;
    MailboxId mailboxId2;
    MailboxId spamMailboxId;
    MailboxId spamCapitalMailboxId;
    MailboxId trashMailboxId;
    MailboxSessionMapperFactory mapperFactory;
    Mailbox mailbox2;

    SpamAssassinListenerTest() {
    }

    @BeforeEach
    void setup() throws Exception {
        StoreMailboxManager mailboxManager = (StoreMailboxManager)Mockito.spy((Object)InMemoryIntegrationResources.defaultResources().getMailboxManager());
        SystemMailboxesProviderImpl systemMailboxesProvider = new SystemMailboxesProviderImpl((MailboxManager)mailboxManager);
        Mockito.when((Object)mailboxManager.createSystemSession(USER)).thenReturn((Object)MAILBOX_SESSION);
        this.spamAssassinLearner = (SpamAssassinLearner)Mockito.mock(SpamAssassinLearner.class);
        this.mapperFactory = mailboxManager.getMapperFactory();
        MailboxMapper mailboxMapper = this.mapperFactory.createMailboxMapper(MAILBOX_SESSION);
        this.inbox = (Mailbox)mailboxMapper.create(MailboxPath.forUser((Username)USER, (String)"INBOX"), UID_VALIDITY).block();
        this.mailbox1 = (Mailbox)mailboxMapper.create(MailboxPath.forUser((Username)USER, (String)"mailbox1"), UID_VALIDITY).block();
        this.mailbox2 = (Mailbox)mailboxMapper.create(MailboxPath.forUser((Username)USER, (String)"mailbox2"), UID_VALIDITY).block();
        this.mailboxId1 = this.mailbox1.getMailboxId();
        this.mailboxId2 = this.mailbox2.getMailboxId();
        this.spamMailboxId = ((Mailbox)mailboxMapper.create(MailboxPath.forUser((Username)USER, (String)"Spam"), UID_VALIDITY).block()).getMailboxId();
        this.spamCapitalMailboxId = ((Mailbox)mailboxMapper.create(MailboxPath.forUser((Username)USER, (String)"SPAM"), UID_VALIDITY).block()).getMailboxId();
        this.trashMailboxId = ((Mailbox)mailboxMapper.create(MailboxPath.forUser((Username)USER, (String)"Trash"), UID_VALIDITY).block()).getMailboxId();
        this.listener = new SpamAssassinListener(this.spamAssassinLearner, (SystemMailboxesProvider)systemMailboxesProvider, (MailboxManager)mailboxManager, this.mapperFactory, EventListener.ExecutionMode.SYNCHRONOUS);
    }

    @Test
    void deserializeSpamAssassinListenerGroup() throws Exception {
        Assertions.assertThat((Object)Group.deserialize((String)"org.apache.james.spamassassin.SpamAssassinListener$SpamAssassinListenerGroup")).isEqualTo((Object)new SpamAssassinListener.SpamAssassinListenerGroup());
    }

    @Test
    void isEventOnSpamMailboxShouldReturnFalseWhenMessageIsMovedToANonSpamMailbox() {
        MessageMoveEvent messageMoveEvent = MessageMoveEvent.builder().session(MAILBOX_SESSION).messageMoves(MessageMoves.builder().previousMailboxIds(new MailboxId[]{this.mailboxId1}).targetMailboxIds(new MailboxId[]{this.mailboxId2}).build()).messageId((MessageId)MESSAGE_ID).build();
        Assertions.assertThat((boolean)this.listener.isMessageMovedToSpamMailbox(messageMoveEvent)).isFalse();
    }

    @Test
    void isEventOnSpamMailboxShouldReturnTrueWhenMailboxIsSpam() {
        MessageMoveEvent messageMoveEvent = MessageMoveEvent.builder().session(MAILBOX_SESSION).messageMoves(MessageMoves.builder().previousMailboxIds(new MailboxId[]{this.mailboxId1}).targetMailboxIds(new MailboxId[]{this.spamMailboxId}).build()).messageId((MessageId)MESSAGE_ID).build();
        Assertions.assertThat((boolean)this.listener.isMessageMovedToSpamMailbox(messageMoveEvent)).isTrue();
    }

    @Test
    void isEventOnSpamMailboxShouldReturnFalseWhenMailboxIsSpamOtherCase() {
        MessageMoveEvent messageMoveEvent = MessageMoveEvent.builder().session(MAILBOX_SESSION).messageMoves(MessageMoves.builder().previousMailboxIds(new MailboxId[]{this.mailboxId1}).targetMailboxIds(new MailboxId[]{this.spamCapitalMailboxId}).build()).messageId((MessageId)MESSAGE_ID).build();
        Assertions.assertThat((boolean)this.listener.isMessageMovedToSpamMailbox(messageMoveEvent)).isFalse();
    }

    @Test
    void eventShouldCallSpamAssassinSpamLearningWhenTheEventMatches() throws Exception {
        MessageMoveEvent messageMoveEvent = MessageMoveEvent.builder().session(MAILBOX_SESSION).messageMoves(MessageMoves.builder().previousMailboxIds(new MailboxId[]{this.mailboxId1}).targetMailboxIds(new MailboxId[]{this.spamMailboxId}).build()).messageId((MessageId)MESSAGE_ID).build();
        this.listener.event((Event)messageMoveEvent);
        ((SpamAssassinLearner)Mockito.verify((Object)this.spamAssassinLearner)).learnSpam((List)ArgumentMatchers.any(), (Username)ArgumentMatchers.any());
    }

    @Test
    void isMessageMovedOutOfSpamMailboxShouldReturnFalseWhenMessageMovedBetweenNonSpamMailboxes() {
        MessageMoveEvent messageMoveEvent = MessageMoveEvent.builder().session(MAILBOX_SESSION).messageMoves(MessageMoves.builder().previousMailboxIds(new MailboxId[]{this.mailboxId1}).targetMailboxIds(new MailboxId[]{this.mailboxId2}).build()).messageId((MessageId)MESSAGE_ID).build();
        Assertions.assertThat((boolean)this.listener.isMessageMovedOutOfSpamMailbox(messageMoveEvent)).isFalse();
    }

    @Test
    void isMessageMovedOutOfSpamMailboxShouldReturnFalseWhenMessageMovedOutOfCapitalSpamMailbox() {
        MessageMoveEvent messageMoveEvent = MessageMoveEvent.builder().session(MAILBOX_SESSION).messageMoves(MessageMoves.builder().previousMailboxIds(new MailboxId[]{this.spamCapitalMailboxId}).targetMailboxIds(new MailboxId[]{this.mailboxId2}).build()).messageId((MessageId)MESSAGE_ID).build();
        Assertions.assertThat((boolean)this.listener.isMessageMovedOutOfSpamMailbox(messageMoveEvent)).isFalse();
    }

    @Test
    void isMessageMovedOutOfSpamMailboxShouldReturnTrueWhenMessageMovedOutOfSpamMailbox() {
        MessageMoveEvent messageMoveEvent = MessageMoveEvent.builder().session(MAILBOX_SESSION).messageMoves(MessageMoves.builder().previousMailboxIds(new MailboxId[]{this.spamMailboxId}).targetMailboxIds(new MailboxId[]{this.mailboxId2}).build()).messageId((MessageId)MESSAGE_ID).build();
        Assertions.assertThat((boolean)this.listener.isMessageMovedOutOfSpamMailbox(messageMoveEvent)).isTrue();
    }

    @Test
    void isMessageMovedOutOfSpamMailboxShouldReturnFalseWhenMessageMovedToTrash() {
        MessageMoveEvent messageMoveEvent = MessageMoveEvent.builder().session(MAILBOX_SESSION).messageMoves(MessageMoves.builder().previousMailboxIds(new MailboxId[]{this.spamMailboxId}).targetMailboxIds(new MailboxId[]{this.trashMailboxId}).build()).messageId((MessageId)MESSAGE_ID).build();
        Assertions.assertThat((boolean)this.listener.isMessageMovedOutOfSpamMailbox(messageMoveEvent)).isFalse();
    }

    @Test
    void eventShouldCallSpamAssassinHamLearningWhenTheEventMatches() throws Exception {
        MessageMoveEvent messageMoveEvent = MessageMoveEvent.builder().session(MAILBOX_SESSION).messageMoves(MessageMoves.builder().previousMailboxIds(new MailboxId[]{this.spamMailboxId}).targetMailboxIds(new MailboxId[]{this.mailboxId1}).build()).messageId((MessageId)MESSAGE_ID).build();
        this.listener.event((Event)messageMoveEvent);
        ((SpamAssassinLearner)Mockito.verify((Object)this.spamAssassinLearner)).learnHam((List)ArgumentMatchers.any(), (Username)ArgumentMatchers.any());
    }

    @Test
    void eventShouldCallSpamAssassinHamLearningWhenTheMessageIsAddedInInbox() throws Exception {
        SimpleMailboxMessage message = this.createMessage(this.inbox);
        MailboxEvents.Added addedEvent = ((EventFactory.AddedFinalStage)((EventFactory.RequireIsDelivery)((EventFactory.RequireMetadata)((EventFactory.RequireMailbox)((EventFactory.RequireSession)EventFactory.added().randomEventId()).mailboxSession(MAILBOX_SESSION)).mailbox(this.inbox)).addMetaData(message.metaData())).isDelivery(!MailboxEvents.Added.IS_DELIVERY)).build();
        this.listener.event((Event)addedEvent);
        ((SpamAssassinLearner)Mockito.verify((Object)this.spamAssassinLearner)).learnHam((List)ArgumentMatchers.any(), (Username)ArgumentMatchers.any());
    }

    @Test
    void eventShouldNotCallSpamAssassinHamLearningWhenTheMessageIsAddedInAMailboxOtherThanInbox() throws Exception {
        SimpleMailboxMessage message = this.createMessage(this.mailbox1);
        MailboxEvents.Added addedEvent = ((EventFactory.AddedFinalStage)((EventFactory.RequireIsDelivery)((EventFactory.RequireMetadata)((EventFactory.RequireMailbox)((EventFactory.RequireSession)EventFactory.added().randomEventId()).mailboxSession(MAILBOX_SESSION)).mailbox(this.mailbox1)).addMetaData(message.metaData())).isDelivery(!MailboxEvents.Added.IS_DELIVERY)).build();
        this.listener.event((Event)addedEvent);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.spamAssassinLearner});
    }

    private SimpleMailboxMessage createMessage(Mailbox mailbox) throws MailboxException {
        int size = 45;
        int bodyStartOctet = 25;
        byte[] content = "Subject: test\r\n\r\nBody\r\n".getBytes(StandardCharsets.UTF_8);
        SimpleMailboxMessage message = new SimpleMailboxMessage((MessageId)MESSAGE_ID, THREAD_ID, new Date(), (long)size, bodyStartOctet, (Content)new ByteContent(content), new Flags(), new PropertyBuilder().build(), mailbox.getMailboxId());
        MessageMetaData messageMetaData = this.mapperFactory.createMessageMapper(null).add(mailbox, (MailboxMessage)message);
        message.setUid(messageMetaData.getUid());
        return message;
    }
}

