/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.spamassassin;

import com.google.inject.Binder;
import com.google.inject.Module;
import com.google.inject.Provides;
import com.google.inject.Singleton;
import java.io.File;
import java.util.UUID;
import javax.mail.MessagingException;
import org.apache.james.MemoryJamesServerMain;
import org.apache.james.core.builder.MimeMessageBuilder;
import org.apache.james.mailets.TemporaryJamesServer;
import org.apache.james.mailets.configuration.CommonProcessors;
import org.apache.james.mailets.configuration.Constants;
import org.apache.james.mailets.configuration.MailetConfiguration;
import org.apache.james.mailets.configuration.MailetContainer;
import org.apache.james.mailets.configuration.ProcessorConfiguration;
import org.apache.james.modules.protocols.ImapGuiceProbe;
import org.apache.james.modules.protocols.SmtpGuiceProbe;
import org.apache.james.spamassassin.SpamAssassin;
import org.apache.james.spamassassin.SpamAssassinConfiguration;
import org.apache.james.spamassassin.SpamAssassinResult;
import org.apache.james.transport.matchers.All;
import org.apache.james.util.Host;
import org.apache.james.util.docker.DockerContainer;
import org.apache.james.util.docker.RateLimiters;
import org.apache.james.utils.DataProbeImpl;
import org.apache.james.utils.SMTPMessageSender;
import org.apache.james.utils.TestIMAPClient;
import org.apache.mailet.base.test.FakeMail;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.RegisterExtension;
import org.junit.jupiter.api.io.TempDir;
import org.testcontainers.containers.wait.strategy.HostPortWaitStrategy;

class SpamAssassinIntegrationTest {
    private static final String SPAM_CONTENT = "XJS*C4JDBQADN1.NSBN3*2IDNEN*GTUBE-STANDARD-ANTI-UBE-TEST-EMAIL*C.34X";
    private static final String SPAMASSASSIN_IMAGE = "instantlinux/spamassassin:3.4.6-1";
    @RegisterExtension
    public static DockerContainer spamAssassinContainer = DockerContainer.fromName((String)"instantlinux/spamassassin:3.4.6-1").withExposedPorts(new Integer[]{783}).withAffinityToContainer().waitingFor(new HostPortWaitStrategy().withRateLimiter(RateLimiters.TWENTIES_PER_SECOND)).withName("james-testing-spamassassin-" + UUID.randomUUID());
    @RegisterExtension
    public TestIMAPClient messageReader = new TestIMAPClient();
    @RegisterExtension
    public SMTPMessageSender messageSender = new SMTPMessageSender("james.org");
    private TemporaryJamesServer jamesServer;

    SpamAssassinIntegrationTest() {
    }

    @BeforeEach
    void setup(@TempDir File temporaryFolder) throws Exception {
        MailetContainer.Builder mailets = TemporaryJamesServer.defaultMailetContainerConfiguration().putProcessor(ProcessorConfiguration.transport().addMailet(MailetConfiguration.builder().matcher(All.class).mailet(SpamAssassin.class)).addMailetsFrom(CommonProcessors.deliverOnlyTransport()));
        this.jamesServer = TemporaryJamesServer.builder().withBase(MemoryJamesServerMain.SMTP_AND_IMAP_MODULE).withMailetContainer(mailets).withOverrides(new Module[]{new Module(){

            public void configure(Binder binder) {
            }

            @Provides
            @Singleton
            private SpamAssassinConfiguration provideSpamAssassinConfiguration() {
                return new SpamAssassinConfiguration(Host.parseConfString((String)"localhost", (int)spamAssassinContainer.getMappedPort(783)));
            }
        }}).build(temporaryFolder);
        this.jamesServer.start();
        ((DataProbeImpl)this.jamesServer.getProbe(DataProbeImpl.class)).fluent().addDomain("james.org").addUser("user@james.org", "secret").addUser("user2@james.org", "secret").addUser("user3@james.org", "secret");
    }

    @AfterEach
    void tearDown() {
        this.jamesServer.shutdown();
    }

    @Test
    void spamAssassinShouldAppendNewHeaderOnMessage() throws Exception {
        this.messageSender.connect("127.0.0.1", ((SmtpGuiceProbe)this.jamesServer.getProbe(SmtpGuiceProbe.class)).getSmtpPort()).authenticate("user@james.org", "secret").sendMessage(this.mailWithContent("This is the content", "user2@james.org"));
        this.messageReader.connect("127.0.0.1", ((ImapGuiceProbe)this.jamesServer.getProbe(ImapGuiceProbe.class)).getImapPort()).login("user2@james.org", "secret").select("INBOX").awaitMessage(Constants.awaitAtMostOneMinute);
        Assertions.assertThat((String)this.messageReader.readFirstMessageHeaders()).contains(new CharSequence[]{SpamAssassinResult.FLAG_MAIL.asString(), SpamAssassinResult.STATUS_MAIL.asString()});
    }

    @Test
    void spamAssassinShouldAppendNewHeaderWhichDetectIsSpamWhenSpamMessage() throws Exception {
        this.messageSender.connect("127.0.0.1", ((SmtpGuiceProbe)this.jamesServer.getProbe(SmtpGuiceProbe.class)).getSmtpPort()).authenticate("user@james.org", "secret").sendMessage(this.mailWithContent(SPAM_CONTENT, "user2@james.org"));
        this.messageReader.connect("127.0.0.1", ((ImapGuiceProbe)this.jamesServer.getProbe(ImapGuiceProbe.class)).getImapPort()).login("user2@james.org", "secret").select("INBOX").awaitMessage(Constants.awaitAtMostOneMinute);
        String receivedHeaders = this.messageReader.readFirstMessageHeaders();
        Assertions.assertThat((String)receivedHeaders).contains(new CharSequence[]{SpamAssassinResult.FLAG_MAIL.asString() + ": YES"});
        Assertions.assertThat((String)receivedHeaders).contains(new CharSequence[]{SpamAssassinResult.STATUS_MAIL.asString() + ": Yes"});
    }

    @Test
    void spamAssassinShouldAppendNewHeaderWhichNoWhenNonSpamMessage() throws Exception {
        this.messageSender.connect("127.0.0.1", ((SmtpGuiceProbe)this.jamesServer.getProbe(SmtpGuiceProbe.class)).getSmtpPort()).authenticate("user@james.org", "secret").sendMessage(this.mailWithContent("This is the content", "user2@james.org"));
        this.messageReader.connect("127.0.0.1", ((ImapGuiceProbe)this.jamesServer.getProbe(ImapGuiceProbe.class)).getImapPort()).login("user2@james.org", "secret").select("INBOX").awaitMessage(Constants.awaitAtMostOneMinute);
        String receivedHeaders = this.messageReader.readFirstMessageHeaders();
        Assertions.assertThat((String)receivedHeaders).contains(new CharSequence[]{SpamAssassinResult.FLAG_MAIL.asString() + ": NO"});
        Assertions.assertThat((String)receivedHeaders).contains(new CharSequence[]{SpamAssassinResult.STATUS_MAIL.asString() + ": No"});
    }

    @Test
    void spamAssassinShouldAppendNewHeaderPerRecipientOnMessage() throws Exception {
        this.messageSender.connect("127.0.0.1", ((SmtpGuiceProbe)this.jamesServer.getProbe(SmtpGuiceProbe.class)).getSmtpPort()).authenticate("user@james.org", "secret").sendMessage(this.mailWithContent("This is the content", "user2@james.org", "user3@james.org"));
        this.messageReader.connect("127.0.0.1", ((ImapGuiceProbe)this.jamesServer.getProbe(ImapGuiceProbe.class)).getImapPort()).login("user2@james.org", "secret").select("INBOX").awaitMessage(Constants.awaitAtMostOneMinute);
        Assertions.assertThat((String)this.messageReader.readFirstMessageHeaders()).contains(new CharSequence[]{SpamAssassinResult.FLAG_MAIL.asString(), SpamAssassinResult.STATUS_MAIL.asString()});
        this.messageReader.disconnect().connect("127.0.0.1", ((ImapGuiceProbe)this.jamesServer.getProbe(ImapGuiceProbe.class)).getImapPort()).login("user3@james.org", "secret").select("INBOX").awaitMessage(Constants.awaitAtMostOneMinute);
        Assertions.assertThat((String)this.messageReader.readFirstMessageHeaders()).contains(new CharSequence[]{SpamAssassinResult.FLAG_MAIL.asString(), SpamAssassinResult.STATUS_MAIL.asString()});
    }

    private FakeMail.Builder mailWithContent(String textContent, String ... recipients) throws MessagingException {
        return FakeMail.builder().name("name").mimeMessage(MimeMessageBuilder.mimeMessageBuilder().setSender("user@james.org").addToRecipient(recipients).setSubject("This is the subject").setText(textContent)).sender("user@james.org").recipients(recipients);
    }
}

