/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.spamassassin;

import com.github.fge.lambdas.Throwing;
import com.google.common.collect.ImmutableMap;
import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.Duration;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.Future;
import java.util.function.Consumer;
import java.util.stream.Stream;
import org.apache.james.util.docker.RateLimiters;
import org.junit.jupiter.api.extension.AfterEachCallback;
import org.junit.jupiter.api.extension.BeforeAllCallback;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.ParameterContext;
import org.junit.jupiter.api.extension.ParameterResolutionException;
import org.junit.jupiter.api.extension.ParameterResolver;
import org.reactivestreams.Publisher;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.containers.wait.strategy.HostPortWaitStrategy;
import org.testcontainers.images.builder.ImageFromDockerfile;
import org.testcontainers.utility.Base58;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.core.scheduler.Schedulers;

public class SpamAssassinExtension
implements BeforeAllCallback,
AfterEachCallback,
ParameterResolver {
    private static final Duration STARTUP_TIMEOUT = Duration.ofMinutes(30L);
    private static final String UNIQUE_IDENTIFIER = Base58.randomString((int)16).toLowerCase();
    private static final boolean DELETE_ON_EXIT = false;
    private static final GenericContainer<?> spamAssassinContainer = new GenericContainer((Future)((ImageFromDockerfile)((ImageFromDockerfile)((ImageFromDockerfile)((ImageFromDockerfile)((ImageFromDockerfile)new ImageFromDockerfile("james-spamassassin/" + UNIQUE_IDENTIFIER, false).withFileFromClasspath("Dockerfile", "docker/spamassassin/Dockerfile")).withFileFromClasspath("local.cf", "docker/spamassassin/local.cf")).withFileFromClasspath("run.sh", "docker/spamassassin/run.sh")).withFileFromClasspath("spamd.sh", "docker/spamassassin/spamd.sh")).withFileFromClasspath("rule-update.sh", "docker/spamassassin/rule-update.sh")).withFileFromClasspath("bayes_pg.sql", "docker/spamassassin/bayes_pg.sql")).withCreateContainerCmdModifier(cmd -> cmd.withName("spam-assassin-" + UUID.randomUUID().toString())).withStartupTimeout(STARTUP_TIMEOUT).withExposedPorts(new Integer[]{783}).withTmpFs((Map)ImmutableMap.of((Object)"/var/lib/postgresql/data", (Object)"rw,noexec,nosuid,size=200m")).waitingFor(new HostPortWaitStrategy().withRateLimiter(RateLimiters.TWENTIES_PER_SECOND));
    private SpamAssassin spamAssassin;

    public void beforeAll(ExtensionContext context) {
        this.spamAssassin = new SpamAssassin(spamAssassinContainer);
    }

    public void afterEach(ExtensionContext context) {
        this.clearSpamAssassinDatabase();
    }

    private void clearSpamAssassinDatabase() {
        try {
            this.spamAssassin.clearSpamAssassinDatabase();
        }
        catch (IOException | InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    public boolean supportsParameter(ParameterContext parameterContext, ExtensionContext extensionContext) throws ParameterResolutionException {
        return parameterContext.getParameter().getType() == SpamAssassin.class;
    }

    public Object resolveParameter(ParameterContext parameterContext, ExtensionContext extensionContext) throws ParameterResolutionException {
        return this.spamAssassin;
    }

    public SpamAssassin getSpamAssassin() {
        return this.spamAssassin;
    }

    static {
        spamAssassinContainer.start();
    }

    public static class SpamAssassin {
        private static final int SPAMASSASSIN_PORT = 783;
        private final String ip;
        private final int bindingPort;
        private final GenericContainer<?> spamAssassinContainer;

        private SpamAssassin(GenericContainer<?> spamAssassinContainer) {
            this.spamAssassinContainer = spamAssassinContainer;
            this.ip = spamAssassinContainer.getContainerIpAddress();
            this.bindingPort = spamAssassinContainer.getMappedPort(783);
        }

        public String getIp() {
            return this.ip;
        }

        public int getBindingPort() {
            return this.bindingPort;
        }

        public void train(String user) throws IOException, URISyntaxException {
            Path spamPath = Paths.get(ClassLoader.getSystemResource("spamassassin_db/spam").toURI());
            Path hamPath = Paths.get(ClassLoader.getSystemResource("spamassassin_db/ham").toURI());
            Flux.merge((Publisher[])new Publisher[]{Mono.fromRunnable((Runnable)Throwing.runnable(() -> this.train(user, spamPath, TrainingKind.SPAM))), Mono.fromRunnable((Runnable)Throwing.runnable(() -> this.train(user, hamPath, TrainingKind.HAM)))}).subscribeOn(Schedulers.boundedElastic()).blockLast();
        }

        private void train(String user, Path folder, TrainingKind trainingKind) throws IOException {
            this.spamAssassinContainer.getDockerClient().copyArchiveToContainerCmd(this.spamAssassinContainer.getContainerId()).withHostResource(folder.toAbsolutePath().toString()).withRemotePath("/root").exec();
            try (Stream<Path> paths = Files.walk(folder, new FileVisitOption[0]);){
                ((Stream)paths.parallel()).filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).map(Path::toFile).forEach((Consumer<File>)Throwing.consumer(file -> this.spamAssassinContainer.execInContainer(new String[]{"sa-learn", trainingKind.saLearnExtensionName(), "-u", user, "/root/" + trainingKind.name().toLowerCase(Locale.US) + "/" + file.getName()})));
            }
        }

        public void sync(String user) throws UnsupportedOperationException, IOException, InterruptedException {
            this.spamAssassinContainer.execInContainer(new String[]{"sa-learn", "--sync", "-u", user});
        }

        public void dump(String user) throws UnsupportedOperationException, IOException, InterruptedException {
            this.spamAssassinContainer.execInContainer(new String[]{"sa-learn", "--dump", "magic", "-u", user});
        }

        public void clear(String user) throws UnsupportedOperationException, IOException, InterruptedException {
            this.spamAssassinContainer.execInContainer(new String[]{"sa-learn", "--clear", "-u", user});
        }

        public void clearSpamAssassinDatabase() throws UnsupportedOperationException, IOException, InterruptedException {
            this.spamAssassinContainer.execInContainer(new String[]{"sa-learn", "--clear"});
        }

        private static enum TrainingKind {
            SPAM("--spam"),
            HAM("--ham");

            private String saLearnExtensionName;

            private TrainingKind(String saLearnExtensionName) {
                this.saLearnExtensionName = saLearnExtensionName;
            }

            public String saLearnExtensionName() {
                return this.saLearnExtensionName;
            }
        }
    }
}

