/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.spamassassin;

import io.restassured.RestAssured;
import io.restassured.builder.RequestSpecBuilder;
import io.restassured.config.EncoderConfig;
import io.restassured.config.RestAssuredConfig;
import io.restassured.http.ContentType;
import io.restassured.parsing.Parser;
import io.restassured.response.Response;
import io.restassured.response.ValidatableResponse;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import org.apache.http.client.utils.URIBuilder;
import org.apache.james.GuiceJamesServer;
import org.apache.james.core.Username;
import org.apache.james.jmap.AccessToken;
import org.apache.james.jmap.HttpJmapAuthentication;
import org.apache.james.jmap.JMAPTestingConstants;
import org.apache.james.jmap.LocalHostURIBuilder;
import org.apache.james.jmap.draft.JmapGuiceProbe;
import org.apache.james.mailbox.Role;
import org.apache.james.modules.protocols.ImapGuiceProbe;
import org.apache.james.spamassassin.SpamAssassinExtension;
import org.apache.james.util.Port;
import org.apache.james.utils.DataProbeImpl;
import org.apache.james.utils.SpoolerProbe;
import org.apache.james.utils.TestIMAPClient;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.Assertions;
import org.awaitility.Durations;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public interface SpamAssassinContract {
    public static final String BOBS_DOMAIN = "spamer.com";
    public static final String BOB = "bob@spamer.com";
    public static final String BOB_PASSWORD = "bobPassword";
    public static final String RECIPIENTS_DOMAIN = "angels.org";
    public static final String ALICE = "alice@angels.org";
    public static final String ALICE_PASSWORD = "alicePassword";
    public static final String PAUL = "paul@angels.org";
    public static final String PAUL_PASSWORD = "paulPassword";

    @BeforeEach
    default public void setup(GuiceJamesServer jamesServer) throws Throwable {
        RestAssured.requestSpecification = new RequestSpecBuilder().setContentType(ContentType.JSON).setAccept(ContentType.JSON).setConfig(RestAssuredConfig.newConfig().encoderConfig(EncoderConfig.encoderConfig().defaultContentCharset(StandardCharsets.UTF_8))).setPort(((JmapGuiceProbe)jamesServer.getProbe(JmapGuiceProbe.class)).getJmapPort().getValue()).build();
        RestAssured.defaultParser = Parser.JSON;
        ((DataProbeImpl)jamesServer.getProbe(DataProbeImpl.class)).fluent().addDomain(BOBS_DOMAIN).addDomain(RECIPIENTS_DOMAIN).addUser(BOB, BOB_PASSWORD).addUser(ALICE, ALICE_PASSWORD).addUser(PAUL, PAUL_PASSWORD);
    }

    @AfterEach
    default public void tearDown(SpamAssassinExtension.SpamAssassin spamAssassin, GuiceJamesServer jamesServer) throws Exception {
        JMAPTestingConstants.calmlyAwait.atMost(Durations.ONE_MINUTE).untilAsserted(() -> this.assertEveryListenerGotCalled(jamesServer));
        spamAssassin.clear(ALICE);
    }

    default public AccessToken accessTokenFor(GuiceJamesServer james, String user, String password) {
        return HttpJmapAuthentication.authenticateJamesUser((URIBuilder)this.baseUri(james), (Username)Username.of((String)user), (String)password);
    }

    @Test
    default public void spamShouldBeDeliveredInSpamMailboxWhenSameMessageHasAlreadyBeenMovedToSpam(GuiceJamesServer jamesServer, SpamAssassinExtension.SpamAssassin spamAssassin) throws Exception {
        spamAssassin.train(ALICE);
        AccessToken aliceAccessToken = this.accessTokenFor(jamesServer, ALICE, ALICE_PASSWORD);
        AccessToken bobAccessToken = this.accessTokenFor(jamesServer, BOB, BOB_PASSWORD);
        RestAssured.given().header("Authorization", (Object)bobAccessToken.asString(), new Object[0]).body(this.setMessageCreate(bobAccessToken)).when().post("/jmap", new Object[0]);
        JMAPTestingConstants.calmlyAwait.atMost(Durations.ONE_MINUTE).untilAsserted(() -> this.assertMessagesFoundInMailbox(aliceAccessToken, this.getInboxId(aliceAccessToken), 1));
        JMAPTestingConstants.calmlyAwait.atMost(Durations.ONE_MINUTE).untilAsserted(() -> this.assertEveryListenerGotCalled(jamesServer));
        List messageIds = (List)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.with().header("Authorization", (Object)aliceAccessToken.asString(), new Object[0]).body("[[\"getMessageList\", {\"filter\":{\"inMailboxes\":[\"" + this.getInboxId(aliceAccessToken) + "\"]}}, \"#0\"]]").when().post("/jmap", new Object[0])).then()).statusCode(200)).body("[0][0]", Matchers.equalTo((Object)"messageList"), new Object[0])).body("[0][1].messageIds", Matchers.hasSize((int)1), new Object[0])).extract().path("[0][1].messageIds", new String[0]);
        messageIds.parallelStream().forEach(messageId -> ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().header("Authorization", (Object)aliceAccessToken.asString(), new Object[0]).body(String.format("[[\"setMessages\", {\"update\": {\"%s\" : { \"mailboxIds\": [\"" + this.getSpamId(aliceAccessToken) + "\"] } } }, \"#0\"]]", messageId)).when().post("/jmap", new Object[0])).then()).statusCode(200)).body("[0][0]", Matchers.equalTo((Object)"messagesSet"), new Object[0])).body("[0][1].updated", Matchers.hasSize((int)1), new Object[0]));
        JMAPTestingConstants.calmlyAwait.atMost(Durations.ONE_MINUTE).untilAsserted(() -> this.assertMessagesFoundInMailbox(aliceAccessToken, this.getSpamId(aliceAccessToken), 1));
        RestAssured.given().header("Authorization", (Object)bobAccessToken.asString(), new Object[0]).body(this.setMessageCreate(bobAccessToken)).when().post("/jmap", new Object[0]);
        JMAPTestingConstants.calmlyAwait.atMost(Durations.ONE_MINUTE).untilAsserted(() -> this.assertMessagesFoundInMailbox(aliceAccessToken, this.getSpamId(aliceAccessToken), 2));
    }

    @Test
    default public void imapCopiesToSpamMailboxShouldBeConsideredAsSpam(GuiceJamesServer jamesServer, SpamAssassinExtension.SpamAssassin spamAssassin) throws Exception {
        spamAssassin.train(ALICE);
        AccessToken aliceAccessToken = this.accessTokenFor(jamesServer, ALICE, ALICE_PASSWORD);
        AccessToken bobAccessToken = this.accessTokenFor(jamesServer, BOB, BOB_PASSWORD);
        RestAssured.given().header("Authorization", (Object)bobAccessToken.asString(), new Object[0]).body(this.setMessageCreate(bobAccessToken)).when().post("/jmap", new Object[0]);
        JMAPTestingConstants.calmlyAwait.atMost(Durations.ONE_MINUTE).untilAsserted(() -> this.assertMessagesFoundInMailbox(aliceAccessToken, this.getInboxId(aliceAccessToken), 1));
        JMAPTestingConstants.calmlyAwait.atMost(Durations.ONE_MINUTE).untilAsserted(() -> this.assertEveryListenerGotCalled(jamesServer));
        try (TestIMAPClient testIMAPClient = new TestIMAPClient();){
            testIMAPClient.connect("127.0.0.1", ((ImapGuiceProbe)jamesServer.getProbe(ImapGuiceProbe.class)).getImapPort()).login(ALICE, ALICE_PASSWORD).select("INBOX");
            testIMAPClient.copyFirstMessage("Spam");
        }
        JMAPTestingConstants.calmlyAwait.atMost(Durations.ONE_MINUTE).untilAsserted(() -> this.assertMessagesFoundInMailbox(aliceAccessToken, this.getSpamId(aliceAccessToken), 1));
        RestAssured.given().header("Authorization", (Object)bobAccessToken.asString(), new Object[0]).body(this.setMessageCreate(bobAccessToken)).when().post("/jmap", new Object[0]);
        JMAPTestingConstants.calmlyAwait.atMost(Durations.ONE_MINUTE).untilAsserted(() -> this.assertMessagesFoundInMailbox(aliceAccessToken, this.getSpamId(aliceAccessToken), 2));
    }

    @Test
    default public void imapMovesToSpamMailboxShouldBeConsideredAsSpam(GuiceJamesServer jamesServer, SpamAssassinExtension.SpamAssassin spamAssassin) throws Exception {
        spamAssassin.train(ALICE);
        AccessToken aliceAccessToken = this.accessTokenFor(jamesServer, ALICE, ALICE_PASSWORD);
        AccessToken bobAccessToken = this.accessTokenFor(jamesServer, BOB, BOB_PASSWORD);
        RestAssured.given().header("Authorization", (Object)bobAccessToken.asString(), new Object[0]).body(this.setMessageCreate(bobAccessToken)).when().post("/jmap", new Object[0]);
        JMAPTestingConstants.calmlyAwait.atMost(Durations.ONE_MINUTE).untilAsserted(() -> this.assertMessagesFoundInMailbox(aliceAccessToken, this.getInboxId(aliceAccessToken), 1));
        JMAPTestingConstants.calmlyAwait.atMost(Durations.ONE_MINUTE).untilAsserted(() -> this.assertEveryListenerGotCalled(jamesServer));
        try (TestIMAPClient testIMAPClient = new TestIMAPClient();){
            testIMAPClient.connect("127.0.0.1", ((ImapGuiceProbe)jamesServer.getProbe(ImapGuiceProbe.class)).getImapPort()).login(ALICE, ALICE_PASSWORD).select("INBOX");
            testIMAPClient.moveFirstMessage("Spam");
        }
        JMAPTestingConstants.calmlyAwait.atMost(Durations.ONE_MINUTE).untilAsserted(() -> this.assertMessagesFoundInMailbox(aliceAccessToken, this.getSpamId(aliceAccessToken), 1));
        RestAssured.given().header("Authorization", (Object)bobAccessToken.asString(), new Object[0]).body(this.setMessageCreate(bobAccessToken)).when().post("/jmap", new Object[0]);
        JMAPTestingConstants.calmlyAwait.atMost(Durations.ONE_MINUTE).untilAsserted(() -> this.assertMessagesFoundInMailbox(aliceAccessToken, this.getSpamId(aliceAccessToken), 2));
    }

    @Test
    default public void spamAssassinShouldForgetMessagesMovedOutOfSpamFolderUsingJMAP(GuiceJamesServer jamesServer, SpamAssassinExtension.SpamAssassin spamAssassin) throws Exception {
        spamAssassin.train(ALICE);
        AccessToken aliceAccessToken = this.accessTokenFor(jamesServer, ALICE, ALICE_PASSWORD);
        AccessToken bobAccessToken = this.accessTokenFor(jamesServer, BOB, BOB_PASSWORD);
        RestAssured.given().header("Authorization", (Object)bobAccessToken.asString(), new Object[0]).body(this.setMessageCreate(bobAccessToken)).when().post("/jmap", new Object[0]);
        JMAPTestingConstants.calmlyAwait.atMost(Durations.ONE_MINUTE).untilAsserted(() -> this.assertMessagesFoundInMailbox(aliceAccessToken, this.getInboxId(aliceAccessToken), 1));
        JMAPTestingConstants.calmlyAwait.atMost(Durations.ONE_MINUTE).untilAsserted(() -> this.assertEveryListenerGotCalled(jamesServer));
        List messageIds = (List)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.with().header("Authorization", (Object)aliceAccessToken.asString(), new Object[0]).body("[[\"getMessageList\", {\"filter\":{\"inMailboxes\":[\"" + this.getInboxId(aliceAccessToken) + "\"]}}, \"#0\"]]").when().post("/jmap", new Object[0])).then()).statusCode(200)).body("[0][0]", Matchers.equalTo((Object)"messageList"), new Object[0])).body("[0][1].messageIds", Matchers.hasSize((int)1), new Object[0])).extract().path("[0][1].messageIds", new String[0]);
        messageIds.parallelStream().forEach(messageId -> ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().header("Authorization", (Object)aliceAccessToken.asString(), new Object[0]).body(String.format("[[\"setMessages\", {\"update\": {\"%s\" : { \"mailboxIds\": [\"" + this.getSpamId(aliceAccessToken) + "\"] } } }, \"#0\"]]", messageId)).when().post("/jmap", new Object[0])).then()).statusCode(200)).body("[0][0]", Matchers.equalTo((Object)"messagesSet"), new Object[0])).body("[0][1].updated", Matchers.hasSize((int)1), new Object[0]));
        JMAPTestingConstants.calmlyAwait.atMost(Durations.ONE_MINUTE).untilAsserted(() -> this.assertMessagesFoundInMailbox(aliceAccessToken, this.getSpamId(aliceAccessToken), 1));
        messageIds.forEach(messageId -> ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().header("Authorization", (Object)aliceAccessToken.asString(), new Object[0]).body(String.format("[[\"setMessages\", {\"update\": {\"%s\" : { \"mailboxIds\": [\"" + this.getInboxId(aliceAccessToken) + "\"] } } }, \"#0\"]]", messageId)).when().post("/jmap", new Object[0])).then()).statusCode(200)).body("[0][0]", Matchers.equalTo((Object)"messagesSet"), new Object[0])).body("[0][1].updated", Matchers.hasSize((int)1), new Object[0]));
        JMAPTestingConstants.calmlyAwait.atMost(Durations.ONE_MINUTE).untilAsserted(() -> this.assertMessagesFoundInMailbox(aliceAccessToken, this.getInboxId(aliceAccessToken), 1));
        RestAssured.given().header("Authorization", (Object)bobAccessToken.asString(), new Object[0]).body(this.setMessageCreate(bobAccessToken)).when().post("/jmap", new Object[0]);
        JMAPTestingConstants.calmlyAwait.atMost(Durations.ONE_MINUTE).untilAsserted(() -> this.assertMessagesFoundInMailbox(aliceAccessToken, this.getInboxId(aliceAccessToken), 2));
    }

    @Test
    default public void movingAMailToTrashShouldNotImpactSpamassassinLearning(GuiceJamesServer jamesServer, SpamAssassinExtension.SpamAssassin spamAssassin) throws Exception {
        spamAssassin.train(ALICE);
        AccessToken aliceAccessToken = this.accessTokenFor(jamesServer, ALICE, ALICE_PASSWORD);
        AccessToken bobAccessToken = this.accessTokenFor(jamesServer, BOB, BOB_PASSWORD);
        RestAssured.given().header("Authorization", (Object)bobAccessToken.asString(), new Object[0]).body(this.setMessageCreate(bobAccessToken)).when().post("/jmap", new Object[0]);
        JMAPTestingConstants.calmlyAwait.atMost(Durations.ONE_MINUTE).untilAsserted(() -> this.assertMessagesFoundInMailbox(aliceAccessToken, this.getInboxId(aliceAccessToken), 1));
        JMAPTestingConstants.calmlyAwait.atMost(Durations.ONE_MINUTE).untilAsserted(() -> this.assertEveryListenerGotCalled(jamesServer));
        List messageIds = (List)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.with().header("Authorization", (Object)aliceAccessToken.asString(), new Object[0]).body("[[\"getMessageList\", {\"filter\":{\"inMailboxes\":[\"" + this.getInboxId(aliceAccessToken) + "\"]}}, \"#0\"]]").when().post("/jmap", new Object[0])).then()).statusCode(200)).body("[0][0]", Matchers.equalTo((Object)"messageList"), new Object[0])).body("[0][1].messageIds", Matchers.hasSize((int)1), new Object[0])).extract().path("[0][1].messageIds", new String[0]);
        messageIds.parallelStream().forEach(messageId -> ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().header("Authorization", (Object)aliceAccessToken.asString(), new Object[0]).body(String.format("[[\"setMessages\", {\"update\": {\"%s\" : { \"mailboxIds\": [\"" + this.getSpamId(aliceAccessToken) + "\"] } } }, \"#0\"]]", messageId)).when().post("/jmap", new Object[0])).then()).statusCode(200)).body("[0][0]", Matchers.equalTo((Object)"messagesSet"), new Object[0])).body("[0][1].updated", Matchers.hasSize((int)1), new Object[0]));
        JMAPTestingConstants.calmlyAwait.atMost(Durations.ONE_MINUTE).untilAsserted(() -> this.assertMessagesFoundInMailbox(aliceAccessToken, this.getSpamId(aliceAccessToken), 1));
        messageIds.forEach(messageId -> ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().header("Authorization", (Object)aliceAccessToken.asString(), new Object[0]).body(String.format("[[\"setMessages\", {\"update\": {\"%s\" : { \"mailboxIds\": [\"" + this.getTrashId(aliceAccessToken) + "\"] } } }, \"#0\"]]", messageId)).when().post("/jmap", new Object[0])).then()).statusCode(200)).body("[0][0]", Matchers.equalTo((Object)"messagesSet"), new Object[0])).body("[0][1].updated", Matchers.hasSize((int)1), new Object[0]));
        JMAPTestingConstants.calmlyAwait.atMost(Durations.ONE_MINUTE).untilAsserted(() -> this.assertMessagesFoundInMailbox(aliceAccessToken, this.getTrashId(aliceAccessToken), 1));
        RestAssured.given().header("Authorization", (Object)bobAccessToken.asString(), new Object[0]).body(this.setMessageCreate(bobAccessToken)).when().post("/jmap", new Object[0]);
        JMAPTestingConstants.calmlyAwait.atMost(Durations.ONE_MINUTE).untilAsserted(() -> this.assertMessagesFoundInMailbox(aliceAccessToken, this.getSpamId(aliceAccessToken), 1));
    }

    @Test
    default public void spamAssassinShouldForgetMessagesMovedOutOfSpamFolderUsingIMAP(GuiceJamesServer jamesServer, SpamAssassinExtension.SpamAssassin spamAssassin) throws Exception {
        spamAssassin.train(ALICE);
        AccessToken aliceAccessToken = this.accessTokenFor(jamesServer, ALICE, ALICE_PASSWORD);
        AccessToken bobAccessToken = this.accessTokenFor(jamesServer, BOB, BOB_PASSWORD);
        RestAssured.given().header("Authorization", (Object)bobAccessToken.asString(), new Object[0]).body(this.setMessageCreate(bobAccessToken)).when().post("/jmap", new Object[0]);
        JMAPTestingConstants.calmlyAwait.atMost(Durations.ONE_MINUTE).untilAsserted(() -> this.assertMessagesFoundInMailbox(aliceAccessToken, this.getInboxId(aliceAccessToken), 1));
        JMAPTestingConstants.calmlyAwait.atMost(Durations.ONE_MINUTE).untilAsserted(() -> this.assertEveryListenerGotCalled(jamesServer));
        List messageIds = (List)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.with().header("Authorization", (Object)aliceAccessToken.asString(), new Object[0]).body("[[\"getMessageList\", {\"filter\":{\"inMailboxes\":[\"" + this.getInboxId(aliceAccessToken) + "\"]}}, \"#0\"]]").when().post("/jmap", new Object[0])).then()).statusCode(200)).body("[0][0]", Matchers.equalTo((Object)"messageList"), new Object[0])).body("[0][1].messageIds", Matchers.hasSize((int)1), new Object[0])).extract().path("[0][1].messageIds", new String[0]);
        messageIds.parallelStream().forEach(messageId -> ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().header("Authorization", (Object)aliceAccessToken.asString(), new Object[0]).body(String.format("[[\"setMessages\", {\"update\": {\"%s\" : { \"mailboxIds\": [\"" + this.getSpamId(aliceAccessToken) + "\"] } } }, \"#0\"]]", messageId)).when().post("/jmap", new Object[0])).then()).statusCode(200)).body("[0][0]", Matchers.equalTo((Object)"messagesSet"), new Object[0])).body("[0][1].updated", Matchers.hasSize((int)1), new Object[0]));
        JMAPTestingConstants.calmlyAwait.atMost(Durations.ONE_MINUTE).untilAsserted(() -> this.assertMessagesFoundInMailbox(aliceAccessToken, this.getSpamId(aliceAccessToken), 1));
        try (TestIMAPClient testIMAPClient = new TestIMAPClient();){
            testIMAPClient.connect("127.0.0.1", ((ImapGuiceProbe)jamesServer.getProbe(ImapGuiceProbe.class)).getImapPort()).login(ALICE, ALICE_PASSWORD).select("Spam");
            testIMAPClient.moveFirstMessage("INBOX");
        }
        JMAPTestingConstants.calmlyAwait.atMost(Durations.ONE_MINUTE).untilAsserted(() -> this.assertMessagesFoundInMailbox(aliceAccessToken, this.getInboxId(aliceAccessToken), 1));
        RestAssured.given().header("Authorization", (Object)bobAccessToken.asString(), new Object[0]).body(this.setMessageCreate(bobAccessToken)).when().post("/jmap", new Object[0]);
        JMAPTestingConstants.calmlyAwait.atMost(Durations.ONE_MINUTE).untilAsserted(() -> this.assertMessagesFoundInMailbox(aliceAccessToken, this.getInboxId(aliceAccessToken), 2));
    }

    @Test
    default public void expungingSpamMessageShouldNotImpactSpamAssassinState(GuiceJamesServer jamesServer, SpamAssassinExtension.SpamAssassin spamAssassin) throws Exception {
        spamAssassin.train(ALICE);
        AccessToken aliceAccessToken = this.accessTokenFor(jamesServer, ALICE, ALICE_PASSWORD);
        AccessToken bobAccessToken = this.accessTokenFor(jamesServer, BOB, BOB_PASSWORD);
        RestAssured.given().header("Authorization", (Object)bobAccessToken.asString(), new Object[0]).body(this.setMessageCreate(bobAccessToken)).when().post("/jmap", new Object[0]);
        JMAPTestingConstants.calmlyAwait.atMost(Durations.ONE_MINUTE).untilAsserted(() -> this.assertMessagesFoundInMailbox(aliceAccessToken, this.getInboxId(aliceAccessToken), 1));
        JMAPTestingConstants.calmlyAwait.atMost(Durations.ONE_MINUTE).untilAsserted(() -> this.assertEveryListenerGotCalled(jamesServer));
        List messageIds = (List)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.with().header("Authorization", (Object)aliceAccessToken.asString(), new Object[0]).body("[[\"getMessageList\", {\"filter\":{\"inMailboxes\":[\"" + this.getInboxId(aliceAccessToken) + "\"]}}, \"#0\"]]").when().post("/jmap", new Object[0])).then()).statusCode(200)).body("[0][0]", Matchers.equalTo((Object)"messageList"), new Object[0])).body("[0][1].messageIds", Matchers.hasSize((int)1), new Object[0])).extract().path("[0][1].messageIds", new String[0]);
        messageIds.forEach(messageId -> ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().header("Authorization", (Object)aliceAccessToken.asString(), new Object[0]).body(String.format("[[\"setMessages\", {\"update\": {\"%s\" : { \"mailboxIds\": [\"" + this.getSpamId(aliceAccessToken) + "\"] } } }, \"#0\"]]", messageId)).when().post("/jmap", new Object[0])).then()).statusCode(200)).body("[0][0]", Matchers.equalTo((Object)"messagesSet"), new Object[0])).body("[0][1].updated", Matchers.hasSize((int)1), new Object[0]));
        JMAPTestingConstants.calmlyAwait.atMost(Durations.ONE_MINUTE).untilAsserted(() -> this.assertMessagesFoundInMailbox(aliceAccessToken, this.getSpamId(aliceAccessToken), 1));
        try (TestIMAPClient testIMAPClient = new TestIMAPClient();){
            testIMAPClient.connect("127.0.0.1", ((ImapGuiceProbe)jamesServer.getProbe(ImapGuiceProbe.class)).getImapPort()).login(ALICE, ALICE_PASSWORD).select("Spam");
            testIMAPClient.setFlagsForAllMessagesInMailbox("\\Deleted");
            testIMAPClient.expunge();
        }
        JMAPTestingConstants.calmlyAwait.atMost(Durations.ONE_MINUTE).untilAsserted(() -> this.assertMessagesFoundInMailbox(aliceAccessToken, this.getSpamId(aliceAccessToken), 0));
        RestAssured.given().header("Authorization", (Object)bobAccessToken.asString(), new Object[0]).body(this.setMessageCreate(bobAccessToken)).when().post("/jmap", new Object[0]);
        JMAPTestingConstants.calmlyAwait.atMost(Durations.ONE_MINUTE).untilAsserted(() -> this.assertMessagesFoundInMailbox(aliceAccessToken, this.getSpamId(aliceAccessToken), 1));
    }

    @Test
    default public void deletingSpamMessageShouldNotImpactSpamAssassinState(GuiceJamesServer jamesServer, SpamAssassinExtension.SpamAssassin spamAssassin) throws Exception {
        spamAssassin.train(ALICE);
        AccessToken aliceAccessToken = this.accessTokenFor(jamesServer, ALICE, ALICE_PASSWORD);
        AccessToken bobAccessToken = this.accessTokenFor(jamesServer, BOB, BOB_PASSWORD);
        RestAssured.given().header("Authorization", (Object)bobAccessToken.asString(), new Object[0]).body(this.setMessageCreate(bobAccessToken)).when().post("/jmap", new Object[0]);
        JMAPTestingConstants.calmlyAwait.atMost(Durations.ONE_MINUTE).untilAsserted(() -> this.assertMessagesFoundInMailbox(aliceAccessToken, this.getInboxId(aliceAccessToken), 1));
        JMAPTestingConstants.calmlyAwait.atMost(Durations.ONE_MINUTE).untilAsserted(() -> this.assertEveryListenerGotCalled(jamesServer));
        List messageIds = (List)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.with().header("Authorization", (Object)aliceAccessToken.asString(), new Object[0]).body("[[\"getMessageList\", {\"filter\":{\"inMailboxes\":[\"" + this.getInboxId(aliceAccessToken) + "\"]}}, \"#0\"]]").when().post("/jmap", new Object[0])).then()).statusCode(200)).body("[0][0]", Matchers.equalTo((Object)"messageList"), new Object[0])).body("[0][1].messageIds", Matchers.hasSize((int)1), new Object[0])).extract().path("[0][1].messageIds", new String[0]);
        messageIds.parallelStream().forEach(messageId -> ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().header("Authorization", (Object)aliceAccessToken.asString(), new Object[0]).body(String.format("[[\"setMessages\", {\"update\": {\"%s\" : { \"mailboxIds\": [\"" + this.getSpamId(aliceAccessToken) + "\"] } } }, \"#0\"]]", messageId)).when().post("/jmap", new Object[0])).then()).statusCode(200)).body("[0][0]", Matchers.equalTo((Object)"messagesSet"), new Object[0])).body("[0][1].updated", Matchers.hasSize((int)1), new Object[0]));
        JMAPTestingConstants.calmlyAwait.atMost(Durations.ONE_MINUTE).untilAsserted(() -> this.assertMessagesFoundInMailbox(aliceAccessToken, this.getSpamId(aliceAccessToken), 1));
        messageIds.forEach(messageId -> ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().header("Authorization", (Object)aliceAccessToken.asString(), new Object[0]).body(String.format("[[\"setMessages\", {\"destroy\": [\"%s\"] }, \"#0\"]]", messageId)).when().post("/jmap", new Object[0])).then()).statusCode(200)).body("[0][0]", Matchers.equalTo((Object)"messagesSet"), new Object[0])).body("[0][1].destroyed", Matchers.hasSize((int)1), new Object[0]));
        JMAPTestingConstants.calmlyAwait.atMost(Durations.ONE_MINUTE).untilAsserted(() -> this.assertMessagesFoundInMailbox(aliceAccessToken, this.getSpamId(aliceAccessToken), 0));
        RestAssured.given().header("Authorization", (Object)bobAccessToken.asString(), new Object[0]).body(this.setMessageCreate(bobAccessToken)).when().post("/jmap", new Object[0]);
        JMAPTestingConstants.calmlyAwait.atMost(Durations.ONE_MINUTE).untilAsserted(() -> this.assertMessagesFoundInMailbox(aliceAccessToken, this.getSpamId(aliceAccessToken), 1));
    }

    default public String setMessageCreate(AccessToken accessToken) {
        return "[  [    \"setMessages\",    {      \"create\": { \"creationId1337\" : {        \"from\": { \"email\": \"bob@spamer.com\"},        \"to\": [{ \"name\": \"recipient\", \"email\": \"alice@angels.org\"}],        \"subject\": \"Happy News\",        \"textBody\": \"This is a SPAM!!!\r\n\r\n\",        \"mailboxIds\": [\"" + this.getOutboxId(accessToken) + "\"]      }}    },    \"#0\"  ]]";
    }

    @Test
    default public void spamShouldBeDeliveredInSpamMailboxOrInboxWhenMultipleRecipientsConfigurations(GuiceJamesServer jamesServer, SpamAssassinExtension.SpamAssassin spamAssassin) throws Exception {
        spamAssassin.train(ALICE);
        AccessToken aliceAccessToken = this.accessTokenFor(jamesServer, ALICE, ALICE_PASSWORD);
        AccessToken bobAccessToken = this.accessTokenFor(jamesServer, BOB, BOB_PASSWORD);
        AccessToken paulAccessToken = this.accessTokenFor(jamesServer, PAUL, PAUL_PASSWORD);
        RestAssured.given().header("Authorization", (Object)bobAccessToken.asString(), new Object[0]).body(this.setMessageCreateToMultipleRecipients(bobAccessToken)).when().post("/jmap", new Object[0]);
        JMAPTestingConstants.calmlyAwait.atMost(Durations.ONE_MINUTE).untilAsserted(() -> this.assertMessagesFoundInMailbox(aliceAccessToken, this.getInboxId(aliceAccessToken), 1));
        JMAPTestingConstants.calmlyAwait.atMost(Durations.ONE_MINUTE).untilAsserted(() -> this.assertMessagesFoundInMailbox(paulAccessToken, this.getInboxId(paulAccessToken), 1));
        List messageIds = (List)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.with().header("Authorization", (Object)aliceAccessToken.asString(), new Object[0]).body("[[\"getMessageList\", {\"filter\":{\"inMailboxes\":[\"" + this.getInboxId(aliceAccessToken) + "\"]}}, \"#0\"]]").when().post("/jmap", new Object[0])).then()).statusCode(200)).body("[0][0]", Matchers.equalTo((Object)"messageList"), new Object[0])).body("[0][1].messageIds", Matchers.hasSize((int)1), new Object[0])).extract().path("[0][1].messageIds", new String[0]);
        messageIds.parallelStream().forEach(messageId -> ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().header("Authorization", (Object)aliceAccessToken.asString(), new Object[0]).body(String.format("[[\"setMessages\", {\"update\": {\"%s\" : { \"mailboxIds\": [\"" + this.getSpamId(aliceAccessToken) + "\"] } } }, \"#0\"]]", messageId)).when().post("/jmap", new Object[0])).then()).statusCode(200)).body("[0][0]", Matchers.equalTo((Object)"messagesSet"), new Object[0])).body("[0][1].updated", Matchers.hasSize((int)1), new Object[0]));
        JMAPTestingConstants.calmlyAwait.atMost(Durations.ONE_MINUTE).untilAsserted(() -> this.assertMessagesFoundInMailbox(aliceAccessToken, this.getSpamId(aliceAccessToken), 1));
        RestAssured.given().header("Authorization", (Object)bobAccessToken.asString(), new Object[0]).body(this.setMessageCreateToMultipleRecipients(bobAccessToken)).when().post("/jmap", new Object[0]);
        JMAPTestingConstants.calmlyAwait.atMost(Durations.ONE_MINUTE).untilAsserted(() -> this.assertMessagesFoundInMailbox(aliceAccessToken, this.getSpamId(aliceAccessToken), 2));
        JMAPTestingConstants.calmlyAwait.atMost(Durations.ONE_MINUTE).untilAsserted(() -> this.assertMessagesFoundInMailbox(aliceAccessToken, this.getInboxId(aliceAccessToken), 0));
        JMAPTestingConstants.calmlyAwait.atMost(Durations.ONE_MINUTE).untilAsserted(() -> this.assertMessagesFoundInMailbox(paulAccessToken, this.getInboxId(paulAccessToken), 2));
        JMAPTestingConstants.calmlyAwait.atMost(Durations.ONE_MINUTE).untilAsserted(() -> this.assertMessagesFoundInMailbox(paulAccessToken, this.getSpamId(paulAccessToken), 0));
    }

    default public String setMessageCreateToMultipleRecipients(AccessToken accessToken) {
        return "[  [    \"setMessages\",    {      \"create\": { \"creationId1337\" : {        \"from\": { \"email\": \"bob@spamer.com\"},        \"to\": [{ \"name\": \"alice\", \"email\": \"alice@angels.org\"},                  { \"name\": \"paul\", \"email\": \"paul@angels.org\"}],        \"subject\": \"Happy News\",        \"textBody\": \"This is a SPAM!!!\r\n\r\n\",        \"mailboxIds\": [\"" + this.getOutboxId(accessToken) + "\"]      }}    },    \"#0\"  ]]";
    }

    default public void assertMessagesFoundInMailbox(AccessToken accessToken, String mailboxId, int expectedNumberOfMessages) {
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.with().header("Authorization", (Object)accessToken.asString(), new Object[0]).body("[[\"getMessageList\", {\"filter\":{\"inMailboxes\":[\"" + mailboxId + "\"]}}, \"#0\"]]").when().post("/jmap", new Object[0])).then()).statusCode(200)).body("[0][0]", Matchers.equalTo((Object)"messageList"), new Object[0])).body("[0][1].messageIds", Matchers.hasSize((int)expectedNumberOfMessages), new Object[0]);
    }

    default public String getMailboxId(AccessToken accessToken, Role role) {
        return this.getAllMailboxesIds(accessToken).stream().filter(x -> ((String)x.get("role")).equalsIgnoreCase(role.serialize())).map(x -> (String)x.get("id")).findFirst().get();
    }

    default public List<Map<String, String>> getAllMailboxesIds(AccessToken accessToken) {
        return ((Response)((Response)RestAssured.with().header("Authorization", (Object)accessToken.asString(), new Object[0]).body("[[\"getMailboxes\", {\"properties\": [\"role\", \"id\"]}, \"#0\"]]").post("/jmap", new Object[0])).andReturn()).body().jsonPath().getList("[0][1].list");
    }

    default public String getInboxId(AccessToken accessToken) {
        return this.getMailboxId(accessToken, Role.INBOX);
    }

    default public String getOutboxId(AccessToken accessToken) {
        return this.getMailboxId(accessToken, Role.OUTBOX);
    }

    default public String getSpamId(AccessToken accessToken) {
        return this.getMailboxId(accessToken, Role.SPAM);
    }

    default public String getTrashId(AccessToken accessToken) {
        return this.getMailboxId(accessToken, Role.TRASH);
    }

    default public void assertEveryListenerGotCalled(GuiceJamesServer jamesServer) {
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)((SpoolerProbe)jamesServer.getProbe(SpoolerProbe.class)).processingFinished()).describedAs("waiting that every listener get called", new Object[0])).isTrue();
    }

    private URIBuilder baseUri(GuiceJamesServer jamesServer) {
        return LocalHostURIBuilder.baseUri((Port)Port.of((int)((JmapGuiceProbe)jamesServer.getProbe(JmapGuiceProbe.class)).getJmapPort().getValue()));
    }
}

