/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.server.core;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import javax.mail.MessagingException;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.james.lifecycle.api.Disposable;
import org.apache.james.server.core.BufferedDeferredFileOutputStream;
import org.apache.james.server.core.MimeMessageSource;
import org.apache.james.util.SizeFormat;
import org.apache.james.util.io.UnsynchronizedBufferedInputStream;

public class MimeMessageInputStreamSource
extends Disposable.LeakAware<Resource>
implements MimeMessageSource {
    private static final int DEFAULT_THRESHOLD = 102400;
    private static final int THRESHOLD = MimeMessageInputStreamSource.threshold();
    private final String sourceId;

    private static int threshold() {
        return Optional.ofNullable(System.getProperty("james.message.memory.threshold")).map(SizeFormat::parseAsByteCount).map(Math::toIntExact).orElse(102400);
    }

    public static MimeMessageInputStreamSource create(String key, InputStream in) throws MessagingException {
        Disposable.LeakAware.track();
        BufferedDeferredFileOutputStream out = new BufferedDeferredFileOutputStream(THRESHOLD, "mimemessage-" + key, ".m64");
        Resource resource = new Resource(out, new HashSet<InputStream>());
        return new MimeMessageInputStreamSource(resource, key, in);
    }

    public static MimeMessageInputStreamSource create(String key) {
        Disposable.LeakAware.track();
        BufferedDeferredFileOutputStream out = new BufferedDeferredFileOutputStream(THRESHOLD, "mimemessage-" + key, ".m64");
        Resource resource = new Resource(out, new HashSet<InputStream>());
        return new MimeMessageInputStreamSource(resource, key);
    }

    private MimeMessageInputStreamSource(Resource resource, String key, InputStream in) throws MessagingException {
        super(resource);
        try {
            IOUtils.copy((InputStream)in, (OutputStream)((Object)resource.out));
            this.sourceId = key;
        }
        catch (IOException ioe) {
            File file = resource.out.getFile();
            if (file != null) {
                FileUtils.deleteQuietly((File)file);
            }
            throw new MessagingException("Unable to retrieve the data: " + ioe.getMessage(), (Exception)ioe);
        }
        finally {
            try {
                if (resource.out != null) {
                    resource.out.close();
                }
            }
            catch (IOException iOException) {}
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    private MimeMessageInputStreamSource(Resource resource, String key) {
        super(resource);
        this.sourceId = key;
    }

    @Override
    public String getSourceId() {
        return this.sourceId;
    }

    @Override
    public InputStream getInputStream() throws IOException {
        if (((Resource)this.getResource()).getOut().isInMemory()) {
            return new ByteArrayInputStream(((Resource)this.getResource()).getOut().getData());
        }
        UnsynchronizedBufferedInputStream in = new UnsynchronizedBufferedInputStream(new FileInputStream(((Resource)this.getResource()).getOut().getFile()), 2048);
        ((Resource)this.getResource()).streams.add(in);
        return in;
    }

    @Override
    public long getMessageSize() {
        return ((Resource)this.getResource()).getOut().getByteCount();
    }

    public OutputStream getWritableOutputStream() {
        return ((Resource)this.getResource()).getOut();
    }

    static class Resource
    extends Disposable.LeakAware.Resource {
        private final BufferedDeferredFileOutputStream out;
        private final Set<InputStream> streams;

        Resource(BufferedDeferredFileOutputStream out, Set<InputStream> streams) {
            super(() -> {
                for (InputStream stream : streams) {
                    try {
                        stream.close();
                    }
                    catch (IOException iOException) {}
                }
                if (out != null) {
                    try {
                        out.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    File file = out.getFile();
                    if (file != null) {
                        FileUtils.deleteQuietly((File)file);
                        file = null;
                    }
                    out.dispose();
                }
            });
            this.out = out;
            this.streams = streams;
        }

        public BufferedDeferredFileOutputStream getOut() {
            return this.out;
        }
    }
}

