/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.server.core;

import com.github.fge.lambdas.Throwing;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.primitives.Chars;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OptionalDataException;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.mail.Address;
import javax.mail.MessagingException;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.ParseException;
import org.apache.commons.lang3.RandomStringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.james.core.MailAddress;
import org.apache.james.core.MaybeSender;
import org.apache.james.core.builder.MimeMessageBuilder;
import org.apache.james.lifecycle.api.Disposable;
import org.apache.james.lifecycle.api.LifecycleUtil;
import org.apache.james.server.core.MimeMessageSource;
import org.apache.james.server.core.MimeMessageUtil;
import org.apache.james.server.core.MimeMessageWrapper;
import org.apache.mailet.Attribute;
import org.apache.mailet.AttributeName;
import org.apache.mailet.AttributeValue;
import org.apache.mailet.Mail;
import org.apache.mailet.PerRecipientHeaders;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MailImpl
implements Disposable,
Mail {
    private static final Logger LOGGER = LoggerFactory.getLogger(MailImpl.class);
    public static final long serialVersionUID = -4289663364703986260L;
    private String errorMessage;
    private String state;
    private MimeMessageWrapper message;
    private MailAddress sender;
    private Collection<MailAddress> recipients;
    private String name;
    private String remoteHost = "localhost";
    private String remoteAddr = "127.0.0.1";
    private Date lastUpdated = new Date();
    private Map<AttributeName, Attribute> attributes;
    private PerRecipientHeaders perRecipientSpecificHeaders;

    public static MailImpl duplicate(Mail mail) throws MessagingException {
        return MailImpl.duplicateWithoutMessage(mail).mimeMessage(mail.getMessage()).build();
    }

    public static Builder duplicateWithoutMessage(Mail mail) throws MessagingException {
        return MailImpl.builder().name(MailImpl.deriveNewName(mail.getName())).sender(mail.getMaybeSender()).addRecipients(mail.getRecipients()).remoteHost(mail.getRemoteHost()).remoteAddr(mail.getRemoteAddr()).lastUpdated(mail.getLastUpdated()).errorMessage(mail.getErrorMessage()).addAttributes((Collection<Attribute>)MailImpl.duplicateAttributes(mail)).addAllHeadersForRecipients(mail.getPerRecipientSpecificHeaders());
    }

    private static ImmutableList<Attribute> duplicateAttributes(Mail mail) {
        try {
            return (ImmutableList)mail.attributes().map(Attribute::duplicate).collect(ImmutableList.toImmutableList());
        }
        catch (IllegalStateException e) {
            LOGGER.error("Error while cloning Mail attributes", (Throwable)e);
            return ImmutableList.of();
        }
    }

    public static MailImpl fromMimeMessage(String name, MimeMessage mimeMessage) throws MessagingException {
        return MailImpl.builder().name(name).sender(MailImpl.getSender(mimeMessage)).addRecipients((Collection<MailAddress>)MailImpl.getRecipients(mimeMessage)).mimeMessage(mimeMessage).build();
    }

    public static RequireName builder() {
        return x$0 -> new Builder(x$0);
    }

    private static Map<AttributeName, Attribute> toAttributeMap(Map<String, ?> attributes) {
        return attributes.entrySet().stream().map(entry -> Attribute.convertToAttribute((String)((String)entry.getKey()), entry.getValue())).collect(Collectors.toMap(Attribute::getName, Function.identity()));
    }

    private static ImmutableList<MailAddress> getRecipients(MimeMessage mimeMessage) throws MessagingException {
        return (ImmutableList)Arrays.stream(mimeMessage.getAllRecipients()).map(Throwing.function(MailImpl::castToMailAddress).sneakyThrow()).collect(ImmutableList.toImmutableList());
    }

    private static MailAddress getSender(MimeMessage mimeMessage) throws MessagingException {
        Address[] sender = mimeMessage.getFrom();
        Preconditions.checkArgument((sender.length == 1 ? 1 : 0) != 0);
        return MailImpl.castToMailAddress(sender[0]);
    }

    private static MailAddress castToMailAddress(Address address) throws AddressException {
        Preconditions.checkArgument((boolean)(address instanceof InternetAddress));
        return new MailAddress((InternetAddress)address);
    }

    @VisibleForTesting
    static String deriveNewName(String currentName) throws MessagingException {
        char separator = '!';
        int loopThreshold = 7;
        int suffixLength = 9;
        int suffixMaxLength = loopThreshold * suffixLength;
        int nameMaxLength = suffixMaxLength + 13;
        MailImpl.detectPossibleLoop(currentName, loopThreshold, separator);
        String newName = currentName + MailImpl.generateRandomSuffix(suffixLength, separator);
        return MailImpl.stripFirstCharsIfNeeded(nameMaxLength, newName);
    }

    private static String stripFirstCharsIfNeeded(int nameMaxLength, String newName) {
        return newName.substring(Math.max(0, newName.length() - nameMaxLength));
    }

    private static String generateRandomSuffix(int suffixLength, char separator) {
        return "-" + separator + RandomStringUtils.randomNumeric((int)(suffixLength - 2));
    }

    private static void detectPossibleLoop(String currentName, int loopThreshold, char separator) throws MessagingException {
        long occurrences = currentName.chars().filter(c -> Chars.saturatedCast((long)c) == separator).count();
        if (occurrences > (long)loopThreshold) {
            throw new MessagingException("Unable to create a new message name: too long. Possible loop in config.xml.");
        }
    }

    private MailImpl(String name, String state, Map<AttributeName, Attribute> attributes, List<MailAddress> recipients, PerRecipientHeaders perRecipientHeaders) {
        this.setName(name);
        this.setState(state);
        this.setAttributes(attributes);
        this.setRecipients(recipients);
        this.perRecipientSpecificHeaders = perRecipientHeaders;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public MimeMessage getMessage() throws MessagingException {
        return this.message;
    }

    public void setName(String name) {
        Preconditions.checkNotNull((Object)name);
        Preconditions.checkArgument((!name.isEmpty() ? 1 : 0) != 0, (Object)"name must not be empty");
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public Collection<MailAddress> getRecipients() {
        return this.recipients;
    }

    public MailAddress getSender() {
        return this.sender;
    }

    public String getState() {
        return this.state;
    }

    public String getRemoteHost() {
        return this.remoteHost;
    }

    public String getRemoteAddr() {
        return this.remoteAddr;
    }

    public Date getLastUpdated() {
        return this.lastUpdated;
    }

    public long getMessageSize() throws MessagingException {
        return MimeMessageUtil.getMessageSize(this.message);
    }

    public void setErrorMessage(String msg) {
        this.errorMessage = msg;
    }

    public void setMessage(MimeMessage message) throws MessagingException {
        this.setMessageNoCopy(new MimeMessageWrapper(message));
    }

    public void setMessageNoCopy(MimeMessageWrapper message) throws MessagingException {
        if (this.message != message) {
            if (this.message != null) {
                LifecycleUtil.dispose(this.message);
            }
            this.message = message;
        }
    }

    public void setMessageContent(MimeMessageSource message) throws MessagingException {
        this.setMessageNoCopy(new MimeMessageWrapper(message));
    }

    public void setRecipients(Collection<MailAddress> recipients) {
        this.recipients = ImmutableList.copyOf(recipients);
    }

    public void setSender(MailAddress sender) {
        this.sender = sender;
    }

    public void setState(String state) {
        this.state = state;
    }

    public void setRemoteHost(String remoteHost) {
        this.remoteHost = remoteHost;
    }

    public void setRemoteAddr(String remoteAddr) {
        this.remoteAddr = remoteAddr;
    }

    public void setLastUpdated(Date lastUpdated) {
        if (lastUpdated != null) {
            lastUpdated = new Date(lastUpdated.getTime());
        }
        this.lastUpdated = lastUpdated;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        try {
            Object obj = in.readObject();
            if (obj == null) {
                this.sender = null;
            } else if (obj instanceof String) {
                this.sender = new MailAddress((String)obj);
            } else if (obj instanceof MailAddress) {
                this.sender = (MailAddress)obj;
            }
        }
        catch (ParseException pe) {
            throw new IOException("Error parsing sender address: " + pe.getMessage());
        }
        this.recipients = (Collection)in.readObject();
        this.state = (String)in.readObject();
        this.errorMessage = (String)in.readObject();
        this.name = (String)in.readObject();
        this.remoteHost = (String)in.readObject();
        this.remoteAddr = (String)in.readObject();
        this.setLastUpdated((Date)in.readObject());
        try {
            this.setAttributesUsingJsonable(in);
        }
        catch (Exception e) {
            this.setAttributesUsingJavaSerializable(in);
        }
        this.perRecipientSpecificHeaders = (PerRecipientHeaders)in.readObject();
    }

    private void setAttributesUsingJsonable(ObjectInputStream in) throws IOException, ClassNotFoundException {
        Map attributesAsJson = (Map)in.readObject();
        this.attributes = attributesAsJson.entrySet().stream().map(Throwing.function(entry -> new Attribute(AttributeName.of((String)((String)entry.getKey())), AttributeValue.fromJsonString((String)((String)entry.getValue()))))).collect(Collectors.toMap(Attribute::getName, Function.identity()));
    }

    private void setAttributesUsingJavaSerializable(ObjectInputStream in) throws IOException, ClassNotFoundException {
        try {
            this.setAttributesRaw((Map)in.readObject());
        }
        catch (OptionalDataException ode) {
            if (ode.eof) {
                this.attributes = new HashMap<AttributeName, Attribute>();
            }
            throw ode;
        }
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeObject(this.sender);
        out.writeObject(this.recipients);
        out.writeObject(this.state);
        out.writeObject(this.errorMessage);
        out.writeObject(this.name);
        out.writeObject(this.remoteHost);
        out.writeObject(this.remoteAddr);
        out.writeObject(this.lastUpdated);
        out.writeObject(this.getAttributesAsJson());
        out.writeObject(this.perRecipientSpecificHeaders);
    }

    @Override
    public void dispose() {
        LifecycleUtil.dispose(this.message);
        this.message = null;
    }

    public Map<String, Object> getAttributesRaw() {
        return this.attributes.values().stream().collect(Collectors.toMap(attribute -> attribute.getName().asString(), attribute -> attribute.getValue().value()));
    }

    private Map<String, String> getAttributesAsJson() {
        return (Map)this.attributes.values().stream().flatMap(entry -> entry.getValue().toJson().map(value -> Pair.of((Object)entry.getName().asString(), (Object)value.toString())).stream()).collect(ImmutableMap.toImmutableMap(Pair::getKey, Pair::getValue));
    }

    public void setAttributesRaw(Map<String, Object> attr) {
        this.attributes = MailImpl.toAttributeMap(attr);
    }

    private void setAttributes(Map<AttributeName, Attribute> attr) {
        this.attributes = Maps.newHashMap(attr);
    }

    public Stream<Attribute> attributes() {
        return this.attributes.values().stream();
    }

    public Serializable getAttribute(String key) {
        return this.toSerializable(this.attributes.get(AttributeName.of((String)key)));
    }

    public Optional<Attribute> getAttribute(AttributeName name) {
        return Optional.ofNullable(this.attributes.get(name));
    }

    public Serializable setAttribute(String key, Serializable object) {
        Preconditions.checkNotNull((Object)key, (Object)"Key of an attribute should not be null");
        Attribute attribute = Attribute.convertToAttribute((String)key, (Object)object);
        Attribute previous = this.attributes.put(attribute.getName(), attribute);
        return this.toSerializable(previous);
    }

    public Optional<Attribute> setAttribute(Attribute attribute) {
        Preconditions.checkNotNull((Object)attribute.getName().asString(), (Object)"AttributeName should not be null");
        return Optional.ofNullable(this.attributes.put(attribute.getName(), attribute));
    }

    public Serializable removeAttribute(String key) {
        return this.toSerializable(this.attributes.remove(AttributeName.of((String)key)));
    }

    public Optional<Attribute> removeAttribute(AttributeName attributeName) {
        Attribute previous = this.attributes.remove(attributeName);
        return Optional.ofNullable(previous);
    }

    public void removeAllAttributes() {
        this.attributes.clear();
    }

    public Iterator<String> getAttributeNames() {
        return this.attributes.keySet().stream().map(AttributeName::asString).iterator();
    }

    public Stream<AttributeName> attributeNames() {
        return this.attributes().map(Attribute::getName);
    }

    private Serializable toSerializable(Attribute previous) {
        return Optional.ofNullable(previous).map(Attribute::getValue).map(AttributeValue::getValue).orElse(null);
    }

    public boolean hasAttributes() {
        return !this.attributes.isEmpty();
    }

    public static String getId() {
        return "Mail" + System.currentTimeMillis() + "-" + UUID.randomUUID();
    }

    public PerRecipientHeaders getPerRecipientSpecificHeaders() {
        return this.perRecipientSpecificHeaders;
    }

    public void addSpecificHeaderForRecipient(PerRecipientHeaders.Header header, MailAddress recipient) {
        this.perRecipientSpecificHeaders.addHeaderForRecipient(header, recipient);
    }

    public void addAllSpecificHeaderForRecipient(PerRecipientHeaders perRecipientHeaders) {
        this.perRecipientSpecificHeaders.addAll(perRecipientHeaders);
    }

    public Mail duplicate() throws MessagingException {
        return MailImpl.duplicate(this);
    }

    public Map<AttributeName, Attribute> attributesMap() {
        return ImmutableMap.copyOf(this.attributes);
    }

    public static class Builder {
        private final String name;
        private Optional<MimeMessage> mimeMessage;
        private List<MailAddress> recipients;
        private Optional<MailAddress> sender;
        private Optional<String> state;
        private Optional<String> errorMessage;
        private Optional<Date> lastUpdated;
        private Map<AttributeName, Attribute> attributes;
        private Optional<String> remoteAddr;
        private Optional<String> remoteHost;
        private PerRecipientHeaders perRecipientHeaders;

        private Builder(String name) {
            Preconditions.checkNotNull((Object)name);
            Preconditions.checkArgument((!name.isEmpty() ? 1 : 0) != 0, (Object)"name must not be empty");
            this.name = name;
            this.mimeMessage = Optional.empty();
            this.recipients = Lists.newArrayList();
            this.sender = Optional.empty();
            this.state = Optional.empty();
            this.errorMessage = Optional.empty();
            this.lastUpdated = Optional.empty();
            this.attributes = Maps.newHashMap();
            this.remoteAddr = Optional.empty();
            this.remoteHost = Optional.empty();
            this.perRecipientHeaders = new PerRecipientHeaders();
        }

        public String getName() {
            return this.name;
        }

        public Builder mimeMessage(MimeMessage mimeMessage) {
            this.mimeMessage = Optional.ofNullable(mimeMessage);
            return this;
        }

        public Builder mimeMessage(MimeMessageBuilder mimeMessage) throws MessagingException {
            this.mimeMessage = Optional.ofNullable(mimeMessage.build());
            return this;
        }

        public Builder addRecipients(Collection<MailAddress> recipients) {
            this.recipients.addAll(recipients);
            return this;
        }

        public Builder addRecipients(MailAddress ... recipients) {
            return this.addRecipients((Collection<MailAddress>)ImmutableList.copyOf((Object[])recipients));
        }

        public Builder addRecipients(String ... recipients) {
            return this.addRecipients((Collection)Arrays.stream(recipients).map(Throwing.function(MailAddress::new)).collect(ImmutableList.toImmutableList()));
        }

        public Builder addRecipient(MailAddress recipient) {
            return this.addRecipients(recipient);
        }

        public Builder addRecipient(String recipient) throws AddressException {
            return this.addRecipients(recipient);
        }

        public Builder sender(MailAddress sender) {
            return this.sender(Optional.ofNullable(sender));
        }

        public Builder sender(Optional<MailAddress> sender) {
            this.sender = sender;
            return this;
        }

        public Builder sender(MaybeSender sender) {
            this.sender = sender.asOptional();
            return this;
        }

        public Builder sender(String sender) throws AddressException {
            return this.sender(new MailAddress(sender));
        }

        public Builder state(String state) {
            this.state = Optional.ofNullable(state);
            return this;
        }

        public Builder errorMessage(String errorMessage) {
            this.errorMessage = Optional.ofNullable(errorMessage);
            return this;
        }

        public Builder lastUpdated(Date lastUpdated) {
            this.lastUpdated = Optional.ofNullable(lastUpdated);
            return this;
        }

        @Deprecated
        public Builder addAttribute(String name, Serializable object) {
            return this.addAttribute(Attribute.convertToAttribute((String)name, (Object)object));
        }

        public Builder addAttribute(Attribute attribute) {
            this.attributes.put(attribute.getName(), attribute);
            return this;
        }

        public Builder addAttributes(Collection<Attribute> attributes) {
            attributes.forEach(this::addAttribute);
            return this;
        }

        public Builder remoteAddr(String remoteAddr) {
            this.remoteAddr = Optional.ofNullable(remoteAddr);
            return this;
        }

        public Builder remoteHost(String remoteHost) {
            this.remoteHost = Optional.ofNullable(remoteHost);
            return this;
        }

        public Builder addHeaderForRecipient(PerRecipientHeaders.Header header, MailAddress recipient) {
            this.perRecipientHeaders.addHeaderForRecipient(header, recipient);
            return this;
        }

        public Builder addAllHeadersForRecipients(PerRecipientHeaders perRecipientHeaders) {
            this.perRecipientHeaders.addAll(perRecipientHeaders);
            return this;
        }

        public MailImpl build() {
            MailImpl mail = new MailImpl(this.name, this.state.orElse("root"), this.attributes, this.recipients, this.perRecipientHeaders);
            this.mimeMessage.ifPresent(Throwing.consumer(mail::setMessage).sneakyThrow());
            this.sender.ifPresent(mail::setSender);
            this.errorMessage.ifPresent(mail::setErrorMessage);
            this.lastUpdated.ifPresent(mail::setLastUpdated);
            this.remoteAddr.ifPresent(mail::setRemoteAddr);
            this.remoteHost.ifPresent(mail::setRemoteHost);
            return mail;
        }
    }

    public static interface RequireName {
        public Builder name(String var1);
    }
}

