/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.server.core;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.output.ByteArrayOutputStream;
import org.apache.commons.io.output.ThresholdingOutputStream;
import org.apache.james.lifecycle.api.Disposable;

public class BufferedDeferredFileOutputStream
extends ThresholdingOutputStream
implements Disposable {
    private ByteArrayOutputStream memoryOutputStream;
    private OutputStream currentOutputStream;
    private File outputFile;
    private final String prefix;
    private final String suffix;
    private boolean closed = false;

    public BufferedDeferredFileOutputStream(int threshold, File outputFile) {
        this(threshold, outputFile, null, null);
    }

    public BufferedDeferredFileOutputStream(int threshold, String prefix, String suffix) {
        this(threshold, null, prefix, suffix);
        if (prefix == null) {
            throw new IllegalArgumentException("Temporary file prefix is missing");
        }
    }

    private BufferedDeferredFileOutputStream(int threshold, File outputFile, String prefix, String suffix) {
        super(threshold);
        this.outputFile = outputFile;
        this.memoryOutputStream = new ByteArrayOutputStream();
        this.currentOutputStream = this.memoryOutputStream;
        this.prefix = prefix;
        this.suffix = suffix;
    }

    protected OutputStream getStream() throws IOException {
        return this.currentOutputStream;
    }

    protected void thresholdReached() throws IOException {
        if (this.prefix != null) {
            this.outputFile = Files.createTempFile(this.prefix, this.suffix, new FileAttribute[0]).toFile();
        }
        FileOutputStream fos = new FileOutputStream(this.outputFile);
        try {
            this.memoryOutputStream.writeTo((OutputStream)fos);
        }
        catch (IOException e) {
            fos.close();
            throw e;
        }
        this.currentOutputStream = new BufferedOutputStream(fos, this.getThreshold());
        this.memoryOutputStream = null;
    }

    public boolean isInMemory() {
        return !this.isThresholdExceeded();
    }

    public byte[] getData() {
        if (this.memoryOutputStream != null) {
            return this.memoryOutputStream.toByteArray();
        }
        return null;
    }

    public File getFile() {
        return this.outputFile;
    }

    public void close() throws IOException {
        super.close();
        this.closed = true;
    }

    public void writeTo(OutputStream out) throws IOException {
        if (!this.closed) {
            throw new IOException("Stream not closed");
        }
        if (this.isInMemory()) {
            this.memoryOutputStream.writeTo(out);
        } else {
            FileInputStream fis = new FileInputStream(this.outputFile);
            try {
                IOUtils.copy((InputStream)fis, (OutputStream)out);
            }
            finally {
                IOUtils.closeQuietly((InputStream)fis);
            }
        }
    }

    @Override
    public void dispose() {
        this.memoryOutputStream = null;
    }
}

