/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.spamassassin;

import javax.inject.Inject;
import javax.mail.MessagingException;
import javax.mail.internet.MimeMessage;
import org.apache.commons.configuration2.Configuration;
import org.apache.james.metrics.api.MetricFactory;
import org.apache.james.protocols.api.ProtocolSession;
import org.apache.james.protocols.api.handler.ProtocolHandler;
import org.apache.james.protocols.smtp.SMTPSession;
import org.apache.james.protocols.smtp.dsn.DSNStatus;
import org.apache.james.protocols.smtp.hook.HookResult;
import org.apache.james.protocols.smtp.hook.HookReturnCode;
import org.apache.james.smtpserver.JamesMessageHook;
import org.apache.james.spamassassin.SpamAssassinConfiguration;
import org.apache.james.spamassassin.SpamAssassinInvoker;
import org.apache.james.spamassassin.SpamAssassinResult;
import org.apache.mailet.Mail;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SpamAssassinHandler
implements JamesMessageHook,
ProtocolHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(SpamAssassinHandler.class);
    private final MetricFactory metricFactory;
    private final SpamAssassinConfiguration spamAssassinConfiguration;
    private double spamdRejectionHits = 0.0;

    @Inject
    public SpamAssassinHandler(MetricFactory metricFactory, SpamAssassinConfiguration spamAssassinConfiguration) {
        this.metricFactory = metricFactory;
        this.spamAssassinConfiguration = spamAssassinConfiguration;
    }

    public void setSpamdRejectionHits(double spamdRejectionHits) {
        this.spamdRejectionHits = spamdRejectionHits;
    }

    public HookResult onMessage(SMTPSession session, Mail mail) {
        block5: {
            try {
                MimeMessage message = mail.getMessage();
                SpamAssassinInvoker sa = new SpamAssassinInvoker(this.metricFactory, this.spamAssassinConfiguration.getHost().getHostName(), this.spamAssassinConfiguration.getHost().getPort());
                SpamAssassinResult result = sa.scanMail(message);
                result.getHeadersAsAttributes().forEach(arg_0 -> ((Mail)mail).setAttribute(arg_0));
                if (!(this.spamdRejectionHits > 0.0)) break block5;
                try {
                    double hits = Double.parseDouble(result.getHits());
                    if (this.spamdRejectionHits <= hits) {
                        String buffer = "Rejected message from " + session.getAttachment(SMTPSession.SENDER, ProtocolSession.State.Transaction).toString() + " from host " + session.getRemoteAddress().getHostName() + " (" + session.getRemoteAddress().getAddress().getHostAddress() + ") This message reach the spam hits treshold. Required rejection hits: " + this.spamdRejectionHits + " hits: " + hits;
                        LOGGER.info(buffer);
                        return HookResult.builder().hookReturnCode(HookReturnCode.deny()).smtpDescription(DSNStatus.getStatus((int)5, (String)"7.0") + " This message reach the spam hits treshold. Please contact the Postmaster if the email is not SPAM. Message rejected").build();
                    }
                }
                catch (NumberFormatException numberFormatException) {}
            }
            catch (MessagingException e) {
                LOGGER.error(e.getMessage());
            }
        }
        return HookResult.DECLINED;
    }

    public void init(Configuration config) {
        this.setSpamdRejectionHits(config.getDouble("spamdRejectionHits", 0.0));
    }
}

