/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.spamassassin.mock;

import com.google.common.base.Preconditions;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.net.ServerSocket;
import java.net.Socket;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.output.NullOutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MockSpamd
implements Runnable {
    private static final Logger LOGGER = LoggerFactory.getLogger(MockSpamd.class);
    public static final String GTUBE = "-SPAM-";
    public static final String NOT_SPAM = "Spam: False ; 3 / 5";
    public static final String SPAM = "Spam: True ; 1000 / 5";
    private ServerSocket socket;
    private boolean isBinded = false;

    public int getPort() {
        Preconditions.checkState((boolean)this.isBinded, (Object)"SpamD mock server is not binded");
        return this.socket.getLocalPort();
    }

    public void bind() throws IOException {
        this.socket = new ServerSocket(0);
        this.isBinded = true;
    }

    @Override
    public void run() {
        try (ServerSocket serverSocket = this.socket;
             Socket spamd = serverSocket.accept();
             BufferedReader in = new BufferedReader(new InputStreamReader(spamd.getInputStream()));
             OutputStream out = spamd.getOutputStream();){
            this.handleRequest(in, out);
        }
        catch (IOException e) {
            LOGGER.error("Exception while handling answer", (Throwable)e);
        }
    }

    private void handleRequest(BufferedReader in, OutputStream out) throws IOException {
        if (this.isSpam(in)) {
            out.write(SPAM.getBytes());
        } else {
            out.write(NOT_SPAM.getBytes());
        }
        out.flush();
    }

    private boolean isSpam(BufferedReader in) throws IOException {
        try {
            boolean bl = in.lines().anyMatch(line -> line.contains(GTUBE));
            return bl;
        }
        finally {
            this.consume(in);
        }
    }

    private void consume(BufferedReader in) throws IOException {
        IOUtils.copy((Reader)in, (OutputStream)NullOutputStream.NULL_OUTPUT_STREAM, (Charset)StandardCharsets.UTF_8);
    }
}

