/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.spamassassin;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.apache.james.core.MailAddress;
import org.apache.james.core.builder.MimeMessageBuilder;
import org.apache.james.domainlist.api.DomainList;
import org.apache.james.metrics.api.MetricFactory;
import org.apache.james.metrics.tests.RecordingMetricFactory;
import org.apache.james.spamassassin.SpamAssassin;
import org.apache.james.spamassassin.SpamAssassinConfiguration;
import org.apache.james.spamassassin.SpamAssassinResult;
import org.apache.james.spamassassin.mock.MockSpamdExtension;
import org.apache.james.user.api.UsersRepository;
import org.apache.james.user.memory.MemoryUsersRepository;
import org.apache.james.util.Host;
import org.apache.mailet.Mail;
import org.apache.mailet.MailetConfig;
import org.apache.mailet.PerRecipientHeaders;
import org.apache.mailet.base.test.FakeMail;
import org.apache.mailet.base.test.FakeMailetConfig;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.RegisterExtension;

class SpamAssassinTest {
    private static final DomainList NO_DOMAIN_LIST = null;
    @RegisterExtension
    MockSpamdExtension spamd = new MockSpamdExtension();

    SpamAssassinTest() {
    }

    private SpamAssassin mailet() {
        return new SpamAssassin((MetricFactory)new RecordingMetricFactory(), (UsersRepository)MemoryUsersRepository.withVirtualHosting((DomainList)NO_DOMAIN_LIST), new SpamAssassinConfiguration(Host.from((String)"localhost", (int)this.spamd.getPort())));
    }

    @Test
    void serviceShouldWriteSpamAttributeOnMail() throws Exception {
        FakeMailetConfig mailetConfiguration = FakeMailetConfig.builder().mailetName("SpamAssassin").build();
        SpamAssassin mailet = this.mailet();
        mailet.init((MailetConfig)mailetConfiguration);
        FakeMail mail = FakeMail.builder().name("name").recipient("user1@exemple.com").mimeMessage(MimeMessageBuilder.mimeMessageBuilder().addToRecipient("user1@exemple.com").addFrom("sender@exemple.com").setSubject("testing").setText("Please!").build()).build();
        mailet.service((Mail)mail);
        Assertions.assertThat((List)((List)mail.getPerRecipientSpecificHeaders().getHeadersByRecipient().get((Object)new MailAddress("user1@exemple.com")).stream().map(PerRecipientHeaders.Header::getName).collect(ImmutableList.toImmutableList()))).contains((Object[])new String[]{SpamAssassinResult.FLAG_MAIL.asString(), SpamAssassinResult.STATUS_MAIL.asString()});
    }

    @Test
    void serviceShouldWriteMessageAsNotSpamWhenNotSpam() throws Exception {
        FakeMailetConfig mailetConfiguration = FakeMailetConfig.builder().mailetName("SpamAssassin").build();
        SpamAssassin mailet = this.mailet();
        mailet.init((MailetConfig)mailetConfiguration);
        FakeMail mail = FakeMail.builder().name("name").recipient("user1@exemple.com").mimeMessage(MimeMessageBuilder.mimeMessageBuilder().addToRecipient("user1@exemple.com").addFrom("sender@exemple.com").setSubject("testing").setText("Please!").build()).build();
        mailet.service((Mail)mail);
        Assertions.assertThat((Object)mail.getPerRecipientSpecificHeaders()).isEqualTo((Object)new PerRecipientHeaders().addHeaderForRecipient(PerRecipientHeaders.Header.builder().name(SpamAssassinResult.FLAG_MAIL.asString()).value("NO"), new MailAddress("user1@exemple.com")).addHeaderForRecipient(PerRecipientHeaders.Header.builder().name(SpamAssassinResult.STATUS_MAIL.asString()).value("No, hits=3 required=5"), new MailAddress("user1@exemple.com")));
    }

    @Test
    void serviceShouldWriteMessageAsSpamWhenSpam() throws Exception {
        FakeMailetConfig mailetConfiguration = FakeMailetConfig.builder().mailetName("SpamAssassin").build();
        SpamAssassin mailet = this.mailet();
        mailet.init((MailetConfig)mailetConfiguration);
        FakeMail mail = FakeMail.builder().name("name").recipient("user1@exemple.com").mimeMessage(MimeMessageBuilder.mimeMessageBuilder().addToRecipient("user1@exemple.com").addFrom("sender@exemple.com").setSubject("-SPAM- testing").setText("Please!").build()).build();
        mailet.service((Mail)mail);
        Assertions.assertThat((Object)mail.getPerRecipientSpecificHeaders()).isEqualTo((Object)new PerRecipientHeaders().addHeaderForRecipient(PerRecipientHeaders.Header.builder().name(SpamAssassinResult.FLAG_MAIL.asString()).value("YES"), new MailAddress("user1@exemple.com")).addHeaderForRecipient(PerRecipientHeaders.Header.builder().name(SpamAssassinResult.STATUS_MAIL.asString()).value("Yes, hits=1000 required=5"), new MailAddress("user1@exemple.com")));
    }

    @Test
    void getMailetInfoShouldReturnSpamAssasinMailetInformation() {
        Assertions.assertThat((String)this.mailet().getMailetInfo()).isEqualTo("Checks message against SpamAssassin");
    }
}

