/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.spamassassin;

import java.util.List;
import org.apache.james.spamassassin.SpamAssassinResult;
import org.apache.mailet.Attribute;
import org.apache.mailet.AttributeValue;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.SoftAssertions;
import org.junit.jupiter.api.Test;

public class SpamAssassinResultTest {
    @Test
    void buildShouldThrowWhenHitsIsNotGiven() {
        Assertions.assertThatThrownBy(() -> SpamAssassinResult.asSpam().requiredHits("4.0").build()).isInstanceOf(NullPointerException.class);
    }

    @Test
    void buildShouldThrowWhenRequiredHitsIsNotGiven() {
        Assertions.assertThatThrownBy(() -> SpamAssassinResult.asSpam().hits("4.0").build()).isInstanceOf(NullPointerException.class);
    }

    @Test
    void buildShouldWork() {
        String hits = "1.1";
        String requiredHits = "5.0";
        SpamAssassinResult spamAssassinResult = SpamAssassinResult.asSpam().hits(hits).requiredHits(requiredHits).build();
        SoftAssertions.assertSoftly(softly -> {
            softly.assertThat(spamAssassinResult.getHits()).isEqualTo(hits);
            softly.assertThat(spamAssassinResult.getRequiredHits()).isEqualTo(requiredHits);
            softly.assertThat(spamAssassinResult.getHeadersAsAttributes()).containsOnly((Object[])new Attribute[]{new Attribute(SpamAssassinResult.FLAG_MAIL, AttributeValue.of((String)"YES")), new Attribute(SpamAssassinResult.STATUS_MAIL, AttributeValue.of((String)"Yes, hits=1.1 required=5.0"))});
        });
    }

    @Test
    void headersAsAttributeShouldContainSpamHeaderWithYESValueWhenBuiltAsSpam() {
        String hits = "1.1";
        String requiredHits = "5.0";
        SpamAssassinResult spamAssassinResult = SpamAssassinResult.asSpam().hits(hits).requiredHits(requiredHits).build();
        Assertions.assertThat((List)spamAssassinResult.getHeadersAsAttributes()).contains((Object[])new Attribute[]{new Attribute(SpamAssassinResult.FLAG_MAIL, AttributeValue.of((String)"YES"))});
    }

    @Test
    void headersAsAttributeShouldContainSpamHeaderWithNOValueWhenBuiltAsHam() {
        String hits = "1.1";
        String requiredHits = "5.0";
        SpamAssassinResult spamAssassinResult = SpamAssassinResult.asHam().hits(hits).requiredHits(requiredHits).build();
        Assertions.assertThat((List)spamAssassinResult.getHeadersAsAttributes()).contains((Object[])new Attribute[]{new Attribute(SpamAssassinResult.FLAG_MAIL, AttributeValue.of((String)"NO"))});
    }
}

