/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.spamassassin;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.List;
import javax.mail.internet.MimeMessage;
import org.apache.james.core.Username;
import org.apache.james.metrics.api.MetricFactory;
import org.apache.james.metrics.tests.RecordingMetricFactory;
import org.apache.james.spamassassin.SpamAssassinExtension;
import org.apache.james.spamassassin.SpamAssassinInvoker;
import org.apache.james.spamassassin.SpamAssassinResult;
import org.apache.james.util.MimeMessageUtil;
import org.apache.mailet.Attribute;
import org.apache.mailet.AttributeValue;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;

@ExtendWith(value={SpamAssassinExtension.class})
@Tag(value="unstable")
public class SpamAssassinInvokerTest {
    public static final Username USERNAME = Username.of((String)"any@james");
    private SpamAssassinExtension.SpamAssassin spamAssassin;
    private SpamAssassinInvoker testee;

    @BeforeEach
    public void setup(SpamAssassinExtension.SpamAssassin spamAssassin) throws Exception {
        this.spamAssassin = spamAssassin;
        this.testee = new SpamAssassinInvoker((MetricFactory)new RecordingMetricFactory(), spamAssassin.getIp(), spamAssassin.getBindingPort());
    }

    @Test
    public void scanMailShouldModifyHitsField() throws Exception {
        MimeMessage mimeMessage = MimeMessageUtil.mimeMessageFromStream((InputStream)ClassLoader.getSystemResourceAsStream("eml/spam.eml"));
        SpamAssassinResult result = this.testee.scanMail(mimeMessage, USERNAME);
        Assertions.assertThat((String)result.getHits()).isNotEqualTo((Object)"?");
    }

    @Test
    public void scanMailShouldModifyRequiredHitsField() throws Exception {
        MimeMessage mimeMessage = MimeMessageUtil.mimeMessageFromStream((InputStream)ClassLoader.getSystemResourceAsStream("eml/spam.eml"));
        SpamAssassinResult result = this.testee.scanMail(mimeMessage, USERNAME);
        Assertions.assertThat((String)result.getRequiredHits()).isEqualTo("5.0");
    }

    @Test
    public void scanMailShouldModifyHeadersField() throws Exception {
        MimeMessage mimeMessage = MimeMessageUtil.mimeMessageFromStream((InputStream)ClassLoader.getSystemResourceAsStream("eml/spam.eml"));
        SpamAssassinResult result = this.testee.scanMail(mimeMessage, USERNAME);
        Assertions.assertThat((List)result.getHeadersAsAttributes()).isNotEmpty();
    }

    @Disabled(value="MAILBOX-377 This test is not stable, fails on our CI and thus is temporarily disabled")
    @Test
    public void scanMailShouldMarkAsSpamWhenKnownAsSpam() throws Exception {
        this.spamAssassin.train("user");
        MimeMessage mimeMessage = MimeMessageUtil.mimeMessageFromStream((InputStream)ClassLoader.getSystemResourceAsStream("spamassassin_db/spam/spam1"));
        SpamAssassinResult result = this.testee.scanMail(mimeMessage, USERNAME);
        Assertions.assertThat((List)result.getHeadersAsAttributes()).contains((Object[])new Attribute[]{new Attribute(SpamAssassinResult.FLAG_MAIL, AttributeValue.of((String)"YES"))});
    }

    @Test
    public void learnAsSpamShouldReturnTrueWhenLearningWorks() throws Exception {
        MimeMessage mimeMessage = MimeMessageUtil.mimeMessageFromStream((InputStream)ClassLoader.getSystemResourceAsStream("spamassassin_db/spam/spam2"));
        boolean result = this.testee.learnAsSpam(mimeMessage.getInputStream(), USERNAME);
        Assertions.assertThat((boolean)result).isTrue();
    }

    @Test
    public void scanMailShouldMarkAsSpamWhenMessageAlreadyLearnedAsSpam() throws Exception {
        MimeMessage mimeMessage = MimeMessageUtil.mimeMessageFromStream((InputStream)ClassLoader.getSystemResourceAsStream("spamassassin_db/spam/spam1"));
        byte[] messageAsBytes = MimeMessageUtil.asString((MimeMessage)mimeMessage).getBytes(StandardCharsets.UTF_8);
        this.testee.learnAsSpam((InputStream)new ByteArrayInputStream(messageAsBytes), USERNAME);
        SpamAssassinResult result = this.testee.scanMail(mimeMessage, USERNAME);
        Assertions.assertThat((List)result.getHeadersAsAttributes()).contains((Object[])new Attribute[]{new Attribute(SpamAssassinResult.FLAG_MAIL, AttributeValue.of((String)"YES"))});
    }

    @Test
    public void learnAsHamShouldReturnTrueWhenLearningWorks() throws Exception {
        MimeMessage mimeMessage = MimeMessageUtil.mimeMessageFromStream((InputStream)ClassLoader.getSystemResourceAsStream("spamassassin_db/ham/ham2"));
        boolean result = this.testee.learnAsHam(mimeMessage.getInputStream(), USERNAME);
        Assertions.assertThat((boolean)result).isTrue();
    }

    @Test
    public void scanMailShouldMarkAsHamWhenMessageAlreadyLearnedAsHam() throws Exception {
        MimeMessage mimeMessage = MimeMessageUtil.mimeMessageFromStream((InputStream)ClassLoader.getSystemResourceAsStream("spamassassin_db/ham/ham1"));
        this.testee.learnAsHam(mimeMessage.getInputStream(), USERNAME);
        SpamAssassinResult result = this.testee.scanMail(mimeMessage, USERNAME);
        Assertions.assertThat((List)result.getHeadersAsAttributes()).contains((Object[])new Attribute[]{new Attribute(SpamAssassinResult.FLAG_MAIL, AttributeValue.of((String)"NO"))});
    }

    @Test
    public void learnAsHamShouldAllowToForgetSpam() throws Exception {
        MimeMessage mimeMessage = MimeMessageUtil.mimeMessageFromStream((InputStream)ClassLoader.getSystemResourceAsStream("eml/spam.eml"));
        byte[] messageAsBytes = MimeMessageUtil.asString((MimeMessage)mimeMessage).getBytes(StandardCharsets.UTF_8);
        this.testee.learnAsSpam((InputStream)new ByteArrayInputStream(messageAsBytes), USERNAME);
        this.testee.learnAsHam((InputStream)new ByteArrayInputStream(messageAsBytes), USERNAME);
        SpamAssassinResult result = this.testee.scanMail(mimeMessage, USERNAME);
        Assertions.assertThat((List)result.getHeadersAsAttributes()).contains((Object[])new Attribute[]{new Attribute(SpamAssassinResult.FLAG_MAIL, AttributeValue.of((String)"NO"))});
    }
}

