/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.spamassassin;

import com.google.common.base.Preconditions;
import java.util.HashMap;
import java.util.Optional;
import javax.mail.MessagingException;
import javax.mail.internet.AddressException;
import javax.mail.internet.MimeMessage;
import org.apache.james.core.MailAddress;
import org.apache.james.core.MaybeSender;
import org.apache.james.core.builder.MimeMessageBuilder;
import org.apache.james.metrics.api.MetricFactory;
import org.apache.james.metrics.tests.RecordingMetricFactory;
import org.apache.james.protocols.api.ProtocolSession;
import org.apache.james.protocols.smtp.SMTPSession;
import org.apache.james.protocols.smtp.hook.HookResult;
import org.apache.james.protocols.smtp.hook.HookReturnCode;
import org.apache.james.protocols.smtp.utils.BaseFakeSMTPSession;
import org.apache.james.spamassassin.SpamAssassinConfiguration;
import org.apache.james.spamassassin.SpamAssassinHandler;
import org.apache.james.spamassassin.SpamAssassinResult;
import org.apache.james.spamassassin.mock.MockSpamdExtension;
import org.apache.james.util.Host;
import org.apache.mailet.Attribute;
import org.apache.mailet.AttributeValue;
import org.apache.mailet.Mail;
import org.apache.mailet.base.test.FakeMail;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ObjectAssert;
import org.assertj.core.api.OptionalAssert;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.RegisterExtension;

class SpamAssassinHandlerTest {
    private static final String SPAMD_HOST = "localhost";
    private static final Attribute FLAG_MAIL_ATTRIBUTE_NO = new Attribute(SpamAssassinResult.FLAG_MAIL, AttributeValue.of((String)"NO"));
    private static final Attribute FLAG_MAIL_ATTRIBUTE_YES = new Attribute(SpamAssassinResult.FLAG_MAIL, AttributeValue.of((String)"YES"));
    private Mail mockedMail;
    @RegisterExtension
    MockSpamdExtension spamd = new MockSpamdExtension();

    SpamAssassinHandlerTest() {
    }

    private SMTPSession setupMockedSMTPSession(Mail mail) {
        this.mockedMail = mail;
        return new BaseFakeSMTPSession(){
            private final HashMap<ProtocolSession.AttachmentKey<?>, Object> sessionState = new HashMap();
            private final HashMap<ProtocolSession.AttachmentKey<?>, Object> connectionState = new HashMap();
            private boolean relayingAllowed;

            public <T> Optional<T> setAttachment(ProtocolSession.AttachmentKey<T> key, T value, ProtocolSession.State state) {
                Preconditions.checkNotNull(key, (Object)"key cannot be null");
                Preconditions.checkNotNull(value, (Object)"value cannot be null");
                if (state == ProtocolSession.State.Connection) {
                    return key.convert(this.connectionState.put(key, value));
                }
                return key.convert(this.sessionState.put(key, value));
            }

            public <T> Optional<T> removeAttachment(ProtocolSession.AttachmentKey<T> key, ProtocolSession.State state) {
                Preconditions.checkNotNull(key, (Object)"key cannot be null");
                if (state == ProtocolSession.State.Connection) {
                    return key.convert(this.connectionState.remove(key));
                }
                return key.convert(this.sessionState.remove(key));
            }

            public <T> Optional<T> getAttachment(ProtocolSession.AttachmentKey<T> key, ProtocolSession.State state) {
                try {
                    this.sessionState.put(SMTPSession.SENDER, MaybeSender.of((MailAddress)new MailAddress("sender@james.apache.org")));
                }
                catch (AddressException e) {
                    throw new RuntimeException(e);
                }
                if (state == ProtocolSession.State.Connection) {
                    return key.convert(this.connectionState.get(key));
                }
                return key.convert(this.sessionState.get(key));
            }

            public boolean isRelayingAllowed() {
                return this.relayingAllowed;
            }

            public void setRelayingAllowed(boolean relayingAllowed) {
                this.relayingAllowed = relayingAllowed;
            }
        };
    }

    private Mail setupMockedMail(MimeMessage message) throws MessagingException {
        return FakeMail.builder().name("name").mimeMessage(message).build();
    }

    private MimeMessage setupMockedMimeMessage(String text) throws MessagingException {
        return MimeMessageBuilder.mimeMessageBuilder().setText(text).build();
    }

    @Test
    void testNonSpam() throws Exception {
        SMTPSession session = this.setupMockedSMTPSession(this.setupMockedMail(this.setupMockedMimeMessage("test")));
        SpamAssassinHandler handler = new SpamAssassinHandler((MetricFactory)new RecordingMetricFactory(), new SpamAssassinConfiguration(Host.from((String)SPAMD_HOST, (int)this.spamd.getPort())));
        handler.setSpamdRejectionHits(200.0);
        HookResult response = handler.onMessage(session, this.mockedMail);
        ((ObjectAssert)Assertions.assertThat((Object)HookReturnCode.declined()).describedAs("Email was not rejected", new Object[0])).isEqualTo((Object)response.getResult());
        ((OptionalAssert)Assertions.assertThat((Optional)this.mockedMail.getAttribute(SpamAssassinResult.FLAG_MAIL)).describedAs("email was not spam", new Object[0])).contains((Object)FLAG_MAIL_ATTRIBUTE_NO);
        ((OptionalAssert)Assertions.assertThat((Optional)this.mockedMail.getAttribute(SpamAssassinResult.STATUS_MAIL)).withFailMessage("spam hits", new Object[0])).isPresent();
    }

    @Test
    void testSpam() throws Exception {
        SMTPSession session = this.setupMockedSMTPSession(this.setupMockedMail(this.setupMockedMimeMessage("-SPAM-")));
        SpamAssassinHandler handler = new SpamAssassinHandler((MetricFactory)new RecordingMetricFactory(), new SpamAssassinConfiguration(Host.from((String)SPAMD_HOST, (int)this.spamd.getPort())));
        handler.setSpamdRejectionHits(2000.0);
        HookResult response = handler.onMessage(session, this.mockedMail);
        ((ObjectAssert)Assertions.assertThat((Object)HookReturnCode.declined()).describedAs("Email was not rejected", new Object[0])).isEqualTo((Object)response.getResult());
        ((OptionalAssert)Assertions.assertThat((Optional)this.mockedMail.getAttribute(SpamAssassinResult.FLAG_MAIL)).describedAs("email was spam", new Object[0])).contains((Object)FLAG_MAIL_ATTRIBUTE_YES);
        ((OptionalAssert)Assertions.assertThat((Optional)this.mockedMail.getAttribute(SpamAssassinResult.STATUS_MAIL)).withFailMessage("spam hits", new Object[0])).isPresent();
    }

    @Test
    void testSpamReject() throws Exception {
        SMTPSession session = this.setupMockedSMTPSession(this.setupMockedMail(this.setupMockedMimeMessage("-SPAM-")));
        SpamAssassinHandler handler = new SpamAssassinHandler((MetricFactory)new RecordingMetricFactory(), new SpamAssassinConfiguration(Host.from((String)SPAMD_HOST, (int)this.spamd.getPort())));
        handler.setSpamdRejectionHits(200.0);
        HookResult response = handler.onMessage(session, this.mockedMail);
        ((ObjectAssert)Assertions.assertThat((Object)HookReturnCode.deny()).describedAs("Email was rejected", new Object[0])).isEqualTo((Object)response.getResult());
        ((OptionalAssert)Assertions.assertThat((Optional)this.mockedMail.getAttribute(SpamAssassinResult.FLAG_MAIL)).describedAs("email was spam", new Object[0])).contains((Object)FLAG_MAIL_ATTRIBUTE_YES);
        ((OptionalAssert)Assertions.assertThat((Optional)this.mockedMail.getAttribute(SpamAssassinResult.STATUS_MAIL)).withFailMessage("spam hits", new Object[0])).isPresent();
    }
}

